<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ExtraDataForm StructType
 * @subpackage Structs
 */
class Sales_ExtraDataForm extends DistributableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The FormTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FormTitle;
    /**
     * The FormType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormType;
    /**
     * The InternalFormName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalFormName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.ExtraDataForm
     * @uses Sales_ExtraDataForm::setDescription()
     * @uses Sales_ExtraDataForm::setFormTitle()
     * @uses Sales_ExtraDataForm::setFormType()
     * @uses Sales_ExtraDataForm::setInternalFormName()
     * @uses Sales_ExtraDataForm::setIsActive()
     * @uses Sales_ExtraDataForm::setName()
     * @uses Sales_ExtraDataForm::setOrganizationUnitId()
     * @uses Sales_ExtraDataForm::setSystemName()
     * @uses Sales_ExtraDataForm::setVisibleBySubordinates()
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\GlobalString $formTitle
     * @param string $formType
     * @param string $internalFormName
     * @param bool $isActive
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $systemName
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\GlobalString $description = null, \patest\StructType\GlobalString $formTitle = null, $formType = null, $internalFormName = null, $isActive = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $systemName = null, $visibleBySubordinates = null)
    {
        $this
            ->setDescription($description)
            ->setFormTitle($formTitle)
            ->setFormType($formType)
            ->setInternalFormName($internalFormName)
            ->setIsActive($isActive)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSystemName($systemName)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FormTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFormTitle()
    {
        return isset($this->FormTitle) ? $this->FormTitle : null;
    }
    /**
     * Set FormTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $formTitle
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setFormTitle(\patest\StructType\GlobalString $formTitle = null)
    {
        if (is_null($formTitle) || (is_array($formTitle) && empty($formTitle))) {
            unset($this->FormTitle);
        } else {
            $this->FormTitle = $formTitle;
        }
        return $this;
    }
    /**
     * Get FormType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormType()
    {
        return isset($this->FormType) ? $this->FormType : null;
    }
    /**
     * Set FormType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionMessageInfoType::valueIsValid()
     * @uses \patest\EnumType\TransactionMessageInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formType
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setFormType($formType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionMessageInfoType::valueIsValid($formType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionMessageInfoType', is_array($formType) ? implode(', ', $formType) : var_export($formType, true), implode(', ', \patest\EnumType\TransactionMessageInfoType::getValidValues())), __LINE__);
        }
        if (is_null($formType) || (is_array($formType) && empty($formType))) {
            unset($this->FormType);
        } else {
            $this->FormType = $formType;
        }
        return $this;
    }
    /**
     * Get InternalFormName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalFormName()
    {
        return isset($this->InternalFormName) ? $this->InternalFormName : null;
    }
    /**
     * Set InternalFormName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalFormName
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setInternalFormName($internalFormName = null)
    {
        // validation for constraint: string
        if (!is_null($internalFormName) && !is_string($internalFormName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalFormName, true), gettype($internalFormName)), __LINE__);
        }
        if (is_null($internalFormName) || (is_array($internalFormName) && empty($internalFormName))) {
            unset($this->InternalFormName);
        } else {
            $this->InternalFormName = $internalFormName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_ExtraDataForm
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
