<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.DonationItemDetails StructType
 * @subpackage Structs
 */
class Sales_DonationItemDetails extends Sales_AbstractItemDetails
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The DonationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationName;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FundName;
    /**
     * Constructor method for Sales.DonationItemDetails
     * @uses Sales_DonationItemDetails::setDescription()
     * @uses Sales_DonationItemDetails::setDonationDate()
     * @uses Sales_DonationItemDetails::setDonationName()
     * @uses Sales_DonationItemDetails::setFundName()
     * @param string $description
     * @param string $donationDate
     * @param string $donationName
     * @param string $fundName
     */
    public function __construct($description = null, $donationDate = null, $donationName = null, $fundName = null)
    {
        $this
            ->setDescription($description)
            ->setDonationDate($donationDate)
            ->setDonationName($donationName)
            ->setFundName($fundName);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Sales_DonationItemDetails
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\Sales_DonationItemDetails
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get DonationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationName()
    {
        return isset($this->DonationName) ? $this->DonationName : null;
    }
    /**
     * Set DonationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationName
     * @return \patest\StructType\Sales_DonationItemDetails
     */
    public function setDonationName($donationName = null)
    {
        // validation for constraint: string
        if (!is_null($donationName) && !is_string($donationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationName, true), gettype($donationName)), __LINE__);
        }
        if (is_null($donationName) || (is_array($donationName) && empty($donationName))) {
            unset($this->DonationName);
        } else {
            $this->DonationName = $donationName;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundName
     * @return \patest\StructType\Sales_DonationItemDetails
     */
    public function setFundName($fundName = null)
    {
        // validation for constraint: string
        if (!is_null($fundName) && !is_string($fundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundName, true), gettype($fundName)), __LINE__);
        }
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
}
