<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ClientIdentification StructType
 * @subpackage Structs
 */
class Sales_ClientIdentification extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreditCardToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardToken;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The PriceTypeSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeSpecificData;
    /**
     * Constructor method for Sales.ClientIdentification
     * @uses Sales_ClientIdentification::setClientId()
     * @uses Sales_ClientIdentification::setCreditCardToken()
     * @uses Sales_ClientIdentification::setEmail()
     * @uses Sales_ClientIdentification::setPriceTypeSpecificData()
     * @param string $clientId
     * @param string $creditCardToken
     * @param string $email
     * @param string $priceTypeSpecificData
     */
    public function __construct($clientId = null, $creditCardToken = null, $email = null, $priceTypeSpecificData = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreditCardToken($creditCardToken)
            ->setEmail($email)
            ->setPriceTypeSpecificData($priceTypeSpecificData);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_ClientIdentification
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreditCardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return isset($this->CreditCardToken) ? $this->CreditCardToken : null;
    }
    /**
     * Set CreditCardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardToken
     * @return \patest\StructType\Sales_ClientIdentification
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardToken, true), gettype($creditCardToken)), __LINE__);
        }
        if (is_null($creditCardToken) || (is_array($creditCardToken) && empty($creditCardToken))) {
            unset($this->CreditCardToken);
        } else {
            $this->CreditCardToken = $creditCardToken;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Sales_ClientIdentification
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get PriceTypeSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeSpecificData()
    {
        return isset($this->PriceTypeSpecificData) ? $this->PriceTypeSpecificData : null;
    }
    /**
     * Set PriceTypeSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeSpecificData
     * @return \patest\StructType\Sales_ClientIdentification
     */
    public function setPriceTypeSpecificData($priceTypeSpecificData = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeSpecificData) && !is_string($priceTypeSpecificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeSpecificData, true), gettype($priceTypeSpecificData)), __LINE__);
        }
        if (is_null($priceTypeSpecificData) || (is_array($priceTypeSpecificData) && empty($priceTypeSpecificData))) {
            unset($this->PriceTypeSpecificData);
        } else {
            $this->PriceTypeSpecificData = $priceTypeSpecificData;
        }
        return $this;
    }
}
