<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BenefitPackageElementInstance StructType
 * @subpackage Structs
 */
class Sales_BenefitPackageElementInstance extends PersistableEntity
{
    /**
     * The BenefitDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitDescription;
    /**
     * The BenefitGrantId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitGrantId;
    /**
     * The BenefitPackageElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitPackageElementId;
    /**
     * The BenefitType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitType;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DefaultNum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultNum;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Enabled;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The LastUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumAllocated;
    /**
     * The NumUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumUsed;
    /**
     * The ProductInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductInstanceId;
    /**
     * The ReturnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnDate;
    /**
     * The TransactionLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionLocalId;
    /**
     * Constructor method for Sales.BenefitPackageElementInstance
     * @uses Sales_BenefitPackageElementInstance::setBenefitDescription()
     * @uses Sales_BenefitPackageElementInstance::setBenefitGrantId()
     * @uses Sales_BenefitPackageElementInstance::setBenefitPackageElementId()
     * @uses Sales_BenefitPackageElementInstance::setBenefitType()
     * @uses Sales_BenefitPackageElementInstance::setClientId()
     * @uses Sales_BenefitPackageElementInstance::setCreationDate()
     * @uses Sales_BenefitPackageElementInstance::setDefaultNum()
     * @uses Sales_BenefitPackageElementInstance::setEnabled()
     * @uses Sales_BenefitPackageElementInstance::setExpiryDate()
     * @uses Sales_BenefitPackageElementInstance::setLastUpdate()
     * @uses Sales_BenefitPackageElementInstance::setName()
     * @uses Sales_BenefitPackageElementInstance::setNumAllocated()
     * @uses Sales_BenefitPackageElementInstance::setNumUsed()
     * @uses Sales_BenefitPackageElementInstance::setProductInstanceId()
     * @uses Sales_BenefitPackageElementInstance::setReturnDate()
     * @uses Sales_BenefitPackageElementInstance::setTransactionLocalId()
     * @param string $benefitDescription
     * @param string $benefitGrantId
     * @param string $benefitPackageElementId
     * @param string $benefitType
     * @param string $clientId
     * @param string $creationDate
     * @param int $defaultNum
     * @param bool $enabled
     * @param string $expiryDate
     * @param string $lastUpdate
     * @param \patest\StructType\GlobalString $name
     * @param int $numAllocated
     * @param int $numUsed
     * @param string $productInstanceId
     * @param string $returnDate
     * @param int $transactionLocalId
     */
    public function __construct($benefitDescription = null, $benefitGrantId = null, $benefitPackageElementId = null, $benefitType = null, $clientId = null, $creationDate = null, $defaultNum = null, $enabled = null, $expiryDate = null, $lastUpdate = null, \patest\StructType\GlobalString $name = null, $numAllocated = null, $numUsed = null, $productInstanceId = null, $returnDate = null, $transactionLocalId = null)
    {
        $this
            ->setBenefitDescription($benefitDescription)
            ->setBenefitGrantId($benefitGrantId)
            ->setBenefitPackageElementId($benefitPackageElementId)
            ->setBenefitType($benefitType)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setDefaultNum($defaultNum)
            ->setEnabled($enabled)
            ->setExpiryDate($expiryDate)
            ->setLastUpdate($lastUpdate)
            ->setName($name)
            ->setNumAllocated($numAllocated)
            ->setNumUsed($numUsed)
            ->setProductInstanceId($productInstanceId)
            ->setReturnDate($returnDate)
            ->setTransactionLocalId($transactionLocalId);
    }
    /**
     * Get BenefitDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitDescription()
    {
        return isset($this->BenefitDescription) ? $this->BenefitDescription : null;
    }
    /**
     * Set BenefitDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitDescription
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setBenefitDescription($benefitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($benefitDescription) && !is_string($benefitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitDescription, true), gettype($benefitDescription)), __LINE__);
        }
        if (is_null($benefitDescription) || (is_array($benefitDescription) && empty($benefitDescription))) {
            unset($this->BenefitDescription);
        } else {
            $this->BenefitDescription = $benefitDescription;
        }
        return $this;
    }
    /**
     * Get BenefitGrantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitGrantId()
    {
        return isset($this->BenefitGrantId) ? $this->BenefitGrantId : null;
    }
    /**
     * Set BenefitGrantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitGrantId
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setBenefitGrantId($benefitGrantId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitGrantId) && !is_string($benefitGrantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitGrantId, true), gettype($benefitGrantId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitGrantId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitGrantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitGrantId, true)), __LINE__);
        }
        if (is_null($benefitGrantId) || (is_array($benefitGrantId) && empty($benefitGrantId))) {
            unset($this->BenefitGrantId);
        } else {
            $this->BenefitGrantId = $benefitGrantId;
        }
        return $this;
    }
    /**
     * Get BenefitPackageElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitPackageElementId()
    {
        return isset($this->BenefitPackageElementId) ? $this->BenefitPackageElementId : null;
    }
    /**
     * Set BenefitPackageElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitPackageElementId
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setBenefitPackageElementId($benefitPackageElementId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitPackageElementId) && !is_string($benefitPackageElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitPackageElementId, true), gettype($benefitPackageElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitPackageElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitPackageElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitPackageElementId, true)), __LINE__);
        }
        if (is_null($benefitPackageElementId) || (is_array($benefitPackageElementId) && empty($benefitPackageElementId))) {
            unset($this->BenefitPackageElementId);
        } else {
            $this->BenefitPackageElementId = $benefitPackageElementId;
        }
        return $this;
    }
    /**
     * Get BenefitType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitType()
    {
        return isset($this->BenefitType) ? $this->BenefitType : null;
    }
    /**
     * Set BenefitType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BenefitType::valueIsValid()
     * @uses \patest\EnumType\BenefitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $benefitType
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setBenefitType($benefitType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BenefitType::valueIsValid($benefitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BenefitType', is_array($benefitType) ? implode(', ', $benefitType) : var_export($benefitType, true), implode(', ', \patest\EnumType\BenefitType::getValidValues())), __LINE__);
        }
        if (is_null($benefitType) || (is_array($benefitType) && empty($benefitType))) {
            unset($this->BenefitType);
        } else {
            $this->BenefitType = $benefitType;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DefaultNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultNum()
    {
        return isset($this->DefaultNum) ? $this->DefaultNum : null;
    }
    /**
     * Set DefaultNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultNum
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setDefaultNum($defaultNum = null)
    {
        // validation for constraint: int
        if (!is_null($defaultNum) && !(is_int($defaultNum) || ctype_digit($defaultNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultNum, true), gettype($defaultNum)), __LINE__);
        }
        if (is_null($defaultNum) || (is_array($defaultNum) && empty($defaultNum))) {
            unset($this->DefaultNum);
        } else {
            $this->DefaultNum = $defaultNum;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnabled()
    {
        return isset($this->Enabled) ? $this->Enabled : null;
    }
    /**
     * Set Enabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enabled
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        if (is_null($enabled) || (is_array($enabled) && empty($enabled))) {
            unset($this->Enabled);
        } else {
            $this->Enabled = $enabled;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get LastUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdate()
    {
        return isset($this->LastUpdate) ? $this->LastUpdate : null;
    }
    /**
     * Set LastUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdate
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdate, true), gettype($lastUpdate)), __LINE__);
        }
        if (is_null($lastUpdate) || (is_array($lastUpdate) && empty($lastUpdate))) {
            unset($this->LastUpdate);
        } else {
            $this->LastUpdate = $lastUpdate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumAllocated()
    {
        return isset($this->NumAllocated) ? $this->NumAllocated : null;
    }
    /**
     * Set NumAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numAllocated
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setNumAllocated($numAllocated = null)
    {
        // validation for constraint: int
        if (!is_null($numAllocated) && !(is_int($numAllocated) || ctype_digit($numAllocated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numAllocated, true), gettype($numAllocated)), __LINE__);
        }
        if (is_null($numAllocated) || (is_array($numAllocated) && empty($numAllocated))) {
            unset($this->NumAllocated);
        } else {
            $this->NumAllocated = $numAllocated;
        }
        return $this;
    }
    /**
     * Get NumUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumUsed()
    {
        return isset($this->NumUsed) ? $this->NumUsed : null;
    }
    /**
     * Set NumUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numUsed
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setNumUsed($numUsed = null)
    {
        // validation for constraint: int
        if (!is_null($numUsed) && !(is_int($numUsed) || ctype_digit($numUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numUsed, true), gettype($numUsed)), __LINE__);
        }
        if (is_null($numUsed) || (is_array($numUsed) && empty($numUsed))) {
            unset($this->NumUsed);
        } else {
            $this->NumUsed = $numUsed;
        }
        return $this;
    }
    /**
     * Get ProductInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductInstanceId()
    {
        return isset($this->ProductInstanceId) ? $this->ProductInstanceId : null;
    }
    /**
     * Set ProductInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productInstanceId
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setProductInstanceId($productInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($productInstanceId) && !is_string($productInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productInstanceId, true), gettype($productInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productInstanceId, true)), __LINE__);
        }
        if (is_null($productInstanceId) || (is_array($productInstanceId) && empty($productInstanceId))) {
            unset($this->ProductInstanceId);
        } else {
            $this->ProductInstanceId = $productInstanceId;
        }
        return $this;
    }
    /**
     * Get ReturnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnDate()
    {
        return isset($this->ReturnDate) ? $this->ReturnDate : null;
    }
    /**
     * Set ReturnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnDate
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setReturnDate($returnDate = null)
    {
        // validation for constraint: string
        if (!is_null($returnDate) && !is_string($returnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDate, true), gettype($returnDate)), __LINE__);
        }
        if (is_null($returnDate) || (is_array($returnDate) && empty($returnDate))) {
            unset($this->ReturnDate);
        } else {
            $this->ReturnDate = $returnDate;
        }
        return $this;
    }
    /**
     * Get TransactionLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionLocalId()
    {
        return isset($this->TransactionLocalId) ? $this->TransactionLocalId : null;
    }
    /**
     * Set TransactionLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionLocalId
     * @return \patest\StructType\Sales_BenefitPackageElementInstance
     */
    public function setTransactionLocalId($transactionLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionLocalId) && !(is_int($transactionLocalId) || ctype_digit($transactionLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionLocalId, true), gettype($transactionLocalId)), __LINE__);
        }
        if (is_null($transactionLocalId) || (is_array($transactionLocalId) && empty($transactionLocalId))) {
            unset($this->TransactionLocalId);
        } else {
            $this->TransactionLocalId = $transactionLocalId;
        }
        return $this;
    }
}
