<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPriceModifiers-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnPriceModifiers-Request
 * @subpackage Structs
 */
class ReturnPriceModifiers_Request extends ExtensibleDataContract
{
    /**
     * The DestinationTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationTransactionGuid;
    /**
     * The DestinationTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTransactionSnapshotType;
    /**
     * The PriceModifierIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPriceModifierIdentity
     */
    public $PriceModifierIds;
    /**
     * The ShouldReturnToOriginalTill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldReturnToOriginalTill;
    /**
     * Constructor method for ReturnPriceModifiers-Request
     * @uses ReturnPriceModifiers_Request::setDestinationTransactionGuid()
     * @uses ReturnPriceModifiers_Request::setDestinationTransactionSnapshotType()
     * @uses ReturnPriceModifiers_Request::setPriceModifierIds()
     * @uses ReturnPriceModifiers_Request::setShouldReturnToOriginalTill()
     * @param string $destinationTransactionGuid
     * @param string $destinationTransactionSnapshotType
     * @param \patest\ArrayType\ArrayOfPriceModifierIdentity $priceModifierIds
     * @param bool $shouldReturnToOriginalTill
     */
    public function __construct($destinationTransactionGuid = null, $destinationTransactionSnapshotType = null, \patest\ArrayType\ArrayOfPriceModifierIdentity $priceModifierIds = null, $shouldReturnToOriginalTill = null)
    {
        $this
            ->setDestinationTransactionGuid($destinationTransactionGuid)
            ->setDestinationTransactionSnapshotType($destinationTransactionSnapshotType)
            ->setPriceModifierIds($priceModifierIds)
            ->setShouldReturnToOriginalTill($shouldReturnToOriginalTill);
    }
    /**
     * Get DestinationTransactionGuid value
     * @return string|null
     */
    public function getDestinationTransactionGuid()
    {
        return $this->DestinationTransactionGuid;
    }
    /**
     * Set DestinationTransactionGuid value
     * @param string $destinationTransactionGuid
     * @return \patest\StructType\ReturnPriceModifiers_Request
     */
    public function setDestinationTransactionGuid($destinationTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($destinationTransactionGuid) && !is_string($destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationTransactionGuid, true), gettype($destinationTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationTransactionGuid, true)), __LINE__);
        }
        $this->DestinationTransactionGuid = $destinationTransactionGuid;
        return $this;
    }
    /**
     * Get DestinationTransactionSnapshotType value
     * @return string|null
     */
    public function getDestinationTransactionSnapshotType()
    {
        return $this->DestinationTransactionSnapshotType;
    }
    /**
     * Set DestinationTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationTransactionSnapshotType
     * @return \patest\StructType\ReturnPriceModifiers_Request
     */
    public function setDestinationTransactionSnapshotType($destinationTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($destinationTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($destinationTransactionSnapshotType) ? implode(', ', $destinationTransactionSnapshotType) : var_export($destinationTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->DestinationTransactionSnapshotType = $destinationTransactionSnapshotType;
        return $this;
    }
    /**
     * Get PriceModifierIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPriceModifierIdentity|null
     */
    public function getPriceModifierIds()
    {
        return isset($this->PriceModifierIds) ? $this->PriceModifierIds : null;
    }
    /**
     * Set PriceModifierIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPriceModifierIdentity $priceModifierIds
     * @return \patest\StructType\ReturnPriceModifiers_Request
     */
    public function setPriceModifierIds(\patest\ArrayType\ArrayOfPriceModifierIdentity $priceModifierIds = null)
    {
        if (is_null($priceModifierIds) || (is_array($priceModifierIds) && empty($priceModifierIds))) {
            unset($this->PriceModifierIds);
        } else {
            $this->PriceModifierIds = $priceModifierIds;
        }
        return $this;
    }
    /**
     * Get ShouldReturnToOriginalTill value
     * @return bool|null
     */
    public function getShouldReturnToOriginalTill()
    {
        return $this->ShouldReturnToOriginalTill;
    }
    /**
     * Set ShouldReturnToOriginalTill value
     * @param bool $shouldReturnToOriginalTill
     * @return \patest\StructType\ReturnPriceModifiers_Request
     */
    public function setShouldReturnToOriginalTill($shouldReturnToOriginalTill = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldReturnToOriginalTill) && !is_bool($shouldReturnToOriginalTill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldReturnToOriginalTill, true), gettype($shouldReturnToOriginalTill)), __LINE__);
        }
        $this->ShouldReturnToOriginalTill = $shouldReturnToOriginalTill;
        return $this;
    }
}
