<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnBasketItems-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnBasketItems-Request
 * @subpackage Structs
 */
class ReturnBasketItems_Request extends ExtensibleDataContract
{
    /**
     * The DestinationTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationTransactionGuid;
    /**
     * The DestinationTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTransactionSnapshotType;
    /**
     * The IntendedForExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IntendedForExchange;
    /**
     * The IsPostScanUpgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPostScanUpgrade;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfItemIdentity
     */
    public $ItemIds;
    /**
     * The ServiceSpecificItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfServiceSpecificItemIdentity
     */
    public $ServiceSpecificItemIds;
    /**
     * The ShouldReturnToOriginalTill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldReturnToOriginalTill;
    /**
     * Constructor method for ReturnBasketItems-Request
     * @uses ReturnBasketItems_Request::setDestinationTransactionGuid()
     * @uses ReturnBasketItems_Request::setDestinationTransactionSnapshotType()
     * @uses ReturnBasketItems_Request::setIntendedForExchange()
     * @uses ReturnBasketItems_Request::setIsPostScanUpgrade()
     * @uses ReturnBasketItems_Request::setItemIds()
     * @uses ReturnBasketItems_Request::setServiceSpecificItemIds()
     * @uses ReturnBasketItems_Request::setShouldReturnToOriginalTill()
     * @param string $destinationTransactionGuid
     * @param string $destinationTransactionSnapshotType
     * @param bool $intendedForExchange
     * @param bool $isPostScanUpgrade
     * @param \patest\ArrayType\ArrayOfItemIdentity $itemIds
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds
     * @param bool $shouldReturnToOriginalTill
     */
    public function __construct($destinationTransactionGuid = null, $destinationTransactionSnapshotType = null, $intendedForExchange = null, $isPostScanUpgrade = null, \patest\ArrayType\ArrayOfItemIdentity $itemIds = null, \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds = null, $shouldReturnToOriginalTill = null)
    {
        $this
            ->setDestinationTransactionGuid($destinationTransactionGuid)
            ->setDestinationTransactionSnapshotType($destinationTransactionSnapshotType)
            ->setIntendedForExchange($intendedForExchange)
            ->setIsPostScanUpgrade($isPostScanUpgrade)
            ->setItemIds($itemIds)
            ->setServiceSpecificItemIds($serviceSpecificItemIds)
            ->setShouldReturnToOriginalTill($shouldReturnToOriginalTill);
    }
    /**
     * Get DestinationTransactionGuid value
     * @return string|null
     */
    public function getDestinationTransactionGuid()
    {
        return $this->DestinationTransactionGuid;
    }
    /**
     * Set DestinationTransactionGuid value
     * @param string $destinationTransactionGuid
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setDestinationTransactionGuid($destinationTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($destinationTransactionGuid) && !is_string($destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationTransactionGuid, true), gettype($destinationTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationTransactionGuid, true)), __LINE__);
        }
        $this->DestinationTransactionGuid = $destinationTransactionGuid;
        return $this;
    }
    /**
     * Get DestinationTransactionSnapshotType value
     * @return string|null
     */
    public function getDestinationTransactionSnapshotType()
    {
        return $this->DestinationTransactionSnapshotType;
    }
    /**
     * Set DestinationTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationTransactionSnapshotType
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setDestinationTransactionSnapshotType($destinationTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($destinationTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($destinationTransactionSnapshotType) ? implode(', ', $destinationTransactionSnapshotType) : var_export($destinationTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->DestinationTransactionSnapshotType = $destinationTransactionSnapshotType;
        return $this;
    }
    /**
     * Get IntendedForExchange value
     * @return bool|null
     */
    public function getIntendedForExchange()
    {
        return $this->IntendedForExchange;
    }
    /**
     * Set IntendedForExchange value
     * @param bool $intendedForExchange
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setIntendedForExchange($intendedForExchange = null)
    {
        // validation for constraint: boolean
        if (!is_null($intendedForExchange) && !is_bool($intendedForExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intendedForExchange, true), gettype($intendedForExchange)), __LINE__);
        }
        $this->IntendedForExchange = $intendedForExchange;
        return $this;
    }
    /**
     * Get IsPostScanUpgrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPostScanUpgrade()
    {
        return isset($this->IsPostScanUpgrade) ? $this->IsPostScanUpgrade : null;
    }
    /**
     * Set IsPostScanUpgrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPostScanUpgrade
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setIsPostScanUpgrade($isPostScanUpgrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostScanUpgrade) && !is_bool($isPostScanUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPostScanUpgrade, true), gettype($isPostScanUpgrade)), __LINE__);
        }
        if (is_null($isPostScanUpgrade) || (is_array($isPostScanUpgrade) && empty($isPostScanUpgrade))) {
            unset($this->IsPostScanUpgrade);
        } else {
            $this->IsPostScanUpgrade = $isPostScanUpgrade;
        }
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfItemIdentity|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfItemIdentity $itemIds
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfItemIdentity $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfServiceSpecificItemIdentity|null
     */
    public function getServiceSpecificItemIds()
    {
        return isset($this->ServiceSpecificItemIds) ? $this->ServiceSpecificItemIds : null;
    }
    /**
     * Set ServiceSpecificItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setServiceSpecificItemIds(\patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds = null)
    {
        if (is_null($serviceSpecificItemIds) || (is_array($serviceSpecificItemIds) && empty($serviceSpecificItemIds))) {
            unset($this->ServiceSpecificItemIds);
        } else {
            $this->ServiceSpecificItemIds = $serviceSpecificItemIds;
        }
        return $this;
    }
    /**
     * Get ShouldReturnToOriginalTill value
     * @return bool|null
     */
    public function getShouldReturnToOriginalTill()
    {
        return $this->ShouldReturnToOriginalTill;
    }
    /**
     * Set ShouldReturnToOriginalTill value
     * @param bool $shouldReturnToOriginalTill
     * @return \patest\StructType\ReturnBasketItems_Request
     */
    public function setShouldReturnToOriginalTill($shouldReturnToOriginalTill = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldReturnToOriginalTill) && !is_bool($shouldReturnToOriginalTill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldReturnToOriginalTill, true), gettype($shouldReturnToOriginalTill)), __LINE__);
        }
        $this->ShouldReturnToOriginalTill = $shouldReturnToOriginalTill;
        return $this;
    }
}
