<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveCustomerResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveCustomerResponse
 * @subpackage Structs
 */
class RetrieveCustomerResponse extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_SimplifiedCustomer
     */
    public $Customer;
    /**
     * Constructor method for RetrieveCustomerResponse
     * @uses RetrieveCustomerResponse::setCustomer()
     * @param \patest\StructType\Crm_SimplifiedCustomer $customer
     */
    public function __construct(\patest\StructType\Crm_SimplifiedCustomer $customer = null)
    {
        $this
            ->setCustomer($customer);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_SimplifiedCustomer|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_SimplifiedCustomer $customer
     * @return \patest\StructType\RetrieveCustomerResponse
     */
    public function setCustomer(\patest\StructType\Crm_SimplifiedCustomer $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
}
