<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultRecord StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultRecord
 * @subpackage Structs
 */
class ResultRecord extends AbstractStructBase
{
    /**
     * The InstanceName1Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstanceName1Key;
    /**
     * The InstanceName2Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstanceName2Key;
    /**
     * The InstanceName3Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstanceName3Key;
    /**
     * The MonitorsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfNullableOfdouble
     */
    public $MonitorsData;
    /**
     * The UtcFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UtcFromDate;
    /**
     * The UtcToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UtcToDate;
    /**
     * Constructor method for ResultRecord
     * @uses ResultRecord::setInstanceName1Key()
     * @uses ResultRecord::setInstanceName2Key()
     * @uses ResultRecord::setInstanceName3Key()
     * @uses ResultRecord::setMonitorsData()
     * @uses ResultRecord::setUtcFromDate()
     * @uses ResultRecord::setUtcToDate()
     * @param int $instanceName1Key
     * @param int $instanceName2Key
     * @param int $instanceName3Key
     * @param \patest\ArrayType\ArrayOfNullableOfdouble $monitorsData
     * @param string $utcFromDate
     * @param string $utcToDate
     */
    public function __construct($instanceName1Key = null, $instanceName2Key = null, $instanceName3Key = null, \patest\ArrayType\ArrayOfNullableOfdouble $monitorsData = null, $utcFromDate = null, $utcToDate = null)
    {
        $this
            ->setInstanceName1Key($instanceName1Key)
            ->setInstanceName2Key($instanceName2Key)
            ->setInstanceName3Key($instanceName3Key)
            ->setMonitorsData($monitorsData)
            ->setUtcFromDate($utcFromDate)
            ->setUtcToDate($utcToDate);
    }
    /**
     * Get InstanceName1Key value
     * @return int|null
     */
    public function getInstanceName1Key()
    {
        return $this->InstanceName1Key;
    }
    /**
     * Set InstanceName1Key value
     * @param int $instanceName1Key
     * @return \patest\StructType\ResultRecord
     */
    public function setInstanceName1Key($instanceName1Key = null)
    {
        // validation for constraint: int
        if (!is_null($instanceName1Key) && !(is_int($instanceName1Key) || ctype_digit($instanceName1Key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($instanceName1Key, true), gettype($instanceName1Key)), __LINE__);
        }
        $this->InstanceName1Key = $instanceName1Key;
        return $this;
    }
    /**
     * Get InstanceName2Key value
     * @return int|null
     */
    public function getInstanceName2Key()
    {
        return $this->InstanceName2Key;
    }
    /**
     * Set InstanceName2Key value
     * @param int $instanceName2Key
     * @return \patest\StructType\ResultRecord
     */
    public function setInstanceName2Key($instanceName2Key = null)
    {
        // validation for constraint: int
        if (!is_null($instanceName2Key) && !(is_int($instanceName2Key) || ctype_digit($instanceName2Key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($instanceName2Key, true), gettype($instanceName2Key)), __LINE__);
        }
        $this->InstanceName2Key = $instanceName2Key;
        return $this;
    }
    /**
     * Get InstanceName3Key value
     * @return int|null
     */
    public function getInstanceName3Key()
    {
        return $this->InstanceName3Key;
    }
    /**
     * Set InstanceName3Key value
     * @param int $instanceName3Key
     * @return \patest\StructType\ResultRecord
     */
    public function setInstanceName3Key($instanceName3Key = null)
    {
        // validation for constraint: int
        if (!is_null($instanceName3Key) && !(is_int($instanceName3Key) || ctype_digit($instanceName3Key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($instanceName3Key, true), gettype($instanceName3Key)), __LINE__);
        }
        $this->InstanceName3Key = $instanceName3Key;
        return $this;
    }
    /**
     * Get MonitorsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfNullableOfdouble|null
     */
    public function getMonitorsData()
    {
        return isset($this->MonitorsData) ? $this->MonitorsData : null;
    }
    /**
     * Set MonitorsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfNullableOfdouble $monitorsData
     * @return \patest\StructType\ResultRecord
     */
    public function setMonitorsData(\patest\ArrayType\ArrayOfNullableOfdouble $monitorsData = null)
    {
        if (is_null($monitorsData) || (is_array($monitorsData) && empty($monitorsData))) {
            unset($this->MonitorsData);
        } else {
            $this->MonitorsData = $monitorsData;
        }
        return $this;
    }
    /**
     * Get UtcFromDate value
     * @return string|null
     */
    public function getUtcFromDate()
    {
        return $this->UtcFromDate;
    }
    /**
     * Set UtcFromDate value
     * @param string $utcFromDate
     * @return \patest\StructType\ResultRecord
     */
    public function setUtcFromDate($utcFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($utcFromDate) && !is_string($utcFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utcFromDate, true), gettype($utcFromDate)), __LINE__);
        }
        $this->UtcFromDate = $utcFromDate;
        return $this;
    }
    /**
     * Get UtcToDate value
     * @return string|null
     */
    public function getUtcToDate()
    {
        return $this->UtcToDate;
    }
    /**
     * Set UtcToDate value
     * @param string $utcToDate
     * @return \patest\StructType\ResultRecord
     */
    public function setUtcToDate($utcToDate = null)
    {
        // validation for constraint: string
        if (!is_null($utcToDate) && !is_string($utcToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utcToDate, true), gettype($utcToDate)), __LINE__);
        }
        $this->UtcToDate = $utcToDate;
        return $this;
    }
}
