<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestrictionDesign
 * @subpackage Structs
 */
class RestrictionDesign extends AbstractStructBase
{
    /**
     * The CountWithAvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CountWithAvailableSeats;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The Exclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Exclusive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The QualifiedUserGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $QualifiedUserGroupIds;
    /**
     * The RestrictionDesignGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionDesignGuid;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The UIAllUserGroupsMaySellAllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UIAllUserGroupsMaySellAllocatedSeats;
    /**
     * Constructor method for RestrictionDesign
     * @uses RestrictionDesign::setCountWithAvailableSeats()
     * @uses RestrictionDesign::setDisplayStyleValue()
     * @uses RestrictionDesign::setExclusive()
     * @uses RestrictionDesign::setName()
     * @uses RestrictionDesign::setQualifiedUserGroupIds()
     * @uses RestrictionDesign::setRestrictionDesignGuid()
     * @uses RestrictionDesign::setType()
     * @uses RestrictionDesign::setUIAllUserGroupsMaySellAllocatedSeats()
     * @param bool $countWithAvailableSeats
     * @param string $displayStyleValue
     * @param bool $exclusive
     * @param \patest\StructType\GlobalString $name
     * @param \patest\ArrayType\ArrayOfint $qualifiedUserGroupIds
     * @param string $restrictionDesignGuid
     * @param string $type
     * @param bool $uIAllUserGroupsMaySellAllocatedSeats
     */
    public function __construct($countWithAvailableSeats = null, $displayStyleValue = null, $exclusive = null, \patest\StructType\GlobalString $name = null, \patest\ArrayType\ArrayOfint $qualifiedUserGroupIds = null, $restrictionDesignGuid = null, $type = null, $uIAllUserGroupsMaySellAllocatedSeats = null)
    {
        $this
            ->setCountWithAvailableSeats($countWithAvailableSeats)
            ->setDisplayStyleValue($displayStyleValue)
            ->setExclusive($exclusive)
            ->setName($name)
            ->setQualifiedUserGroupIds($qualifiedUserGroupIds)
            ->setRestrictionDesignGuid($restrictionDesignGuid)
            ->setType($type)
            ->setUIAllUserGroupsMaySellAllocatedSeats($uIAllUserGroupsMaySellAllocatedSeats);
    }
    /**
     * Get CountWithAvailableSeats value
     * @return bool|null
     */
    public function getCountWithAvailableSeats()
    {
        return $this->CountWithAvailableSeats;
    }
    /**
     * Set CountWithAvailableSeats value
     * @param bool $countWithAvailableSeats
     * @return \patest\StructType\RestrictionDesign
     */
    public function setCountWithAvailableSeats($countWithAvailableSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($countWithAvailableSeats) && !is_bool($countWithAvailableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($countWithAvailableSeats, true), gettype($countWithAvailableSeats)), __LINE__);
        }
        $this->CountWithAvailableSeats = $countWithAvailableSeats;
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\RestrictionDesign
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get Exclusive value
     * @return bool|null
     */
    public function getExclusive()
    {
        return $this->Exclusive;
    }
    /**
     * Set Exclusive value
     * @param bool $exclusive
     * @return \patest\StructType\RestrictionDesign
     */
    public function setExclusive($exclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclusive) && !is_bool($exclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclusive, true), gettype($exclusive)), __LINE__);
        }
        $this->Exclusive = $exclusive;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\RestrictionDesign
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get QualifiedUserGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getQualifiedUserGroupIds()
    {
        return isset($this->QualifiedUserGroupIds) ? $this->QualifiedUserGroupIds : null;
    }
    /**
     * Set QualifiedUserGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $qualifiedUserGroupIds
     * @return \patest\StructType\RestrictionDesign
     */
    public function setQualifiedUserGroupIds(\patest\ArrayType\ArrayOfint $qualifiedUserGroupIds = null)
    {
        if (is_null($qualifiedUserGroupIds) || (is_array($qualifiedUserGroupIds) && empty($qualifiedUserGroupIds))) {
            unset($this->QualifiedUserGroupIds);
        } else {
            $this->QualifiedUserGroupIds = $qualifiedUserGroupIds;
        }
        return $this;
    }
    /**
     * Get RestrictionDesignGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionDesignGuid()
    {
        return isset($this->RestrictionDesignGuid) ? $this->RestrictionDesignGuid : null;
    }
    /**
     * Set RestrictionDesignGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionDesignGuid
     * @return \patest\StructType\RestrictionDesign
     */
    public function setRestrictionDesignGuid($restrictionDesignGuid = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionDesignGuid) && !is_string($restrictionDesignGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionDesignGuid, true), gettype($restrictionDesignGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionDesignGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionDesignGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionDesignGuid, true)), __LINE__);
        }
        if (is_null($restrictionDesignGuid) || (is_array($restrictionDesignGuid) && empty($restrictionDesignGuid))) {
            unset($this->RestrictionDesignGuid);
        } else {
            $this->RestrictionDesignGuid = $restrictionDesignGuid;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\RestrictionDesign
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get UIAllUserGroupsMaySellAllocatedSeats value
     * @return bool|null
     */
    public function getUIAllUserGroupsMaySellAllocatedSeats()
    {
        return $this->UIAllUserGroupsMaySellAllocatedSeats;
    }
    /**
     * Set UIAllUserGroupsMaySellAllocatedSeats value
     * @param bool $uIAllUserGroupsMaySellAllocatedSeats
     * @return \patest\StructType\RestrictionDesign
     */
    public function setUIAllUserGroupsMaySellAllocatedSeats($uIAllUserGroupsMaySellAllocatedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($uIAllUserGroupsMaySellAllocatedSeats) && !is_bool($uIAllUserGroupsMaySellAllocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uIAllUserGroupsMaySellAllocatedSeats, true), gettype($uIAllUserGroupsMaySellAllocatedSeats)), __LINE__);
        }
        $this->UIAllUserGroupsMaySellAllocatedSeats = $uIAllUserGroupsMaySellAllocatedSeats;
        return $this;
    }
}
