<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResaleRequestDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResaleRequestDetails
 * @subpackage Structs
 */
class ResaleRequestDetails extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedByUserId;
    /**
     * The DestinationClientInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationClientInfo;
    /**
     * The DestinationClientInfoKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationClientInfoKind;
    /**
     * The ExternalOriginator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalOriginator;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The TicketInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketResaleInfo
     */
    public $TicketInfos;
    /**
     * Constructor method for ResaleRequestDetails
     * @uses ResaleRequestDetails::setClientId()
     * @uses ResaleRequestDetails::setCreatedByUserId()
     * @uses ResaleRequestDetails::setDestinationClientInfo()
     * @uses ResaleRequestDetails::setDestinationClientInfoKind()
     * @uses ResaleRequestDetails::setExternalOriginator()
     * @uses ResaleRequestDetails::setPaymentMethodId()
     * @uses ResaleRequestDetails::setPaymentTokenId()
     * @uses ResaleRequestDetails::setResaleMethod()
     * @uses ResaleRequestDetails::setTicketInfos()
     * @param string $clientId
     * @param string $createdByUserId
     * @param string $destinationClientInfo
     * @param string $destinationClientInfoKind
     * @param string $externalOriginator
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param string $resaleMethod
     * @param \patest\ArrayType\ArrayOfTicketResaleInfo $ticketInfos
     */
    public function __construct($clientId = null, $createdByUserId = null, $destinationClientInfo = null, $destinationClientInfoKind = null, $externalOriginator = null, $paymentMethodId = null, $paymentTokenId = null, $resaleMethod = null, \patest\ArrayType\ArrayOfTicketResaleInfo $ticketInfos = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreatedByUserId($createdByUserId)
            ->setDestinationClientInfo($destinationClientInfo)
            ->setDestinationClientInfoKind($destinationClientInfoKind)
            ->setExternalOriginator($externalOriginator)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setResaleMethod($resaleMethod)
            ->setTicketInfos($ticketInfos);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get CreatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUserId()
    {
        return isset($this->CreatedByUserId) ? $this->CreatedByUserId : null;
    }
    /**
     * Set CreatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUserId
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setCreatedByUserId($createdByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserId) && !is_string($createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUserId, true), gettype($createdByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdByUserId, true)), __LINE__);
        }
        if (is_null($createdByUserId) || (is_array($createdByUserId) && empty($createdByUserId))) {
            unset($this->CreatedByUserId);
        } else {
            $this->CreatedByUserId = $createdByUserId;
        }
        return $this;
    }
    /**
     * Get DestinationClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClientInfo()
    {
        return isset($this->DestinationClientInfo) ? $this->DestinationClientInfo : null;
    }
    /**
     * Set DestinationClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationClientInfo
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setDestinationClientInfo($destinationClientInfo = null)
    {
        // validation for constraint: string
        if (!is_null($destinationClientInfo) && !is_string($destinationClientInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationClientInfo, true), gettype($destinationClientInfo)), __LINE__);
        }
        if (is_null($destinationClientInfo) || (is_array($destinationClientInfo) && empty($destinationClientInfo))) {
            unset($this->DestinationClientInfo);
        } else {
            $this->DestinationClientInfo = $destinationClientInfo;
        }
        return $this;
    }
    /**
     * Get DestinationClientInfoKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClientInfoKind()
    {
        return isset($this->DestinationClientInfoKind) ? $this->DestinationClientInfoKind : null;
    }
    /**
     * Set DestinationClientInfoKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PendingTransferClientInfoKind::valueIsValid()
     * @uses \patest\EnumType\PendingTransferClientInfoKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationClientInfoKind
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setDestinationClientInfoKind($destinationClientInfoKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PendingTransferClientInfoKind::valueIsValid($destinationClientInfoKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PendingTransferClientInfoKind', is_array($destinationClientInfoKind) ? implode(', ', $destinationClientInfoKind) : var_export($destinationClientInfoKind, true), implode(', ', \patest\EnumType\PendingTransferClientInfoKind::getValidValues())), __LINE__);
        }
        if (is_null($destinationClientInfoKind) || (is_array($destinationClientInfoKind) && empty($destinationClientInfoKind))) {
            unset($this->DestinationClientInfoKind);
        } else {
            $this->DestinationClientInfoKind = $destinationClientInfoKind;
        }
        return $this;
    }
    /**
     * Get ExternalOriginator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalOriginator()
    {
        return isset($this->ExternalOriginator) ? $this->ExternalOriginator : null;
    }
    /**
     * Set ExternalOriginator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalOriginator
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setExternalOriginator($externalOriginator = null)
    {
        // validation for constraint: string
        if (!is_null($externalOriginator) && !is_string($externalOriginator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalOriginator, true), gettype($externalOriginator)), __LINE__);
        }
        if (is_null($externalOriginator) || (is_array($externalOriginator) && empty($externalOriginator))) {
            unset($this->ExternalOriginator);
        } else {
            $this->ExternalOriginator = $externalOriginator;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get TicketInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketResaleInfo|null
     */
    public function getTicketInfos()
    {
        return isset($this->TicketInfos) ? $this->TicketInfos : null;
    }
    /**
     * Set TicketInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketResaleInfo $ticketInfos
     * @return \patest\StructType\ResaleRequestDetails
     */
    public function setTicketInfos(\patest\ArrayType\ArrayOfTicketResaleInfo $ticketInfos = null)
    {
        if (is_null($ticketInfos) || (is_array($ticketInfos) && empty($ticketInfos))) {
            unset($this->TicketInfos);
        } else {
            $this->TicketInfos = $ticketInfos;
        }
        return $this;
    }
}
