<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.ReportProperties StructType
 * @subpackage Structs
 */
class Reporting_ReportProperties extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The CanUseDataSecurityRunAsSeller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUseDataSecurityRunAsSeller;
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Categories
     */
    public $Categories;
    /**
     * The DataSecurityRunAsSeller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DataSecurityRunAsSeller;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OthersCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanModify;
    /**
     * The OthersCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanRun;
    /**
     * The ProfilesCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanModify
     */
    public $ProfilesCanModify;
    /**
     * The ProfilesCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanRun
     */
    public $ProfilesCanRun;
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportId;
    /**
     * The ReportImplementaionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportImplementaionType;
    /**
     * The SupportedClientApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportedClientApp;
    /**
     * The VersionOf
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VersionOf;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Reporting.ReportProperties
     * @uses Reporting_ReportProperties::setAccessPermissions()
     * @uses Reporting_ReportProperties::setCanUseDataSecurityRunAsSeller()
     * @uses Reporting_ReportProperties::setCategories()
     * @uses Reporting_ReportProperties::setDataSecurityRunAsSeller()
     * @uses Reporting_ReportProperties::setDescription()
     * @uses Reporting_ReportProperties::setIsSystem()
     * @uses Reporting_ReportProperties::setName()
     * @uses Reporting_ReportProperties::setOrganizationUnitId()
     * @uses Reporting_ReportProperties::setOthersCanModify()
     * @uses Reporting_ReportProperties::setOthersCanRun()
     * @uses Reporting_ReportProperties::setProfilesCanModify()
     * @uses Reporting_ReportProperties::setProfilesCanRun()
     * @uses Reporting_ReportProperties::setReportId()
     * @uses Reporting_ReportProperties::setReportImplementaionType()
     * @uses Reporting_ReportProperties::setSupportedClientApp()
     * @uses Reporting_ReportProperties::setVersionOf()
     * @uses Reporting_ReportProperties::setVisibleBySubordinates()
     * @param string[] $accessPermissions
     * @param bool $canUseDataSecurityRunAsSeller
     * @param \patest\StructType\Categories $categories
     * @param bool $dataSecurityRunAsSeller
     * @param \patest\StructType\GlobalString $description
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $othersCanModify
     * @param string $othersCanRun
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @param string $reportId
     * @param string $reportImplementaionType
     * @param string $supportedClientApp
     * @param bool $versionOf
     * @param bool $visibleBySubordinates
     */
    public function __construct(array $accessPermissions = array(), $canUseDataSecurityRunAsSeller = null, \patest\StructType\Categories $categories = null, $dataSecurityRunAsSeller = null, \patest\StructType\GlobalString $description = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $othersCanModify = null, $othersCanRun = null, \patest\StructType\ProfilesCanModify $profilesCanModify = null, \patest\StructType\ProfilesCanRun $profilesCanRun = null, $reportId = null, $reportImplementaionType = null, $supportedClientApp = null, $versionOf = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setCanUseDataSecurityRunAsSeller($canUseDataSecurityRunAsSeller)
            ->setCategories($categories)
            ->setDataSecurityRunAsSeller($dataSecurityRunAsSeller)
            ->setDescription($description)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOthersCanModify($othersCanModify)
            ->setOthersCanRun($othersCanRun)
            ->setProfilesCanModify($profilesCanModify)
            ->setProfilesCanRun($profilesCanRun)
            ->setReportId($reportId)
            ->setReportImplementaionType($reportImplementaionType)
            ->setSupportedClientApp($supportedClientApp)
            ->setVersionOf($versionOf)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reporting_ReportPropertiesAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($reporting_ReportPropertiesAccessPermissionsItem)) {
                $invalidValues[] = is_object($reporting_ReportPropertiesAccessPermissionsItem) ? get_class($reporting_ReportPropertiesAccessPermissionsItem) : sprintf('%s(%s)', gettype($reporting_ReportPropertiesAccessPermissionsItem), var_export($reporting_ReportPropertiesAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get CanUseDataSecurityRunAsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUseDataSecurityRunAsSeller()
    {
        return isset($this->CanUseDataSecurityRunAsSeller) ? $this->CanUseDataSecurityRunAsSeller : null;
    }
    /**
     * Set CanUseDataSecurityRunAsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUseDataSecurityRunAsSeller
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setCanUseDataSecurityRunAsSeller($canUseDataSecurityRunAsSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUseDataSecurityRunAsSeller) && !is_bool($canUseDataSecurityRunAsSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUseDataSecurityRunAsSeller, true), gettype($canUseDataSecurityRunAsSeller)), __LINE__);
        }
        if (is_null($canUseDataSecurityRunAsSeller) || (is_array($canUseDataSecurityRunAsSeller) && empty($canUseDataSecurityRunAsSeller))) {
            unset($this->CanUseDataSecurityRunAsSeller);
        } else {
            $this->CanUseDataSecurityRunAsSeller = $canUseDataSecurityRunAsSeller;
        }
        return $this;
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Categories|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Categories $categories
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setCategories(\patest\StructType\Categories $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Get DataSecurityRunAsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDataSecurityRunAsSeller()
    {
        return isset($this->DataSecurityRunAsSeller) ? $this->DataSecurityRunAsSeller : null;
    }
    /**
     * Set DataSecurityRunAsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dataSecurityRunAsSeller
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setDataSecurityRunAsSeller($dataSecurityRunAsSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataSecurityRunAsSeller) && !is_bool($dataSecurityRunAsSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dataSecurityRunAsSeller, true), gettype($dataSecurityRunAsSeller)), __LINE__);
        }
        if (is_null($dataSecurityRunAsSeller) || (is_array($dataSecurityRunAsSeller) && empty($dataSecurityRunAsSeller))) {
            unset($this->DataSecurityRunAsSeller);
        } else {
            $this->DataSecurityRunAsSeller = $dataSecurityRunAsSeller;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OthersCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanModify()
    {
        return isset($this->OthersCanModify) ? $this->OthersCanModify : null;
    }
    /**
     * Set OthersCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportPermission::valueIsValid()
     * @uses \patest\EnumType\ReportPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanModify
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setOthersCanModify($othersCanModify = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportPermission::valueIsValid($othersCanModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportPermission', is_array($othersCanModify) ? implode(', ', $othersCanModify) : var_export($othersCanModify, true), implode(', ', \patest\EnumType\ReportPermission::getValidValues())), __LINE__);
        }
        if (is_null($othersCanModify) || (is_array($othersCanModify) && empty($othersCanModify))) {
            unset($this->OthersCanModify);
        } else {
            $this->OthersCanModify = $othersCanModify;
        }
        return $this;
    }
    /**
     * Get OthersCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanRun()
    {
        return isset($this->OthersCanRun) ? $this->OthersCanRun : null;
    }
    /**
     * Set OthersCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportPermission::valueIsValid()
     * @uses \patest\EnumType\ReportPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanRun
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setOthersCanRun($othersCanRun = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportPermission::valueIsValid($othersCanRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportPermission', is_array($othersCanRun) ? implode(', ', $othersCanRun) : var_export($othersCanRun, true), implode(', ', \patest\EnumType\ReportPermission::getValidValues())), __LINE__);
        }
        if (is_null($othersCanRun) || (is_array($othersCanRun) && empty($othersCanRun))) {
            unset($this->OthersCanRun);
        } else {
            $this->OthersCanRun = $othersCanRun;
        }
        return $this;
    }
    /**
     * Get ProfilesCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanModify|null
     */
    public function getProfilesCanModify()
    {
        return isset($this->ProfilesCanModify) ? $this->ProfilesCanModify : null;
    }
    /**
     * Set ProfilesCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setProfilesCanModify(\patest\StructType\ProfilesCanModify $profilesCanModify = null)
    {
        if (is_null($profilesCanModify) || (is_array($profilesCanModify) && empty($profilesCanModify))) {
            unset($this->ProfilesCanModify);
        } else {
            $this->ProfilesCanModify = $profilesCanModify;
        }
        return $this;
    }
    /**
     * Get ProfilesCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanRun|null
     */
    public function getProfilesCanRun()
    {
        return isset($this->ProfilesCanRun) ? $this->ProfilesCanRun : null;
    }
    /**
     * Set ProfilesCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setProfilesCanRun(\patest\StructType\ProfilesCanRun $profilesCanRun = null)
    {
        if (is_null($profilesCanRun) || (is_array($profilesCanRun) && empty($profilesCanRun))) {
            unset($this->ProfilesCanRun);
        } else {
            $this->ProfilesCanRun = $profilesCanRun;
        }
        return $this;
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportId
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportId, true)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
    /**
     * Get ReportImplementaionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportImplementaionType()
    {
        return isset($this->ReportImplementaionType) ? $this->ReportImplementaionType : null;
    }
    /**
     * Set ReportImplementaionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportImplementaionType::valueIsValid()
     * @uses \patest\EnumType\ReportImplementaionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportImplementaionType
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setReportImplementaionType($reportImplementaionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportImplementaionType::valueIsValid($reportImplementaionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportImplementaionType', is_array($reportImplementaionType) ? implode(', ', $reportImplementaionType) : var_export($reportImplementaionType, true), implode(', ', \patest\EnumType\ReportImplementaionType::getValidValues())), __LINE__);
        }
        if (is_null($reportImplementaionType) || (is_array($reportImplementaionType) && empty($reportImplementaionType))) {
            unset($this->ReportImplementaionType);
        } else {
            $this->ReportImplementaionType = $reportImplementaionType;
        }
        return $this;
    }
    /**
     * Get SupportedClientApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportedClientApp()
    {
        return isset($this->SupportedClientApp) ? $this->SupportedClientApp : null;
    }
    /**
     * Set SupportedClientApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportingClientApp::valueIsValid()
     * @uses \patest\EnumType\ReportingClientApp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $supportedClientApp
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setSupportedClientApp($supportedClientApp = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportingClientApp::valueIsValid($supportedClientApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportingClientApp', is_array($supportedClientApp) ? implode(', ', $supportedClientApp) : var_export($supportedClientApp, true), implode(', ', \patest\EnumType\ReportingClientApp::getValidValues())), __LINE__);
        }
        if (is_null($supportedClientApp) || (is_array($supportedClientApp) && empty($supportedClientApp))) {
            unset($this->SupportedClientApp);
        } else {
            $this->SupportedClientApp = $supportedClientApp;
        }
        return $this;
    }
    /**
     * Get VersionOf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVersionOf()
    {
        return isset($this->VersionOf) ? $this->VersionOf : null;
    }
    /**
     * Set VersionOf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $versionOf
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setVersionOf($versionOf = null)
    {
        // validation for constraint: boolean
        if (!is_null($versionOf) && !is_bool($versionOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($versionOf, true), gettype($versionOf)), __LINE__);
        }
        if (is_null($versionOf) || (is_array($versionOf) && empty($versionOf))) {
            unset($this->VersionOf);
        } else {
            $this->VersionOf = $versionOf;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Reporting_ReportProperties
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
