<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.ReportCategory StructType
 * @subpackage Structs
 */
class Reporting_ReportCategory extends MaintainableGlobalizedEntity
{
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContentType;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image;
    /**
     * The ImageExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageExtension;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageUrl;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnabled;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Profiles
     */
    public $Profiles;
    /**
     * The ReportIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReportIds
     */
    public $ReportIds;
    /**
     * The ReportsCountInCategory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReportsCountInCategory;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Reporting.ReportCategory
     * @uses Reporting_ReportCategory::setContentType()
     * @uses Reporting_ReportCategory::setImage()
     * @uses Reporting_ReportCategory::setImageExtension()
     * @uses Reporting_ReportCategory::setImageUrl()
     * @uses Reporting_ReportCategory::setIsDefault()
     * @uses Reporting_ReportCategory::setIsEnabled()
     * @uses Reporting_ReportCategory::setIsSystem()
     * @uses Reporting_ReportCategory::setOrder()
     * @uses Reporting_ReportCategory::setOrganizationUnitId()
     * @uses Reporting_ReportCategory::setProfiles()
     * @uses Reporting_ReportCategory::setReportIds()
     * @uses Reporting_ReportCategory::setReportsCountInCategory()
     * @uses Reporting_ReportCategory::setVisibleBySubordinates()
     * @param int $contentType
     * @param string $image
     * @param string $imageExtension
     * @param string $imageUrl
     * @param bool $isDefault
     * @param bool $isEnabled
     * @param bool $isSystem
     * @param int $order
     * @param string $organizationUnitId
     * @param \patest\StructType\Profiles $profiles
     * @param \patest\StructType\ReportIds $reportIds
     * @param int $reportsCountInCategory
     * @param bool $visibleBySubordinates
     */
    public function __construct($contentType = null, $image = null, $imageExtension = null, $imageUrl = null, $isDefault = null, $isEnabled = null, $isSystem = null, $order = null, $organizationUnitId = null, \patest\StructType\Profiles $profiles = null, \patest\StructType\ReportIds $reportIds = null, $reportsCountInCategory = null, $visibleBySubordinates = null)
    {
        $this
            ->setContentType($contentType)
            ->setImage($image)
            ->setImageExtension($imageExtension)
            ->setImageUrl($imageUrl)
            ->setIsDefault($isDefault)
            ->setIsEnabled($isEnabled)
            ->setIsSystem($isSystem)
            ->setOrder($order)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProfiles($profiles)
            ->setReportIds($reportIds)
            ->setReportsCountInCategory($reportsCountInCategory)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get ContentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContentType()
    {
        return isset($this->ContentType) ? $this->ContentType : null;
    }
    /**
     * Set ContentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contentType
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: int
        if (!is_null($contentType) && !(is_int($contentType) || ctype_digit($contentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        if (is_null($contentType) || (is_array($contentType) && empty($contentType))) {
            unset($this->ContentType);
        } else {
            $this->ContentType = $contentType;
        }
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get ImageExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageExtension()
    {
        return isset($this->ImageExtension) ? $this->ImageExtension : null;
    }
    /**
     * Set ImageExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageExtension
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setImageExtension($imageExtension = null)
    {
        // validation for constraint: string
        if (!is_null($imageExtension) && !is_string($imageExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageExtension, true), gettype($imageExtension)), __LINE__);
        }
        if (is_null($imageExtension) || (is_array($imageExtension) && empty($imageExtension))) {
            unset($this->ImageExtension);
        } else {
            $this->ImageExtension = $imageExtension;
        }
        return $this;
    }
    /**
     * Get ImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageUrl()
    {
        return isset($this->ImageUrl) ? $this->ImageUrl : null;
    }
    /**
     * Set ImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageUrl
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        if (is_null($imageUrl) || (is_array($imageUrl) && empty($imageUrl))) {
            unset($this->ImageUrl);
        } else {
            $this->ImageUrl = $imageUrl;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get IsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return isset($this->IsEnabled) ? $this->IsEnabled : null;
    }
    /**
     * Set IsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnabled
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        if (is_null($isEnabled) || (is_array($isEnabled) && empty($isEnabled))) {
            unset($this->IsEnabled);
        } else {
            $this->IsEnabled = $isEnabled;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Profiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Profiles|null
     */
    public function getProfiles()
    {
        return isset($this->Profiles) ? $this->Profiles : null;
    }
    /**
     * Set Profiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Profiles $profiles
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setProfiles(\patest\StructType\Profiles $profiles = null)
    {
        if (is_null($profiles) || (is_array($profiles) && empty($profiles))) {
            unset($this->Profiles);
        } else {
            $this->Profiles = $profiles;
        }
        return $this;
    }
    /**
     * Get ReportIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReportIds|null
     */
    public function getReportIds()
    {
        return isset($this->ReportIds) ? $this->ReportIds : null;
    }
    /**
     * Set ReportIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReportIds $reportIds
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setReportIds(\patest\StructType\ReportIds $reportIds = null)
    {
        if (is_null($reportIds) || (is_array($reportIds) && empty($reportIds))) {
            unset($this->ReportIds);
        } else {
            $this->ReportIds = $reportIds;
        }
        return $this;
    }
    /**
     * Get ReportsCountInCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReportsCountInCategory()
    {
        return isset($this->ReportsCountInCategory) ? $this->ReportsCountInCategory : null;
    }
    /**
     * Set ReportsCountInCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reportsCountInCategory
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setReportsCountInCategory($reportsCountInCategory = null)
    {
        // validation for constraint: int
        if (!is_null($reportsCountInCategory) && !(is_int($reportsCountInCategory) || ctype_digit($reportsCountInCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reportsCountInCategory, true), gettype($reportsCountInCategory)), __LINE__);
        }
        if (is_null($reportsCountInCategory) || (is_array($reportsCountInCategory) && empty($reportsCountInCategory))) {
            unset($this->ReportsCountInCategory);
        } else {
            $this->ReportsCountInCategory = $reportsCountInCategory;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Reporting_ReportCategory
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
