<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.RDLTemplate StructType
 * @subpackage Structs
 */
class Reporting_RDLTemplate extends DistributableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EnabledForDashboard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnabledForDashboard;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The Processor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Processor;
    /**
     * The ReportSchema
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportSchema;
    /**
     * The Template
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Template;
    /**
     * The TemplateStructure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TemplateStructure;
    /**
     * Constructor method for Reporting.RDLTemplate
     * @uses Reporting_RDLTemplate::setDescription()
     * @uses Reporting_RDLTemplate::setEnabledForDashboard()
     * @uses Reporting_RDLTemplate::setImageId()
     * @uses Reporting_RDLTemplate::setName()
     * @uses Reporting_RDLTemplate::setOrdinal()
     * @uses Reporting_RDLTemplate::setProcessor()
     * @uses Reporting_RDLTemplate::setReportSchema()
     * @uses Reporting_RDLTemplate::setTemplate()
     * @uses Reporting_RDLTemplate::setTemplateStructure()
     * @param \patest\StructType\GlobalString $description
     * @param bool $enabledForDashboard
     * @param int $imageId
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param string $processor
     * @param string $reportSchema
     * @param string $template
     * @param string $templateStructure
     */
    public function __construct(\patest\StructType\GlobalString $description = null, $enabledForDashboard = null, $imageId = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $processor = null, $reportSchema = null, $template = null, $templateStructure = null)
    {
        $this
            ->setDescription($description)
            ->setEnabledForDashboard($enabledForDashboard)
            ->setImageId($imageId)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setProcessor($processor)
            ->setReportSchema($reportSchema)
            ->setTemplate($template)
            ->setTemplateStructure($templateStructure);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnabledForDashboard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnabledForDashboard()
    {
        return isset($this->EnabledForDashboard) ? $this->EnabledForDashboard : null;
    }
    /**
     * Set EnabledForDashboard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enabledForDashboard
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setEnabledForDashboard($enabledForDashboard = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabledForDashboard) && !is_bool($enabledForDashboard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabledForDashboard, true), gettype($enabledForDashboard)), __LINE__);
        }
        if (is_null($enabledForDashboard) || (is_array($enabledForDashboard) && empty($enabledForDashboard))) {
            unset($this->EnabledForDashboard);
        } else {
            $this->EnabledForDashboard = $enabledForDashboard;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageId()
    {
        return isset($this->ImageId) ? $this->ImageId : null;
    }
    /**
     * Set ImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageId
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: int
        if (!is_null($imageId) && !(is_int($imageId) || ctype_digit($imageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        if (is_null($imageId) || (is_array($imageId) && empty($imageId))) {
            unset($this->ImageId);
        } else {
            $this->ImageId = $imageId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get Processor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessor()
    {
        return isset($this->Processor) ? $this->Processor : null;
    }
    /**
     * Set Processor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processor
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setProcessor($processor = null)
    {
        // validation for constraint: string
        if (!is_null($processor) && !is_string($processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processor, true), gettype($processor)), __LINE__);
        }
        if (is_null($processor) || (is_array($processor) && empty($processor))) {
            unset($this->Processor);
        } else {
            $this->Processor = $processor;
        }
        return $this;
    }
    /**
     * Get ReportSchema value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportSchema()
    {
        return isset($this->ReportSchema) ? $this->ReportSchema : null;
    }
    /**
     * Set ReportSchema value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportSchema
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setReportSchema($reportSchema = null)
    {
        // validation for constraint: string
        if (!is_null($reportSchema) && !is_string($reportSchema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportSchema, true), gettype($reportSchema)), __LINE__);
        }
        if (is_null($reportSchema) || (is_array($reportSchema) && empty($reportSchema))) {
            unset($this->ReportSchema);
        } else {
            $this->ReportSchema = $reportSchema;
        }
        return $this;
    }
    /**
     * Get Template value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplate()
    {
        return isset($this->Template) ? $this->Template : null;
    }
    /**
     * Set Template value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $template
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setTemplate($template = null)
    {
        // validation for constraint: string
        if (!is_null($template) && !is_string($template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template, true), gettype($template)), __LINE__);
        }
        if (is_null($template) || (is_array($template) && empty($template))) {
            unset($this->Template);
        } else {
            $this->Template = $template;
        }
        return $this;
    }
    /**
     * Get TemplateStructure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplateStructure()
    {
        return isset($this->TemplateStructure) ? $this->TemplateStructure : null;
    }
    /**
     * Set TemplateStructure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $templateStructure
     * @return \patest\StructType\Reporting_RDLTemplate
     */
    public function setTemplateStructure($templateStructure = null)
    {
        // validation for constraint: string
        if (!is_null($templateStructure) && !is_string($templateStructure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateStructure, true), gettype($templateStructure)), __LINE__);
        }
        if (is_null($templateStructure) || (is_array($templateStructure) && empty($templateStructure))) {
            unset($this->TemplateStructure);
        } else {
            $this->TemplateStructure = $templateStructure;
        }
        return $this;
    }
}
