<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderSingleDocumentResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderSingleDocumentResponse
 * @subpackage Structs
 */
class RenderSingleDocumentResponse extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\LocalizedText
     */
    public $Error;
    /**
     * The PagesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PagesCount;
    /**
     * The RenderedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenderedDocument;
    /**
     * Constructor method for RenderSingleDocumentResponse
     * @uses RenderSingleDocumentResponse::setError()
     * @uses RenderSingleDocumentResponse::setPagesCount()
     * @uses RenderSingleDocumentResponse::setRenderedDocument()
     * @param \patest\StructType\LocalizedText $error
     * @param int $pagesCount
     * @param string $renderedDocument
     */
    public function __construct(\patest\StructType\LocalizedText $error = null, $pagesCount = null, $renderedDocument = null)
    {
        $this
            ->setError($error)
            ->setPagesCount($pagesCount)
            ->setRenderedDocument($renderedDocument);
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\LocalizedText|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\LocalizedText $error
     * @return \patest\StructType\RenderSingleDocumentResponse
     */
    public function setError(\patest\StructType\LocalizedText $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get PagesCount value
     * @return int|null
     */
    public function getPagesCount()
    {
        return $this->PagesCount;
    }
    /**
     * Set PagesCount value
     * @param int $pagesCount
     * @return \patest\StructType\RenderSingleDocumentResponse
     */
    public function setPagesCount($pagesCount = null)
    {
        // validation for constraint: int
        if (!is_null($pagesCount) && !(is_int($pagesCount) || ctype_digit($pagesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pagesCount, true), gettype($pagesCount)), __LINE__);
        }
        $this->PagesCount = $pagesCount;
        return $this;
    }
    /**
     * Get RenderedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenderedDocument()
    {
        return isset($this->RenderedDocument) ? $this->RenderedDocument : null;
    }
    /**
     * Set RenderedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renderedDocument
     * @return \patest\StructType\RenderSingleDocumentResponse
     */
    public function setRenderedDocument($renderedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($renderedDocument) && !is_string($renderedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renderedDocument, true), gettype($renderedDocument)), __LINE__);
        }
        if (is_null($renderedDocument) || (is_array($renderedDocument) && empty($renderedDocument))) {
            unset($this->RenderedDocument);
        } else {
            $this->RenderedDocument = $renderedDocument;
        }
        return $this;
    }
}
