<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundVoucherPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundVoucherPaymentItem
 * @subpackage Structs
 */
class RefundVoucherPaymentItem extends AbstractPaymentItem
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Balance;
    /**
     * The ContinuationVoucher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Voucher
     */
    public $ContinuationVoucher;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Voucher
     */
    public $Voucher;
    /**
     * Constructor method for RefundVoucherPaymentItem
     * @uses RefundVoucherPaymentItem::setBalance()
     * @uses RefundVoucherPaymentItem::setContinuationVoucher()
     * @uses RefundVoucherPaymentItem::setVoucher()
     * @param \patest\StructType\Money $balance
     * @param \patest\StructType\Voucher $continuationVoucher
     * @param \patest\StructType\Voucher $voucher
     */
    public function __construct(\patest\StructType\Money $balance = null, \patest\StructType\Voucher $continuationVoucher = null, \patest\StructType\Voucher $voucher = null)
    {
        $this
            ->setBalance($balance)
            ->setContinuationVoucher($continuationVoucher)
            ->setVoucher($voucher);
    }
    /**
     * Get Balance value
     * @return \patest\StructType\Money|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \patest\StructType\Money $balance
     * @return \patest\StructType\RefundVoucherPaymentItem
     */
    public function setBalance(\patest\StructType\Money $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get ContinuationVoucher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Voucher|null
     */
    public function getContinuationVoucher()
    {
        return isset($this->ContinuationVoucher) ? $this->ContinuationVoucher : null;
    }
    /**
     * Set ContinuationVoucher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Voucher $continuationVoucher
     * @return \patest\StructType\RefundVoucherPaymentItem
     */
    public function setContinuationVoucher(\patest\StructType\Voucher $continuationVoucher = null)
    {
        if (is_null($continuationVoucher) || (is_array($continuationVoucher) && empty($continuationVoucher))) {
            unset($this->ContinuationVoucher);
        } else {
            $this->ContinuationVoucher = $continuationVoucher;
        }
        return $this;
    }
    /**
     * Get Voucher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Voucher|null
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * Set Voucher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Voucher $voucher
     * @return \patest\StructType\RefundVoucherPaymentItem
     */
    public function setVoucher(\patest\StructType\Voucher $voucher = null)
    {
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
}
