<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryParameters-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryParameters-Request
 * @subpackage Structs
 */
class QueryParameters_Request extends ExtensibleDataContract
{
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * The ParameterNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ParameterNames;
    /**
     * The ParameterNodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterNodeType;
    /**
     * Constructor method for QueryParameters-Request
     * @uses QueryParameters_Request::setOwner()
     * @uses QueryParameters_Request::setParameterNames()
     * @uses QueryParameters_Request::setParameterNodeType()
     * @param string $owner
     * @param \patest\ArrayType\ArrayOfstring $parameterNames
     * @param string $parameterNodeType
     */
    public function __construct($owner = null, \patest\ArrayType\ArrayOfstring $parameterNames = null, $parameterNodeType = null)
    {
        $this
            ->setOwner($owner)
            ->setParameterNames($parameterNames)
            ->setParameterNodeType($parameterNodeType);
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\QueryParameters_Request
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get ParameterNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getParameterNames()
    {
        return isset($this->ParameterNames) ? $this->ParameterNames : null;
    }
    /**
     * Set ParameterNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $parameterNames
     * @return \patest\StructType\QueryParameters_Request
     */
    public function setParameterNames(\patest\ArrayType\ArrayOfstring $parameterNames = null)
    {
        if (is_null($parameterNames) || (is_array($parameterNames) && empty($parameterNames))) {
            unset($this->ParameterNames);
        } else {
            $this->ParameterNames = $parameterNames;
        }
        return $this;
    }
    /**
     * Get ParameterNodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterNodeType()
    {
        return isset($this->ParameterNodeType) ? $this->ParameterNodeType : null;
    }
    /**
     * Set ParameterNodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ParameterNodeType::valueIsValid()
     * @uses \patest\EnumType\ParameterNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameterNodeType
     * @return \patest\StructType\QueryParameters_Request
     */
    public function setParameterNodeType($parameterNodeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ParameterNodeType::valueIsValid($parameterNodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ParameterNodeType', is_array($parameterNodeType) ? implode(', ', $parameterNodeType) : var_export($parameterNodeType, true), implode(', ', \patest\EnumType\ParameterNodeType::getValidValues())), __LINE__);
        }
        if (is_null($parameterNodeType) || (is_array($parameterNodeType) && empty($parameterNodeType))) {
            unset($this->ParameterNodeType);
        } else {
            $this->ParameterNodeType = $parameterNodeType;
        }
        return $this;
    }
}
