<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.SubQuery StructType
 * @subpackage Structs
 */
class QueryBuilder_SubQuery extends MaintainableGlobalizedEntity
{
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_Criteria
     */
    public $Criteria;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Enabled;
    /**
     * The InsertedQuery
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryBuilder_Query
     */
    public $InsertedQuery;
    /**
     * The Kind
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:SubQueryKind
     * @var string
     */
    public $Kind;
    /**
     * The Negated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Negated;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The ParentQueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentQueryId;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for QueryBuilder.SubQuery
     * @uses QueryBuilder_SubQuery::setCriteria()
     * @uses QueryBuilder_SubQuery::setEnabled()
     * @uses QueryBuilder_SubQuery::setInsertedQuery()
     * @uses QueryBuilder_SubQuery::setKind()
     * @uses QueryBuilder_SubQuery::setNegated()
     * @uses QueryBuilder_SubQuery::setOrdinal()
     * @uses QueryBuilder_SubQuery::setParentQueryId()
     * @uses QueryBuilder_SubQuery::setXmlContainer()
     * @param \patest\StructType\RecordSetOfQueryBuilder_Criteria $criteria
     * @param bool $enabled
     * @param \patest\StructType\QueryBuilder_Query $insertedQuery
     * @param string $kind
     * @param bool $negated
     * @param int $ordinal
     * @param string $parentQueryId
     * @param string $xmlContainer
     */
    public function __construct(\patest\StructType\RecordSetOfQueryBuilder_Criteria $criteria = null, $enabled = null, \patest\StructType\QueryBuilder_Query $insertedQuery = null, $kind = null, $negated = null, $ordinal = null, $parentQueryId = null, $xmlContainer = null)
    {
        $this
            ->setCriteria($criteria)
            ->setEnabled($enabled)
            ->setInsertedQuery($insertedQuery)
            ->setKind($kind)
            ->setNegated($negated)
            ->setOrdinal($ordinal)
            ->setParentQueryId($parentQueryId)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_Criteria|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_Criteria $criteria
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setCriteria(\patest\StructType\RecordSetOfQueryBuilder_Criteria $criteria = null)
    {
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnabled()
    {
        return isset($this->Enabled) ? $this->Enabled : null;
    }
    /**
     * Set Enabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enabled
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        if (is_null($enabled) || (is_array($enabled) && empty($enabled))) {
            unset($this->Enabled);
        } else {
            $this->Enabled = $enabled;
        }
        return $this;
    }
    /**
     * Get InsertedQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryBuilder_Query|null
     */
    public function getInsertedQuery()
    {
        return isset($this->InsertedQuery) ? $this->InsertedQuery : null;
    }
    /**
     * Set InsertedQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryBuilder_Query $insertedQuery
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setInsertedQuery(\patest\StructType\QueryBuilder_Query $insertedQuery = null)
    {
        if (is_null($insertedQuery) || (is_array($insertedQuery) && empty($insertedQuery))) {
            unset($this->InsertedQuery);
        } else {
            $this->InsertedQuery = $insertedQuery;
        }
        return $this;
    }
    /**
     * Get Kind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKind()
    {
        return isset($this->Kind) ? $this->Kind : null;
    }
    /**
     * Set Kind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kind
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setKind($kind = null)
    {
        // validation for constraint: string
        if (!is_null($kind) && !is_string($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kind, true), gettype($kind)), __LINE__);
        }
        if (is_null($kind) || (is_array($kind) && empty($kind))) {
            unset($this->Kind);
        } else {
            $this->Kind = $kind;
        }
        return $this;
    }
    /**
     * Get Negated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNegated()
    {
        return isset($this->Negated) ? $this->Negated : null;
    }
    /**
     * Set Negated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $negated
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setNegated($negated = null)
    {
        // validation for constraint: boolean
        if (!is_null($negated) && !is_bool($negated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($negated, true), gettype($negated)), __LINE__);
        }
        if (is_null($negated) || (is_array($negated) && empty($negated))) {
            unset($this->Negated);
        } else {
            $this->Negated = $negated;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get ParentQueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentQueryId()
    {
        return isset($this->ParentQueryId) ? $this->ParentQueryId : null;
    }
    /**
     * Set ParentQueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentQueryId
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setParentQueryId($parentQueryId = null)
    {
        // validation for constraint: string
        if (!is_null($parentQueryId) && !is_string($parentQueryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentQueryId, true), gettype($parentQueryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentQueryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentQueryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentQueryId, true)), __LINE__);
        }
        if (is_null($parentQueryId) || (is_array($parentQueryId) && empty($parentQueryId))) {
            unset($this->ParentQueryId);
        } else {
            $this->ParentQueryId = $parentQueryId;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\QueryBuilder_SubQuery
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
