<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.QueryFilter StructType
 * @subpackage Structs
 */
class QueryBuilder_QueryFilter extends FilterEntity
{
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The DynamicAssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicAssociationId;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LinkToMarketingCampaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LinkToMarketingCampaigns;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The QuerySetsClientAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $QuerySetsClientAttributes;
    /**
     * Constructor method for QueryBuilder.QueryFilter
     * @uses QueryBuilder_QueryFilter::setCategoryIds()
     * @uses QueryBuilder_QueryFilter::setDynamicAssociationId()
     * @uses QueryBuilder_QueryFilter::setDynamicClientTypeId()
     * @uses QueryBuilder_QueryFilter::setDynamicPreferenceId()
     * @uses QueryBuilder_QueryFilter::setIsActive()
     * @uses QueryBuilder_QueryFilter::setLinkToMarketingCampaigns()
     * @uses QueryBuilder_QueryFilter::setName()
     * @uses QueryBuilder_QueryFilter::setQuerySetsClientAttributes()
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param string $dynamicAssociationId
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param bool $isActive
     * @param bool $linkToMarketingCampaigns
     * @param string $name
     * @param bool $querySetsClientAttributes
     */
    public function __construct(\patest\StructType\CategoryIds $categoryIds = null, $dynamicAssociationId = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $isActive = null, $linkToMarketingCampaigns = null, $name = null, $querySetsClientAttributes = null)
    {
        $this
            ->setCategoryIds($categoryIds)
            ->setDynamicAssociationId($dynamicAssociationId)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setIsActive($isActive)
            ->setLinkToMarketingCampaigns($linkToMarketingCampaigns)
            ->setName($name)
            ->setQuerySetsClientAttributes($querySetsClientAttributes);
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get DynamicAssociationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAssociationId()
    {
        return isset($this->DynamicAssociationId) ? $this->DynamicAssociationId : null;
    }
    /**
     * Set DynamicAssociationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicAssociationId
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setDynamicAssociationId($dynamicAssociationId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicAssociationId) && !is_string($dynamicAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicAssociationId, true), gettype($dynamicAssociationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicAssociationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicAssociationId, true)), __LINE__);
        }
        if (is_null($dynamicAssociationId) || (is_array($dynamicAssociationId) && empty($dynamicAssociationId))) {
            unset($this->DynamicAssociationId);
        } else {
            $this->DynamicAssociationId = $dynamicAssociationId;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LinkToMarketingCampaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLinkToMarketingCampaigns()
    {
        return isset($this->LinkToMarketingCampaigns) ? $this->LinkToMarketingCampaigns : null;
    }
    /**
     * Set LinkToMarketingCampaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $linkToMarketingCampaigns
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setLinkToMarketingCampaigns($linkToMarketingCampaigns = null)
    {
        // validation for constraint: boolean
        if (!is_null($linkToMarketingCampaigns) && !is_bool($linkToMarketingCampaigns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($linkToMarketingCampaigns, true), gettype($linkToMarketingCampaigns)), __LINE__);
        }
        if (is_null($linkToMarketingCampaigns) || (is_array($linkToMarketingCampaigns) && empty($linkToMarketingCampaigns))) {
            unset($this->LinkToMarketingCampaigns);
        } else {
            $this->LinkToMarketingCampaigns = $linkToMarketingCampaigns;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get QuerySetsClientAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getQuerySetsClientAttributes()
    {
        return isset($this->QuerySetsClientAttributes) ? $this->QuerySetsClientAttributes : null;
    }
    /**
     * Set QuerySetsClientAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $querySetsClientAttributes
     * @return \patest\StructType\QueryBuilder_QueryFilter
     */
    public function setQuerySetsClientAttributes($querySetsClientAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($querySetsClientAttributes) && !is_bool($querySetsClientAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($querySetsClientAttributes, true), gettype($querySetsClientAttributes)), __LINE__);
        }
        if (is_null($querySetsClientAttributes) || (is_array($querySetsClientAttributes) && empty($querySetsClientAttributes))) {
            unset($this->QuerySetsClientAttributes);
        } else {
            $this->QuerySetsClientAttributes = $querySetsClientAttributes;
        }
        return $this;
    }
}
