<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.QueryCategory StructType
 * @subpackage Structs
 */
class QueryBuilder_QueryCategory extends MaintainableGlobalizedEntity
{
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnabled;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ParentCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentCategoryId;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Profiles
     */
    public $Profiles;
    /**
     * The QueriesCountInCategory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QueriesCountInCategory;
    /**
     * The QueryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryIds
     */
    public $QueryIds;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for QueryBuilder.QueryCategory
     * @uses QueryBuilder_QueryCategory::setIsEnabled()
     * @uses QueryBuilder_QueryCategory::setIsSystem()
     * @uses QueryBuilder_QueryCategory::setOrganizationUnitId()
     * @uses QueryBuilder_QueryCategory::setParentCategoryId()
     * @uses QueryBuilder_QueryCategory::setProfiles()
     * @uses QueryBuilder_QueryCategory::setQueriesCountInCategory()
     * @uses QueryBuilder_QueryCategory::setQueryIds()
     * @uses QueryBuilder_QueryCategory::setVisibleBySubordinates()
     * @param bool $isEnabled
     * @param bool $isSystem
     * @param string $organizationUnitId
     * @param string $parentCategoryId
     * @param \patest\StructType\Profiles $profiles
     * @param int $queriesCountInCategory
     * @param \patest\StructType\QueryIds $queryIds
     * @param bool $visibleBySubordinates
     */
    public function __construct($isEnabled = null, $isSystem = null, $organizationUnitId = null, $parentCategoryId = null, \patest\StructType\Profiles $profiles = null, $queriesCountInCategory = null, \patest\StructType\QueryIds $queryIds = null, $visibleBySubordinates = null)
    {
        $this
            ->setIsEnabled($isEnabled)
            ->setIsSystem($isSystem)
            ->setOrganizationUnitId($organizationUnitId)
            ->setParentCategoryId($parentCategoryId)
            ->setProfiles($profiles)
            ->setQueriesCountInCategory($queriesCountInCategory)
            ->setQueryIds($queryIds)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get IsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return isset($this->IsEnabled) ? $this->IsEnabled : null;
    }
    /**
     * Set IsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnabled
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        if (is_null($isEnabled) || (is_array($isEnabled) && empty($isEnabled))) {
            unset($this->IsEnabled);
        } else {
            $this->IsEnabled = $isEnabled;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ParentCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentCategoryId()
    {
        return isset($this->ParentCategoryId) ? $this->ParentCategoryId : null;
    }
    /**
     * Set ParentCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentCategoryId
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setParentCategoryId($parentCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($parentCategoryId) && !is_string($parentCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentCategoryId, true), gettype($parentCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentCategoryId, true)), __LINE__);
        }
        if (is_null($parentCategoryId) || (is_array($parentCategoryId) && empty($parentCategoryId))) {
            unset($this->ParentCategoryId);
        } else {
            $this->ParentCategoryId = $parentCategoryId;
        }
        return $this;
    }
    /**
     * Get Profiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Profiles|null
     */
    public function getProfiles()
    {
        return isset($this->Profiles) ? $this->Profiles : null;
    }
    /**
     * Set Profiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Profiles $profiles
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setProfiles(\patest\StructType\Profiles $profiles = null)
    {
        if (is_null($profiles) || (is_array($profiles) && empty($profiles))) {
            unset($this->Profiles);
        } else {
            $this->Profiles = $profiles;
        }
        return $this;
    }
    /**
     * Get QueriesCountInCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQueriesCountInCategory()
    {
        return isset($this->QueriesCountInCategory) ? $this->QueriesCountInCategory : null;
    }
    /**
     * Set QueriesCountInCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $queriesCountInCategory
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setQueriesCountInCategory($queriesCountInCategory = null)
    {
        // validation for constraint: int
        if (!is_null($queriesCountInCategory) && !(is_int($queriesCountInCategory) || ctype_digit($queriesCountInCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queriesCountInCategory, true), gettype($queriesCountInCategory)), __LINE__);
        }
        if (is_null($queriesCountInCategory) || (is_array($queriesCountInCategory) && empty($queriesCountInCategory))) {
            unset($this->QueriesCountInCategory);
        } else {
            $this->QueriesCountInCategory = $queriesCountInCategory;
        }
        return $this;
    }
    /**
     * Get QueryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryIds|null
     */
    public function getQueryIds()
    {
        return isset($this->QueryIds) ? $this->QueryIds : null;
    }
    /**
     * Set QueryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryIds $queryIds
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setQueryIds(\patest\StructType\QueryIds $queryIds = null)
    {
        if (is_null($queryIds) || (is_array($queryIds) && empty($queryIds))) {
            unset($this->QueryIds);
        } else {
            $this->QueryIds = $queryIds;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\QueryBuilder_QueryCategory
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
