<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.Query StructType
 * @subpackage Structs
 */
class QueryBuilder_Query extends MaintainableGlobalizedEntity
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Author;
    /**
     * The CanModify
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanModify;
    /**
     * The CanRun
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRun;
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The ContextName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextName;
    /**
     * The CriteriaOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CriteriaOperator;
    /**
     * The DynamicAssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicAssociationId;
    /**
     * The DynamicAttributeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DynamicAttributeAction;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The Favorite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Favorite;
    /**
     * The IncludeAccounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeAccounts;
    /**
     * The IncludeManuallyAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeManuallyAttributes;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsInUse
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInUse;
    /**
     * The LastRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastRun;
    /**
     * The Negated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Negated;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OthersCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanModify;
    /**
     * The OthersCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanRun;
    /**
     * The OutputProperties
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty
     */
    public $OutputProperties;
    /**
     * The ProfilesCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanModify
     */
    public $ProfilesCanModify;
    /**
     * The ProfilesCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanRun
     */
    public $ProfilesCanRun;
    /**
     * The QueryData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryData;
    /**
     * The QueryNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QueryNo;
    /**
     * The ReferenceQueryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReferenceQueryIds
     */
    public $ReferenceQueryIds;
    /**
     * The Shared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Shared;
    /**
     * The ShowDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowDeceased;
    /**
     * The ShowHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowHidden;
    /**
     * The ShowNotActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowNotActive;
    /**
     * The SubQueries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_SubQuery
     */
    public $SubQueries;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for QueryBuilder.Query
     * @uses QueryBuilder_Query::setApplication()
     * @uses QueryBuilder_Query::setAuthor()
     * @uses QueryBuilder_Query::setCanModify()
     * @uses QueryBuilder_Query::setCanRun()
     * @uses QueryBuilder_Query::setCategoryIds()
     * @uses QueryBuilder_Query::setContextName()
     * @uses QueryBuilder_Query::setCriteriaOperator()
     * @uses QueryBuilder_Query::setDynamicAssociationId()
     * @uses QueryBuilder_Query::setDynamicAttributeAction()
     * @uses QueryBuilder_Query::setDynamicClientTypeId()
     * @uses QueryBuilder_Query::setDynamicPreferenceId()
     * @uses QueryBuilder_Query::setFavorite()
     * @uses QueryBuilder_Query::setIncludeAccounts()
     * @uses QueryBuilder_Query::setIncludeManuallyAttributes()
     * @uses QueryBuilder_Query::setIsActive()
     * @uses QueryBuilder_Query::setIsInUse()
     * @uses QueryBuilder_Query::setLastRun()
     * @uses QueryBuilder_Query::setNegated()
     * @uses QueryBuilder_Query::setOrganizationUnitId()
     * @uses QueryBuilder_Query::setOthersCanModify()
     * @uses QueryBuilder_Query::setOthersCanRun()
     * @uses QueryBuilder_Query::setOutputProperties()
     * @uses QueryBuilder_Query::setProfilesCanModify()
     * @uses QueryBuilder_Query::setProfilesCanRun()
     * @uses QueryBuilder_Query::setQueryData()
     * @uses QueryBuilder_Query::setQueryNo()
     * @uses QueryBuilder_Query::setReferenceQueryIds()
     * @uses QueryBuilder_Query::setShared()
     * @uses QueryBuilder_Query::setShowDeceased()
     * @uses QueryBuilder_Query::setShowHidden()
     * @uses QueryBuilder_Query::setShowNotActive()
     * @uses QueryBuilder_Query::setSubQueries()
     * @uses QueryBuilder_Query::setVisibleBySubordinates()
     * @param string $application
     * @param string $author
     * @param bool $canModify
     * @param bool $canRun
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param string $contextName
     * @param string $criteriaOperator
     * @param string $dynamicAssociationId
     * @param string $dynamicAttributeAction
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param bool $favorite
     * @param bool $includeAccounts
     * @param bool $includeManuallyAttributes
     * @param bool $isActive
     * @param bool $isInUse
     * @param string $lastRun
     * @param bool $negated
     * @param string $organizationUnitId
     * @param string $othersCanModify
     * @param string $othersCanRun
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @param string $queryData
     * @param int $queryNo
     * @param \patest\StructType\ReferenceQueryIds $referenceQueryIds
     * @param bool $shared
     * @param bool $showDeceased
     * @param bool $showHidden
     * @param bool $showNotActive
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @param bool $visibleBySubordinates
     */
    public function __construct($application = null, $author = null, $canModify = null, $canRun = null, \patest\StructType\CategoryIds $categoryIds = null, $contextName = null, $criteriaOperator = null, $dynamicAssociationId = null, $dynamicAttributeAction = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $favorite = null, $includeAccounts = null, $includeManuallyAttributes = null, $isActive = null, $isInUse = null, $lastRun = null, $negated = null, $organizationUnitId = null, $othersCanModify = null, $othersCanRun = null, \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null, \patest\StructType\ProfilesCanModify $profilesCanModify = null, \patest\StructType\ProfilesCanRun $profilesCanRun = null, $queryData = null, $queryNo = null, \patest\StructType\ReferenceQueryIds $referenceQueryIds = null, $shared = null, $showDeceased = null, $showHidden = null, $showNotActive = null, \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null, $visibleBySubordinates = null)
    {
        $this
            ->setApplication($application)
            ->setAuthor($author)
            ->setCanModify($canModify)
            ->setCanRun($canRun)
            ->setCategoryIds($categoryIds)
            ->setContextName($contextName)
            ->setCriteriaOperator($criteriaOperator)
            ->setDynamicAssociationId($dynamicAssociationId)
            ->setDynamicAttributeAction($dynamicAttributeAction)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setFavorite($favorite)
            ->setIncludeAccounts($includeAccounts)
            ->setIncludeManuallyAttributes($includeManuallyAttributes)
            ->setIsActive($isActive)
            ->setIsInUse($isInUse)
            ->setLastRun($lastRun)
            ->setNegated($negated)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOthersCanModify($othersCanModify)
            ->setOthersCanRun($othersCanRun)
            ->setOutputProperties($outputProperties)
            ->setProfilesCanModify($profilesCanModify)
            ->setProfilesCanRun($profilesCanRun)
            ->setQueryData($queryData)
            ->setQueryNo($queryNo)
            ->setReferenceQueryIds($referenceQueryIds)
            ->setShared($shared)
            ->setShowDeceased($showDeceased)
            ->setShowHidden($showHidden)
            ->setShowNotActive($showNotActive)
            ->setSubQueries($subQueries)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get Author value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthor()
    {
        return isset($this->Author) ? $this->Author : null;
    }
    /**
     * Set Author value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $author
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        if (is_null($author) || (is_array($author) && empty($author))) {
            unset($this->Author);
        } else {
            $this->Author = $author;
        }
        return $this;
    }
    /**
     * Get CanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanModify()
    {
        return isset($this->CanModify) ? $this->CanModify : null;
    }
    /**
     * Set CanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canModify
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setCanModify($canModify = null)
    {
        // validation for constraint: boolean
        if (!is_null($canModify) && !is_bool($canModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canModify, true), gettype($canModify)), __LINE__);
        }
        if (is_null($canModify) || (is_array($canModify) && empty($canModify))) {
            unset($this->CanModify);
        } else {
            $this->CanModify = $canModify;
        }
        return $this;
    }
    /**
     * Get CanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRun()
    {
        return isset($this->CanRun) ? $this->CanRun : null;
    }
    /**
     * Set CanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRun
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setCanRun($canRun = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRun) && !is_bool($canRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRun, true), gettype($canRun)), __LINE__);
        }
        if (is_null($canRun) || (is_array($canRun) && empty($canRun))) {
            unset($this->CanRun);
        } else {
            $this->CanRun = $canRun;
        }
        return $this;
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get ContextName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextName()
    {
        return isset($this->ContextName) ? $this->ContextName : null;
    }
    /**
     * Set ContextName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextName
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setContextName($contextName = null)
    {
        // validation for constraint: string
        if (!is_null($contextName) && !is_string($contextName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextName, true), gettype($contextName)), __LINE__);
        }
        if (is_null($contextName) || (is_array($contextName) && empty($contextName))) {
            unset($this->ContextName);
        } else {
            $this->ContextName = $contextName;
        }
        return $this;
    }
    /**
     * Get CriteriaOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriteriaOperator()
    {
        return isset($this->CriteriaOperator) ? $this->CriteriaOperator : null;
    }
    /**
     * Set CriteriaOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\QueryCriteriaOperator::valueIsValid()
     * @uses \patest\EnumType\QueryCriteriaOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $criteriaOperator
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setCriteriaOperator($criteriaOperator = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\QueryCriteriaOperator::valueIsValid($criteriaOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\QueryCriteriaOperator', is_array($criteriaOperator) ? implode(', ', $criteriaOperator) : var_export($criteriaOperator, true), implode(', ', \patest\EnumType\QueryCriteriaOperator::getValidValues())), __LINE__);
        }
        if (is_null($criteriaOperator) || (is_array($criteriaOperator) && empty($criteriaOperator))) {
            unset($this->CriteriaOperator);
        } else {
            $this->CriteriaOperator = $criteriaOperator;
        }
        return $this;
    }
    /**
     * Get DynamicAssociationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAssociationId()
    {
        return isset($this->DynamicAssociationId) ? $this->DynamicAssociationId : null;
    }
    /**
     * Set DynamicAssociationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicAssociationId
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setDynamicAssociationId($dynamicAssociationId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicAssociationId) && !is_string($dynamicAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicAssociationId, true), gettype($dynamicAssociationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicAssociationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicAssociationId, true)), __LINE__);
        }
        if (is_null($dynamicAssociationId) || (is_array($dynamicAssociationId) && empty($dynamicAssociationId))) {
            unset($this->DynamicAssociationId);
        } else {
            $this->DynamicAssociationId = $dynamicAssociationId;
        }
        return $this;
    }
    /**
     * Get DynamicAttributeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAttributeAction()
    {
        return isset($this->DynamicAttributeAction) ? $this->DynamicAttributeAction : null;
    }
    /**
     * Set DynamicAttributeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DynamicAttributeAction::valueIsValid()
     * @uses \patest\EnumType\DynamicAttributeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicAttributeAction
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setDynamicAttributeAction($dynamicAttributeAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DynamicAttributeAction::valueIsValid($dynamicAttributeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DynamicAttributeAction', is_array($dynamicAttributeAction) ? implode(', ', $dynamicAttributeAction) : var_export($dynamicAttributeAction, true), implode(', ', \patest\EnumType\DynamicAttributeAction::getValidValues())), __LINE__);
        }
        if (is_null($dynamicAttributeAction) || (is_array($dynamicAttributeAction) && empty($dynamicAttributeAction))) {
            unset($this->DynamicAttributeAction);
        } else {
            $this->DynamicAttributeAction = $dynamicAttributeAction;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get Favorite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFavorite()
    {
        return isset($this->Favorite) ? $this->Favorite : null;
    }
    /**
     * Set Favorite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $favorite
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setFavorite($favorite = null)
    {
        // validation for constraint: boolean
        if (!is_null($favorite) && !is_bool($favorite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($favorite, true), gettype($favorite)), __LINE__);
        }
        if (is_null($favorite) || (is_array($favorite) && empty($favorite))) {
            unset($this->Favorite);
        } else {
            $this->Favorite = $favorite;
        }
        return $this;
    }
    /**
     * Get IncludeAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAccounts()
    {
        return isset($this->IncludeAccounts) ? $this->IncludeAccounts : null;
    }
    /**
     * Set IncludeAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAccounts
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setIncludeAccounts($includeAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAccounts) && !is_bool($includeAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAccounts, true), gettype($includeAccounts)), __LINE__);
        }
        if (is_null($includeAccounts) || (is_array($includeAccounts) && empty($includeAccounts))) {
            unset($this->IncludeAccounts);
        } else {
            $this->IncludeAccounts = $includeAccounts;
        }
        return $this;
    }
    /**
     * Get IncludeManuallyAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeManuallyAttributes()
    {
        return isset($this->IncludeManuallyAttributes) ? $this->IncludeManuallyAttributes : null;
    }
    /**
     * Set IncludeManuallyAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeManuallyAttributes
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setIncludeManuallyAttributes($includeManuallyAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeManuallyAttributes) && !is_bool($includeManuallyAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeManuallyAttributes, true), gettype($includeManuallyAttributes)), __LINE__);
        }
        if (is_null($includeManuallyAttributes) || (is_array($includeManuallyAttributes) && empty($includeManuallyAttributes))) {
            unset($this->IncludeManuallyAttributes);
        } else {
            $this->IncludeManuallyAttributes = $includeManuallyAttributes;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsInUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInUse()
    {
        return isset($this->IsInUse) ? $this->IsInUse : null;
    }
    /**
     * Set IsInUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInUse
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setIsInUse($isInUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInUse) && !is_bool($isInUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInUse, true), gettype($isInUse)), __LINE__);
        }
        if (is_null($isInUse) || (is_array($isInUse) && empty($isInUse))) {
            unset($this->IsInUse);
        } else {
            $this->IsInUse = $isInUse;
        }
        return $this;
    }
    /**
     * Get LastRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastRun()
    {
        return isset($this->LastRun) ? $this->LastRun : null;
    }
    /**
     * Set LastRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastRun
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setLastRun($lastRun = null)
    {
        // validation for constraint: string
        if (!is_null($lastRun) && !is_string($lastRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRun, true), gettype($lastRun)), __LINE__);
        }
        if (is_null($lastRun) || (is_array($lastRun) && empty($lastRun))) {
            unset($this->LastRun);
        } else {
            $this->LastRun = $lastRun;
        }
        return $this;
    }
    /**
     * Get Negated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNegated()
    {
        return isset($this->Negated) ? $this->Negated : null;
    }
    /**
     * Set Negated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $negated
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setNegated($negated = null)
    {
        // validation for constraint: boolean
        if (!is_null($negated) && !is_bool($negated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($negated, true), gettype($negated)), __LINE__);
        }
        if (is_null($negated) || (is_array($negated) && empty($negated))) {
            unset($this->Negated);
        } else {
            $this->Negated = $negated;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OthersCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanModify()
    {
        return isset($this->OthersCanModify) ? $this->OthersCanModify : null;
    }
    /**
     * Set OthersCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\QueryPermissions::valueIsValid()
     * @uses \patest\EnumType\QueryPermissions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanModify
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setOthersCanModify($othersCanModify = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\QueryPermissions::valueIsValid($othersCanModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\QueryPermissions', is_array($othersCanModify) ? implode(', ', $othersCanModify) : var_export($othersCanModify, true), implode(', ', \patest\EnumType\QueryPermissions::getValidValues())), __LINE__);
        }
        if (is_null($othersCanModify) || (is_array($othersCanModify) && empty($othersCanModify))) {
            unset($this->OthersCanModify);
        } else {
            $this->OthersCanModify = $othersCanModify;
        }
        return $this;
    }
    /**
     * Get OthersCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanRun()
    {
        return isset($this->OthersCanRun) ? $this->OthersCanRun : null;
    }
    /**
     * Set OthersCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\QueryPermissions::valueIsValid()
     * @uses \patest\EnumType\QueryPermissions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanRun
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setOthersCanRun($othersCanRun = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\QueryPermissions::valueIsValid($othersCanRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\QueryPermissions', is_array($othersCanRun) ? implode(', ', $othersCanRun) : var_export($othersCanRun, true), implode(', ', \patest\EnumType\QueryPermissions::getValidValues())), __LINE__);
        }
        if (is_null($othersCanRun) || (is_array($othersCanRun) && empty($othersCanRun))) {
            unset($this->OthersCanRun);
        } else {
            $this->OthersCanRun = $othersCanRun;
        }
        return $this;
    }
    /**
     * Get OutputProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty|null
     */
    public function getOutputProperties()
    {
        return isset($this->OutputProperties) ? $this->OutputProperties : null;
    }
    /**
     * Set OutputProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setOutputProperties(\patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null)
    {
        if (is_null($outputProperties) || (is_array($outputProperties) && empty($outputProperties))) {
            unset($this->OutputProperties);
        } else {
            $this->OutputProperties = $outputProperties;
        }
        return $this;
    }
    /**
     * Get ProfilesCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanModify|null
     */
    public function getProfilesCanModify()
    {
        return isset($this->ProfilesCanModify) ? $this->ProfilesCanModify : null;
    }
    /**
     * Set ProfilesCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setProfilesCanModify(\patest\StructType\ProfilesCanModify $profilesCanModify = null)
    {
        if (is_null($profilesCanModify) || (is_array($profilesCanModify) && empty($profilesCanModify))) {
            unset($this->ProfilesCanModify);
        } else {
            $this->ProfilesCanModify = $profilesCanModify;
        }
        return $this;
    }
    /**
     * Get ProfilesCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanRun|null
     */
    public function getProfilesCanRun()
    {
        return isset($this->ProfilesCanRun) ? $this->ProfilesCanRun : null;
    }
    /**
     * Set ProfilesCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setProfilesCanRun(\patest\StructType\ProfilesCanRun $profilesCanRun = null)
    {
        if (is_null($profilesCanRun) || (is_array($profilesCanRun) && empty($profilesCanRun))) {
            unset($this->ProfilesCanRun);
        } else {
            $this->ProfilesCanRun = $profilesCanRun;
        }
        return $this;
    }
    /**
     * Get QueryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryData()
    {
        return isset($this->QueryData) ? $this->QueryData : null;
    }
    /**
     * Set QueryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryData
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setQueryData($queryData = null)
    {
        // validation for constraint: string
        if (!is_null($queryData) && !is_string($queryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryData, true), gettype($queryData)), __LINE__);
        }
        if (is_null($queryData) || (is_array($queryData) && empty($queryData))) {
            unset($this->QueryData);
        } else {
            $this->QueryData = $queryData;
        }
        return $this;
    }
    /**
     * Get QueryNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQueryNo()
    {
        return isset($this->QueryNo) ? $this->QueryNo : null;
    }
    /**
     * Set QueryNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $queryNo
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setQueryNo($queryNo = null)
    {
        // validation for constraint: int
        if (!is_null($queryNo) && !(is_int($queryNo) || ctype_digit($queryNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryNo, true), gettype($queryNo)), __LINE__);
        }
        if (is_null($queryNo) || (is_array($queryNo) && empty($queryNo))) {
            unset($this->QueryNo);
        } else {
            $this->QueryNo = $queryNo;
        }
        return $this;
    }
    /**
     * Get ReferenceQueryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReferenceQueryIds|null
     */
    public function getReferenceQueryIds()
    {
        return isset($this->ReferenceQueryIds) ? $this->ReferenceQueryIds : null;
    }
    /**
     * Set ReferenceQueryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReferenceQueryIds $referenceQueryIds
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setReferenceQueryIds(\patest\StructType\ReferenceQueryIds $referenceQueryIds = null)
    {
        if (is_null($referenceQueryIds) || (is_array($referenceQueryIds) && empty($referenceQueryIds))) {
            unset($this->ReferenceQueryIds);
        } else {
            $this->ReferenceQueryIds = $referenceQueryIds;
        }
        return $this;
    }
    /**
     * Get Shared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShared()
    {
        return isset($this->Shared) ? $this->Shared : null;
    }
    /**
     * Set Shared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shared
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setShared($shared = null)
    {
        // validation for constraint: boolean
        if (!is_null($shared) && !is_bool($shared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shared, true), gettype($shared)), __LINE__);
        }
        if (is_null($shared) || (is_array($shared) && empty($shared))) {
            unset($this->Shared);
        } else {
            $this->Shared = $shared;
        }
        return $this;
    }
    /**
     * Get ShowDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowDeceased()
    {
        return isset($this->ShowDeceased) ? $this->ShowDeceased : null;
    }
    /**
     * Set ShowDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showDeceased
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setShowDeceased($showDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDeceased) && !is_bool($showDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDeceased, true), gettype($showDeceased)), __LINE__);
        }
        if (is_null($showDeceased) || (is_array($showDeceased) && empty($showDeceased))) {
            unset($this->ShowDeceased);
        } else {
            $this->ShowDeceased = $showDeceased;
        }
        return $this;
    }
    /**
     * Get ShowHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowHidden()
    {
        return isset($this->ShowHidden) ? $this->ShowHidden : null;
    }
    /**
     * Set ShowHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showHidden
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setShowHidden($showHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($showHidden) && !is_bool($showHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showHidden, true), gettype($showHidden)), __LINE__);
        }
        if (is_null($showHidden) || (is_array($showHidden) && empty($showHidden))) {
            unset($this->ShowHidden);
        } else {
            $this->ShowHidden = $showHidden;
        }
        return $this;
    }
    /**
     * Get ShowNotActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowNotActive()
    {
        return isset($this->ShowNotActive) ? $this->ShowNotActive : null;
    }
    /**
     * Set ShowNotActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showNotActive
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setShowNotActive($showNotActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($showNotActive) && !is_bool($showNotActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showNotActive, true), gettype($showNotActive)), __LINE__);
        }
        if (is_null($showNotActive) || (is_array($showNotActive) && empty($showNotActive))) {
            unset($this->ShowNotActive);
        } else {
            $this->ShowNotActive = $showNotActive;
        }
        return $this;
    }
    /**
     * Get SubQueries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_SubQuery|null
     */
    public function getSubQueries()
    {
        return isset($this->SubQueries) ? $this->SubQueries : null;
    }
    /**
     * Set SubQueries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setSubQueries(\patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null)
    {
        if (is_null($subQueries) || (is_array($subQueries) && empty($subQueries))) {
            unset($this->SubQueries);
        } else {
            $this->SubQueries = $subQueries;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\QueryBuilder_Query
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
