<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryAreaAvailabilityResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryAreaAvailabilityResponse
 * @subpackage Structs
 */
class QueryAreaAvailabilityResponse extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AvailablePriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AvailablePriceLevelIds;
    /**
     * The HeldResaleRequestIdsForGA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $HeldResaleRequestIdsForGA;
    /**
     * The LimitationsConsumption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfLimitationConsumptionItem
     */
    public $LimitationsConsumption;
    /**
     * The RegularConsumptionSplit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatsConsumptionSplitItem
     */
    public $RegularConsumptionSplit;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatingType;
    /**
     * The SeatsProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaSeatsProperties
     */
    public $SeatsProperties;
    /**
     * The SessionSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo
     */
    public $SessionSeats;
    /**
     * The Statistics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CapacityCounters
     */
    public $Statistics;
    /**
     * The StatisticsByPriceLevelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea
     */
    public $StatisticsByPriceLevelId;
    /**
     * The StatisticsBySeatSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l
     */
    public $StatisticsBySeatSet;
    /**
     * Constructor method for QueryAreaAvailabilityResponse
     * @uses QueryAreaAvailabilityResponse::setAreaId()
     * @uses QueryAreaAvailabilityResponse::setAvailablePriceLevelIds()
     * @uses QueryAreaAvailabilityResponse::setHeldResaleRequestIdsForGA()
     * @uses QueryAreaAvailabilityResponse::setLimitationsConsumption()
     * @uses QueryAreaAvailabilityResponse::setRegularConsumptionSplit()
     * @uses QueryAreaAvailabilityResponse::setSeatingType()
     * @uses QueryAreaAvailabilityResponse::setSeatsProperties()
     * @uses QueryAreaAvailabilityResponse::setSessionSeats()
     * @uses QueryAreaAvailabilityResponse::setStatistics()
     * @uses QueryAreaAvailabilityResponse::setStatisticsByPriceLevelId()
     * @uses QueryAreaAvailabilityResponse::setStatisticsBySeatSet()
     * @param string $areaId
     * @param \patest\ArrayType\ArrayOfguid $availablePriceLevelIds
     * @param \patest\ArrayType\ArrayOfguid $heldResaleRequestIdsForGA
     * @param \patest\ArrayType\ArrayOfLimitationConsumptionItem $limitationsConsumption
     * @param \patest\ArrayType\ArrayOfSeatsConsumptionSplitItem $regularConsumptionSplit
     * @param string $seatingType
     * @param \patest\StructType\AreaSeatsProperties $seatsProperties
     * @param \patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo $sessionSeats
     * @param \patest\StructType\CapacityCounters $statistics
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea $statisticsByPriceLevelId
     * @param \patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l $statisticsBySeatSet
     */
    public function __construct($areaId = null, \patest\ArrayType\ArrayOfguid $availablePriceLevelIds = null, \patest\ArrayType\ArrayOfguid $heldResaleRequestIdsForGA = null, \patest\ArrayType\ArrayOfLimitationConsumptionItem $limitationsConsumption = null, \patest\ArrayType\ArrayOfSeatsConsumptionSplitItem $regularConsumptionSplit = null, $seatingType = null, \patest\StructType\AreaSeatsProperties $seatsProperties = null, \patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo $sessionSeats = null, \patest\StructType\CapacityCounters $statistics = null, \patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea $statisticsByPriceLevelId = null, \patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l $statisticsBySeatSet = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAvailablePriceLevelIds($availablePriceLevelIds)
            ->setHeldResaleRequestIdsForGA($heldResaleRequestIdsForGA)
            ->setLimitationsConsumption($limitationsConsumption)
            ->setRegularConsumptionSplit($regularConsumptionSplit)
            ->setSeatingType($seatingType)
            ->setSeatsProperties($seatsProperties)
            ->setSessionSeats($sessionSeats)
            ->setStatistics($statistics)
            ->setStatisticsByPriceLevelId($statisticsByPriceLevelId)
            ->setStatisticsBySeatSet($statisticsBySeatSet);
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
    /**
     * Get AvailablePriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAvailablePriceLevelIds()
    {
        return isset($this->AvailablePriceLevelIds) ? $this->AvailablePriceLevelIds : null;
    }
    /**
     * Set AvailablePriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $availablePriceLevelIds
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setAvailablePriceLevelIds(\patest\ArrayType\ArrayOfguid $availablePriceLevelIds = null)
    {
        if (is_null($availablePriceLevelIds) || (is_array($availablePriceLevelIds) && empty($availablePriceLevelIds))) {
            unset($this->AvailablePriceLevelIds);
        } else {
            $this->AvailablePriceLevelIds = $availablePriceLevelIds;
        }
        return $this;
    }
    /**
     * Get HeldResaleRequestIdsForGA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getHeldResaleRequestIdsForGA()
    {
        return isset($this->HeldResaleRequestIdsForGA) ? $this->HeldResaleRequestIdsForGA : null;
    }
    /**
     * Set HeldResaleRequestIdsForGA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $heldResaleRequestIdsForGA
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setHeldResaleRequestIdsForGA(\patest\ArrayType\ArrayOfguid $heldResaleRequestIdsForGA = null)
    {
        if (is_null($heldResaleRequestIdsForGA) || (is_array($heldResaleRequestIdsForGA) && empty($heldResaleRequestIdsForGA))) {
            unset($this->HeldResaleRequestIdsForGA);
        } else {
            $this->HeldResaleRequestIdsForGA = $heldResaleRequestIdsForGA;
        }
        return $this;
    }
    /**
     * Get LimitationsConsumption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfLimitationConsumptionItem|null
     */
    public function getLimitationsConsumption()
    {
        return isset($this->LimitationsConsumption) ? $this->LimitationsConsumption : null;
    }
    /**
     * Set LimitationsConsumption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfLimitationConsumptionItem $limitationsConsumption
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setLimitationsConsumption(\patest\ArrayType\ArrayOfLimitationConsumptionItem $limitationsConsumption = null)
    {
        if (is_null($limitationsConsumption) || (is_array($limitationsConsumption) && empty($limitationsConsumption))) {
            unset($this->LimitationsConsumption);
        } else {
            $this->LimitationsConsumption = $limitationsConsumption;
        }
        return $this;
    }
    /**
     * Get RegularConsumptionSplit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatsConsumptionSplitItem|null
     */
    public function getRegularConsumptionSplit()
    {
        return isset($this->RegularConsumptionSplit) ? $this->RegularConsumptionSplit : null;
    }
    /**
     * Set RegularConsumptionSplit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatsConsumptionSplitItem $regularConsumptionSplit
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setRegularConsumptionSplit(\patest\ArrayType\ArrayOfSeatsConsumptionSplitItem $regularConsumptionSplit = null)
    {
        if (is_null($regularConsumptionSplit) || (is_array($regularConsumptionSplit) && empty($regularConsumptionSplit))) {
            unset($this->RegularConsumptionSplit);
        } else {
            $this->RegularConsumptionSplit = $regularConsumptionSplit;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * @return string|null
     */
    public function getSeatingType()
    {
        return $this->SeatingType;
    }
    /**
     * Set SeatingType value
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        $this->SeatingType = $seatingType;
        return $this;
    }
    /**
     * Get SeatsProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaSeatsProperties|null
     */
    public function getSeatsProperties()
    {
        return isset($this->SeatsProperties) ? $this->SeatsProperties : null;
    }
    /**
     * Set SeatsProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaSeatsProperties $seatsProperties
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setSeatsProperties(\patest\StructType\AreaSeatsProperties $seatsProperties = null)
    {
        if (is_null($seatsProperties) || (is_array($seatsProperties) && empty($seatsProperties))) {
            unset($this->SeatsProperties);
        } else {
            $this->SeatsProperties = $seatsProperties;
        }
        return $this;
    }
    /**
     * Get SessionSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo|null
     */
    public function getSessionSeats()
    {
        return isset($this->SessionSeats) ? $this->SessionSeats : null;
    }
    /**
     * Set SessionSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo $sessionSeats
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setSessionSeats(\patest\ArrayType\ArrayOfSeatingPlanManagerSessionSeatInfo $sessionSeats = null)
    {
        if (is_null($sessionSeats) || (is_array($sessionSeats) && empty($sessionSeats))) {
            unset($this->SessionSeats);
        } else {
            $this->SessionSeats = $sessionSeats;
        }
        return $this;
    }
    /**
     * Get Statistics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CapacityCounters|null
     */
    public function getStatistics()
    {
        return isset($this->Statistics) ? $this->Statistics : null;
    }
    /**
     * Set Statistics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CapacityCounters $statistics
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setStatistics(\patest\StructType\CapacityCounters $statistics = null)
    {
        if (is_null($statistics) || (is_array($statistics) && empty($statistics))) {
            unset($this->Statistics);
        } else {
            $this->Statistics = $statistics;
        }
        return $this;
    }
    /**
     * Get StatisticsByPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea|null
     */
    public function getStatisticsByPriceLevelId()
    {
        return isset($this->StatisticsByPriceLevelId) ? $this->StatisticsByPriceLevelId : null;
    }
    /**
     * Set StatisticsByPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea $statisticsByPriceLevelId
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setStatisticsByPriceLevelId(\patest\ArrayType\ArrayOfKeyValueOfguidCapacityCountershpjoQDea $statisticsByPriceLevelId = null)
    {
        if (is_null($statisticsByPriceLevelId) || (is_array($statisticsByPriceLevelId) && empty($statisticsByPriceLevelId))) {
            unset($this->StatisticsByPriceLevelId);
        } else {
            $this->StatisticsByPriceLevelId = $statisticsByPriceLevelId;
        }
        return $this;
    }
    /**
     * Get StatisticsBySeatSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l|null
     */
    public function getStatisticsBySeatSet()
    {
        return isset($this->StatisticsBySeatSet) ? $this->StatisticsBySeatSet : null;
    }
    /**
     * Set StatisticsBySeatSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l $statisticsBySeatSet
     * @return \patest\StructType\QueryAreaAvailabilityResponse
     */
    public function setStatisticsBySeatSet(\patest\ArrayType\ArrayOfKeyValueOfSeatSetIdentityCapacityCountersn51wGZ5l $statisticsBySeatSet = null)
    {
        if (is_null($statisticsBySeatSet) || (is_array($statisticsBySeatSet) && empty($statisticsBySeatSet))) {
            unset($this->StatisticsBySeatSet);
        } else {
            $this->StatisticsBySeatSet = $statisticsBySeatSet;
        }
        return $this;
    }
}
