<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryAreaAvailabilityRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryAreaAvailabilityRequest
 * @subpackage Structs
 */
class QueryAreaAvailabilityRequest extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The IsIgnoreWhenNoSuchArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIgnoreWhenNoSuchArea;
    /**
     * The IsQueryPerSeatInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsQueryPerSeatInfo;
    /**
     * The SeatPropertiesToQuery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatPropertyNames
     */
    public $SeatPropertiesToQuery;
    /**
     * The StatisticsToQuery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $StatisticsToQuery;
    /**
     * The OnlySeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $OnlySeatIds;
    /**
     * Constructor method for QueryAreaAvailabilityRequest
     * @uses QueryAreaAvailabilityRequest::setAreaId()
     * @uses QueryAreaAvailabilityRequest::setIsIgnoreWhenNoSuchArea()
     * @uses QueryAreaAvailabilityRequest::setIsQueryPerSeatInfo()
     * @uses QueryAreaAvailabilityRequest::setSeatPropertiesToQuery()
     * @uses QueryAreaAvailabilityRequest::setStatisticsToQuery()
     * @uses QueryAreaAvailabilityRequest::setOnlySeatIds()
     * @param string $areaId
     * @param bool $isIgnoreWhenNoSuchArea
     * @param bool $isQueryPerSeatInfo
     * @param \patest\ArrayType\ArrayOfSeatPropertyNames $seatPropertiesToQuery
     * @param string[] $statisticsToQuery
     * @param \patest\ArrayType\ArrayOfint $onlySeatIds
     */
    public function __construct($areaId = null, $isIgnoreWhenNoSuchArea = null, $isQueryPerSeatInfo = null, \patest\ArrayType\ArrayOfSeatPropertyNames $seatPropertiesToQuery = null, array $statisticsToQuery = array(), \patest\ArrayType\ArrayOfint $onlySeatIds = null)
    {
        $this
            ->setAreaId($areaId)
            ->setIsIgnoreWhenNoSuchArea($isIgnoreWhenNoSuchArea)
            ->setIsQueryPerSeatInfo($isQueryPerSeatInfo)
            ->setSeatPropertiesToQuery($seatPropertiesToQuery)
            ->setStatisticsToQuery($statisticsToQuery)
            ->setOnlySeatIds($onlySeatIds);
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
    /**
     * Get IsIgnoreWhenNoSuchArea value
     * @return bool|null
     */
    public function getIsIgnoreWhenNoSuchArea()
    {
        return $this->IsIgnoreWhenNoSuchArea;
    }
    /**
     * Set IsIgnoreWhenNoSuchArea value
     * @param bool $isIgnoreWhenNoSuchArea
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setIsIgnoreWhenNoSuchArea($isIgnoreWhenNoSuchArea = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIgnoreWhenNoSuchArea) && !is_bool($isIgnoreWhenNoSuchArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIgnoreWhenNoSuchArea, true), gettype($isIgnoreWhenNoSuchArea)), __LINE__);
        }
        $this->IsIgnoreWhenNoSuchArea = $isIgnoreWhenNoSuchArea;
        return $this;
    }
    /**
     * Get IsQueryPerSeatInfo value
     * @return bool|null
     */
    public function getIsQueryPerSeatInfo()
    {
        return $this->IsQueryPerSeatInfo;
    }
    /**
     * Set IsQueryPerSeatInfo value
     * @param bool $isQueryPerSeatInfo
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setIsQueryPerSeatInfo($isQueryPerSeatInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQueryPerSeatInfo) && !is_bool($isQueryPerSeatInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQueryPerSeatInfo, true), gettype($isQueryPerSeatInfo)), __LINE__);
        }
        $this->IsQueryPerSeatInfo = $isQueryPerSeatInfo;
        return $this;
    }
    /**
     * Get SeatPropertiesToQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatPropertyNames|null
     */
    public function getSeatPropertiesToQuery()
    {
        return isset($this->SeatPropertiesToQuery) ? $this->SeatPropertiesToQuery : null;
    }
    /**
     * Set SeatPropertiesToQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatPropertyNames $seatPropertiesToQuery
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setSeatPropertiesToQuery(\patest\ArrayType\ArrayOfSeatPropertyNames $seatPropertiesToQuery = null)
    {
        if (is_null($seatPropertiesToQuery) || (is_array($seatPropertiesToQuery) && empty($seatPropertiesToQuery))) {
            unset($this->SeatPropertiesToQuery);
        } else {
            $this->SeatPropertiesToQuery = $seatPropertiesToQuery;
        }
        return $this;
    }
    /**
     * Get StatisticsToQuery value
     * @return string[]|null
     */
    public function getStatisticsToQuery()
    {
        return $this->StatisticsToQuery;
    }
    /**
     * This method is responsible for validating the values passed to the setStatisticsToQuery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatisticsToQuery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatisticsToQueryForArrayConstraintsFromSetStatisticsToQuery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queryAreaAvailabilityRequestStatisticsToQueryItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatingPlanStatisticsType::valueIsValid($queryAreaAvailabilityRequestStatisticsToQueryItem)) {
                $invalidValues[] = is_object($queryAreaAvailabilityRequestStatisticsToQueryItem) ? get_class($queryAreaAvailabilityRequestStatisticsToQueryItem) : sprintf('%s(%s)', gettype($queryAreaAvailabilityRequestStatisticsToQueryItem), var_export($queryAreaAvailabilityRequestStatisticsToQueryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanStatisticsType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatingPlanStatisticsType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatisticsToQuery value
     * @uses \patest\EnumType\SeatingPlanStatisticsType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanStatisticsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statisticsToQuery
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setStatisticsToQuery(array $statisticsToQuery = array())
    {
        // validation for constraint: list
        if ('' !== ($statisticsToQueryArrayErrorMessage = self::validateStatisticsToQueryForArrayConstraintsFromSetStatisticsToQuery($statisticsToQuery))) {
            throw new \InvalidArgumentException($statisticsToQueryArrayErrorMessage, __LINE__);
        }
        $this->StatisticsToQuery = is_array($statisticsToQuery) ? implode(' ', $statisticsToQuery) : null;
        return $this;
    }
    /**
     * Get OnlySeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getOnlySeatIds()
    {
        return isset($this->OnlySeatIds) ? $this->OnlySeatIds : null;
    }
    /**
     * Set OnlySeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $onlySeatIds
     * @return \patest\StructType\QueryAreaAvailabilityRequest
     */
    public function setOnlySeatIds(\patest\ArrayType\ArrayOfint $onlySeatIds = null)
    {
        if (is_null($onlySeatIds) || (is_array($onlySeatIds) && empty($onlySeatIds))) {
            unset($this->OnlySeatIds);
        } else {
            $this->OnlySeatIds = $onlySeatIds;
        }
        return $this;
    }
}
