<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PutTransactionOnHold-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PutTransactionOnHold-Request
 * @subpackage Structs
 */
class PutTransactionOnHold_Request extends ExtensibleDataContract
{
    /**
     * The IsTakenOverPerClientRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTakenOverPerClientRequest;
    /**
     * The TakenOverByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TakenOverByUserId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for PutTransactionOnHold-Request
     * @uses PutTransactionOnHold_Request::setIsTakenOverPerClientRequest()
     * @uses PutTransactionOnHold_Request::setTakenOverByUserId()
     * @uses PutTransactionOnHold_Request::setTransactionGuid()
     * @param bool $isTakenOverPerClientRequest
     * @param string $takenOverByUserId
     * @param string $transactionGuid
     */
    public function __construct($isTakenOverPerClientRequest = null, $takenOverByUserId = null, $transactionGuid = null)
    {
        $this
            ->setIsTakenOverPerClientRequest($isTakenOverPerClientRequest)
            ->setTakenOverByUserId($takenOverByUserId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get IsTakenOverPerClientRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTakenOverPerClientRequest()
    {
        return isset($this->IsTakenOverPerClientRequest) ? $this->IsTakenOverPerClientRequest : null;
    }
    /**
     * Set IsTakenOverPerClientRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTakenOverPerClientRequest
     * @return \patest\StructType\PutTransactionOnHold_Request
     */
    public function setIsTakenOverPerClientRequest($isTakenOverPerClientRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTakenOverPerClientRequest) && !is_bool($isTakenOverPerClientRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTakenOverPerClientRequest, true), gettype($isTakenOverPerClientRequest)), __LINE__);
        }
        if (is_null($isTakenOverPerClientRequest) || (is_array($isTakenOverPerClientRequest) && empty($isTakenOverPerClientRequest))) {
            unset($this->IsTakenOverPerClientRequest);
        } else {
            $this->IsTakenOverPerClientRequest = $isTakenOverPerClientRequest;
        }
        return $this;
    }
    /**
     * Get TakenOverByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTakenOverByUserId()
    {
        return isset($this->TakenOverByUserId) ? $this->TakenOverByUserId : null;
    }
    /**
     * Set TakenOverByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $takenOverByUserId
     * @return \patest\StructType\PutTransactionOnHold_Request
     */
    public function setTakenOverByUserId($takenOverByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($takenOverByUserId) && !is_string($takenOverByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($takenOverByUserId, true), gettype($takenOverByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($takenOverByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $takenOverByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($takenOverByUserId, true)), __LINE__);
        }
        if (is_null($takenOverByUserId) || (is_array($takenOverByUserId) && empty($takenOverByUserId))) {
            unset($this->TakenOverByUserId);
        } else {
            $this->TakenOverByUserId = $takenOverByUserId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\PutTransactionOnHold_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
