<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.SpoolGroupsAudit StructType
 * @subpackage Structs
 */
class Printing_SpoolGroupsAudit extends PersistableEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The BatchItemIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchItemIndex;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The GroupReferenceEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupReferenceEntityName;
    /**
     * The GroupReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupReferenceId;
    /**
     * The IsError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsError;
    /**
     * The ItemsAudit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit
     */
    public $ItemsAudit;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The ScenarioName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ScenarioName;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Printing.SpoolGroupsAudit
     * @uses Printing_SpoolGroupsAudit::setBatchId()
     * @uses Printing_SpoolGroupsAudit::setBatchItemIndex()
     * @uses Printing_SpoolGroupsAudit::setCode()
     * @uses Printing_SpoolGroupsAudit::setCreationDate()
     * @uses Printing_SpoolGroupsAudit::setDescription()
     * @uses Printing_SpoolGroupsAudit::setGroupId()
     * @uses Printing_SpoolGroupsAudit::setGroupReferenceEntityName()
     * @uses Printing_SpoolGroupsAudit::setGroupReferenceId()
     * @uses Printing_SpoolGroupsAudit::setIsError()
     * @uses Printing_SpoolGroupsAudit::setItemsAudit()
     * @uses Printing_SpoolGroupsAudit::setOrganizationUnitId()
     * @uses Printing_SpoolGroupsAudit::setSalePointId()
     * @uses Printing_SpoolGroupsAudit::setScenario()
     * @uses Printing_SpoolGroupsAudit::setScenarioName()
     * @uses Printing_SpoolGroupsAudit::setUserId()
     * @param string $batchId
     * @param int $batchItemIndex
     * @param string $code
     * @param string $creationDate
     * @param string $description
     * @param string $groupId
     * @param string $groupReferenceEntityName
     * @param string $groupReferenceId
     * @param bool $isError
     * @param \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit $itemsAudit
     * @param string $organizationUnitId
     * @param string $salePointId
     * @param string $scenario
     * @param \patest\StructType\GlobalString $scenarioName
     * @param string $userId
     */
    public function __construct($batchId = null, $batchItemIndex = null, $code = null, $creationDate = null, $description = null, $groupId = null, $groupReferenceEntityName = null, $groupReferenceId = null, $isError = null, \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit $itemsAudit = null, $organizationUnitId = null, $salePointId = null, $scenario = null, \patest\StructType\GlobalString $scenarioName = null, $userId = null)
    {
        $this
            ->setBatchId($batchId)
            ->setBatchItemIndex($batchItemIndex)
            ->setCode($code)
            ->setCreationDate($creationDate)
            ->setDescription($description)
            ->setGroupId($groupId)
            ->setGroupReferenceEntityName($groupReferenceEntityName)
            ->setGroupReferenceId($groupReferenceId)
            ->setIsError($isError)
            ->setItemsAudit($itemsAudit)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSalePointId($salePointId)
            ->setScenario($scenario)
            ->setScenarioName($scenarioName)
            ->setUserId($userId);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get BatchItemIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchItemIndex()
    {
        return isset($this->BatchItemIndex) ? $this->BatchItemIndex : null;
    }
    /**
     * Set BatchItemIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchItemIndex
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setBatchItemIndex($batchItemIndex = null)
    {
        // validation for constraint: int
        if (!is_null($batchItemIndex) && !(is_int($batchItemIndex) || ctype_digit($batchItemIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchItemIndex, true), gettype($batchItemIndex)), __LINE__);
        }
        if (is_null($batchItemIndex) || (is_array($batchItemIndex) && empty($batchItemIndex))) {
            unset($this->BatchItemIndex);
        } else {
            $this->BatchItemIndex = $batchItemIndex;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get GroupReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupReferenceEntityName()
    {
        return isset($this->GroupReferenceEntityName) ? $this->GroupReferenceEntityName : null;
    }
    /**
     * Set GroupReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupReferenceEntityName
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setGroupReferenceEntityName($groupReferenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($groupReferenceEntityName) && !is_string($groupReferenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupReferenceEntityName, true), gettype($groupReferenceEntityName)), __LINE__);
        }
        if (is_null($groupReferenceEntityName) || (is_array($groupReferenceEntityName) && empty($groupReferenceEntityName))) {
            unset($this->GroupReferenceEntityName);
        } else {
            $this->GroupReferenceEntityName = $groupReferenceEntityName;
        }
        return $this;
    }
    /**
     * Get GroupReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupReferenceId()
    {
        return isset($this->GroupReferenceId) ? $this->GroupReferenceId : null;
    }
    /**
     * Set GroupReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupReferenceId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setGroupReferenceId($groupReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($groupReferenceId) && !is_string($groupReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupReferenceId, true), gettype($groupReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupReferenceId, true)), __LINE__);
        }
        if (is_null($groupReferenceId) || (is_array($groupReferenceId) && empty($groupReferenceId))) {
            unset($this->GroupReferenceId);
        } else {
            $this->GroupReferenceId = $groupReferenceId;
        }
        return $this;
    }
    /**
     * Get IsError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsError()
    {
        return isset($this->IsError) ? $this->IsError : null;
    }
    /**
     * Set IsError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isError
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        if (is_null($isError) || (is_array($isError) && empty($isError))) {
            unset($this->IsError);
        } else {
            $this->IsError = $isError;
        }
        return $this;
    }
    /**
     * Get ItemsAudit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit|null
     */
    public function getItemsAudit()
    {
        return isset($this->ItemsAudit) ? $this->ItemsAudit : null;
    }
    /**
     * Set ItemsAudit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit $itemsAudit
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setItemsAudit(\patest\StructType\RecordSetOfPrinting_SpoolPrintableItemsAudit $itemsAudit = null)
    {
        if (is_null($itemsAudit) || (is_array($itemsAudit) && empty($itemsAudit))) {
            unset($this->ItemsAudit);
        } else {
            $this->ItemsAudit = $itemsAudit;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get ScenarioName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getScenarioName()
    {
        return isset($this->ScenarioName) ? $this->ScenarioName : null;
    }
    /**
     * Set ScenarioName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $scenarioName
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setScenarioName(\patest\StructType\GlobalString $scenarioName = null)
    {
        if (is_null($scenarioName) || (is_array($scenarioName) && empty($scenarioName))) {
            unset($this->ScenarioName);
        } else {
            $this->ScenarioName = $scenarioName;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_SpoolGroupsAudit
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
