<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintingMethod StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Printing.PrintingMethod
 * @subpackage Structs
 */
class Printing_PrintingMethod extends AnyEntity
{
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The PrintingMethodDataIsRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingMethodDataIsRequired;
    /**
     * The PrintingMethodDataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingMethodDataType;
    /**
     * The UseDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UseDescr;
    /**
     * Constructor method for Printing.PrintingMethod
     * @uses Printing_PrintingMethod::setDocumentType()
     * @uses Printing_PrintingMethod::setId()
     * @uses Printing_PrintingMethod::setName()
     * @uses Printing_PrintingMethod::setOrder()
     * @uses Printing_PrintingMethod::setPrintingMethodDataIsRequired()
     * @uses Printing_PrintingMethod::setPrintingMethodDataType()
     * @uses Printing_PrintingMethod::setUseDescr()
     * @param string $documentType
     * @param string $id
     * @param \patest\StructType\GlobalString $name
     * @param int $order
     * @param bool $printingMethodDataIsRequired
     * @param string $printingMethodDataType
     * @param \patest\StructType\GlobalString $useDescr
     */
    public function __construct($documentType = null, $id = null, \patest\StructType\GlobalString $name = null, $order = null, $printingMethodDataIsRequired = null, $printingMethodDataType = null, \patest\StructType\GlobalString $useDescr = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setId($id)
            ->setName($name)
            ->setOrder($order)
            ->setPrintingMethodDataIsRequired($printingMethodDataIsRequired)
            ->setPrintingMethodDataType($printingMethodDataType)
            ->setUseDescr($useDescr);
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentType
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get PrintingMethodDataIsRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingMethodDataIsRequired()
    {
        return isset($this->PrintingMethodDataIsRequired) ? $this->PrintingMethodDataIsRequired : null;
    }
    /**
     * Set PrintingMethodDataIsRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingMethodDataIsRequired
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setPrintingMethodDataIsRequired($printingMethodDataIsRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingMethodDataIsRequired) && !is_bool($printingMethodDataIsRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingMethodDataIsRequired, true), gettype($printingMethodDataIsRequired)), __LINE__);
        }
        if (is_null($printingMethodDataIsRequired) || (is_array($printingMethodDataIsRequired) && empty($printingMethodDataIsRequired))) {
            unset($this->PrintingMethodDataIsRequired);
        } else {
            $this->PrintingMethodDataIsRequired = $printingMethodDataIsRequired;
        }
        return $this;
    }
    /**
     * Get PrintingMethodDataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingMethodDataType()
    {
        return isset($this->PrintingMethodDataType) ? $this->PrintingMethodDataType : null;
    }
    /**
     * Set PrintingMethodDataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingMethodDataType
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setPrintingMethodDataType($printingMethodDataType = null)
    {
        // validation for constraint: string
        if (!is_null($printingMethodDataType) && !is_string($printingMethodDataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingMethodDataType, true), gettype($printingMethodDataType)), __LINE__);
        }
        if (is_null($printingMethodDataType) || (is_array($printingMethodDataType) && empty($printingMethodDataType))) {
            unset($this->PrintingMethodDataType);
        } else {
            $this->PrintingMethodDataType = $printingMethodDataType;
        }
        return $this;
    }
    /**
     * Get UseDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUseDescr()
    {
        return isset($this->UseDescr) ? $this->UseDescr : null;
    }
    /**
     * Set UseDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $useDescr
     * @return \patest\StructType\Printing_PrintingMethod
     */
    public function setUseDescr(\patest\StructType\GlobalString $useDescr = null)
    {
        if (is_null($useDescr) || (is_array($useDescr) && empty($useDescr))) {
            unset($this->UseDescr);
        } else {
            $this->UseDescr = $useDescr;
        }
        return $this;
    }
}
