<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Printing.PrinterServerExtended.Internal.NoOrgUnitBasedDataAccessSecurity
 * StructType
 * @subpackage Structs
 */
class Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity extends PersistableEntity
{
    /**
     * The AccessibleNotManagedPrinters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AccessiblePrinter
     */
    public $AccessibleNotManagedPrinters;
    /**
     * The AccessiblePrinters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AccessiblePrinter
     */
    public $AccessiblePrinters;
    /**
     * The AppServerNode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerNode;
    /**
     * The ConnectedComputerIP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerIP;
    /**
     * The ConnectedComputerMacAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerMacAddress;
    /**
     * The ConnectedComputerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerName;
    /**
     * The DeploymentError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeploymentError;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The LastActionTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActionTime;
    /**
     * The LastConnectTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastConnectTime;
    /**
     * The LastDeploymentAttemptTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDeploymentAttemptTime;
    /**
     * The LastDisconnectTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDisconnectTime;
    /**
     * The LastStatusChangeTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastStatusChangeTime;
    /**
     * The MarkedForRestart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MarkedForRestart;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrinterIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PrinterIds
     */
    public $PrinterIds;
    /**
     * The Printers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public $Printers;
    /**
     * The ServerRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerRunMode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusChangeExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusChangeExplanation;
    /**
     * The UpToDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpToDate;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for
     * Printing.PrinterServerExtended.Internal.NoOrgUnitBasedDataAccessSecurity
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setAccessibleNotManagedPrinters()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setAccessiblePrinters()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setAppServerNode()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setConnectedComputerIP()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setConnectedComputerMacAddress()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setConnectedComputerName()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setDeploymentError()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setDescription()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setIsActive()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setIsInternal()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setLastActionTime()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setLastConnectTime()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setLastDeploymentAttemptTime()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setLastDisconnectTime()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setLastStatusChangeTime()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setMarkedForRestart()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setName()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setOrganizationUnitId()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setPrinterIds()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setPrinters()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setServerRunMode()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setStatus()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setStatusChangeExplanation()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setUpToDate()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setVisibleBySubordinates()
     * @uses Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity::setXmlContainer()
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters
     * @param string $appServerNode
     * @param string $connectedComputerIP
     * @param string $connectedComputerMacAddress
     * @param string $connectedComputerName
     * @param string $deploymentError
     * @param \patest\StructType\GlobalString $description
     * @param bool $isActive
     * @param bool $isInternal
     * @param string $lastActionTime
     * @param string $lastConnectTime
     * @param string $lastDeploymentAttemptTime
     * @param string $lastDisconnectTime
     * @param string $lastStatusChangeTime
     * @param bool $markedForRestart
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\PrinterIds $printerIds
     * @param \patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity $printers
     * @param string $serverRunMode
     * @param string $status
     * @param string $statusChangeExplanation
     * @param bool $upToDate
     * @param bool $visibleBySubordinates
     * @param string $xmlContainer
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters = null, \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters = null, $appServerNode = null, $connectedComputerIP = null, $connectedComputerMacAddress = null, $connectedComputerName = null, $deploymentError = null, \patest\StructType\GlobalString $description = null, $isActive = null, $isInternal = null, $lastActionTime = null, $lastConnectTime = null, $lastDeploymentAttemptTime = null, $lastDisconnectTime = null, $lastStatusChangeTime = null, $markedForRestart = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\PrinterIds $printerIds = null, \patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity $printers = null, $serverRunMode = null, $status = null, $statusChangeExplanation = null, $upToDate = null, $visibleBySubordinates = null, $xmlContainer = null)
    {
        $this
            ->setAccessibleNotManagedPrinters($accessibleNotManagedPrinters)
            ->setAccessiblePrinters($accessiblePrinters)
            ->setAppServerNode($appServerNode)
            ->setConnectedComputerIP($connectedComputerIP)
            ->setConnectedComputerMacAddress($connectedComputerMacAddress)
            ->setConnectedComputerName($connectedComputerName)
            ->setDeploymentError($deploymentError)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsInternal($isInternal)
            ->setLastActionTime($lastActionTime)
            ->setLastConnectTime($lastConnectTime)
            ->setLastDeploymentAttemptTime($lastDeploymentAttemptTime)
            ->setLastDisconnectTime($lastDisconnectTime)
            ->setLastStatusChangeTime($lastStatusChangeTime)
            ->setMarkedForRestart($markedForRestart)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrinterIds($printerIds)
            ->setPrinters($printers)
            ->setServerRunMode($serverRunMode)
            ->setStatus($status)
            ->setStatusChangeExplanation($statusChangeExplanation)
            ->setUpToDate($upToDate)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessibleNotManagedPrinters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AccessiblePrinter|null
     */
    public function getAccessibleNotManagedPrinters()
    {
        return isset($this->AccessibleNotManagedPrinters) ? $this->AccessibleNotManagedPrinters : null;
    }
    /**
     * Set AccessibleNotManagedPrinters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setAccessibleNotManagedPrinters(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters = null)
    {
        if (is_null($accessibleNotManagedPrinters) || (is_array($accessibleNotManagedPrinters) && empty($accessibleNotManagedPrinters))) {
            unset($this->AccessibleNotManagedPrinters);
        } else {
            $this->AccessibleNotManagedPrinters = $accessibleNotManagedPrinters;
        }
        return $this;
    }
    /**
     * Get AccessiblePrinters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AccessiblePrinter|null
     */
    public function getAccessiblePrinters()
    {
        return isset($this->AccessiblePrinters) ? $this->AccessiblePrinters : null;
    }
    /**
     * Set AccessiblePrinters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setAccessiblePrinters(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters = null)
    {
        if (is_null($accessiblePrinters) || (is_array($accessiblePrinters) && empty($accessiblePrinters))) {
            unset($this->AccessiblePrinters);
        } else {
            $this->AccessiblePrinters = $accessiblePrinters;
        }
        return $this;
    }
    /**
     * Get AppServerNode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerNode()
    {
        return isset($this->AppServerNode) ? $this->AppServerNode : null;
    }
    /**
     * Set AppServerNode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerNode
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setAppServerNode($appServerNode = null)
    {
        // validation for constraint: string
        if (!is_null($appServerNode) && !is_string($appServerNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerNode, true), gettype($appServerNode)), __LINE__);
        }
        if (is_null($appServerNode) || (is_array($appServerNode) && empty($appServerNode))) {
            unset($this->AppServerNode);
        } else {
            $this->AppServerNode = $appServerNode;
        }
        return $this;
    }
    /**
     * Get ConnectedComputerIP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerIP()
    {
        return isset($this->ConnectedComputerIP) ? $this->ConnectedComputerIP : null;
    }
    /**
     * Set ConnectedComputerIP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerIP
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setConnectedComputerIP($connectedComputerIP = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerIP) && !is_string($connectedComputerIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerIP, true), gettype($connectedComputerIP)), __LINE__);
        }
        if (is_null($connectedComputerIP) || (is_array($connectedComputerIP) && empty($connectedComputerIP))) {
            unset($this->ConnectedComputerIP);
        } else {
            $this->ConnectedComputerIP = $connectedComputerIP;
        }
        return $this;
    }
    /**
     * Get ConnectedComputerMacAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerMacAddress()
    {
        return isset($this->ConnectedComputerMacAddress) ? $this->ConnectedComputerMacAddress : null;
    }
    /**
     * Set ConnectedComputerMacAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerMacAddress
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setConnectedComputerMacAddress($connectedComputerMacAddress = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerMacAddress) && !is_string($connectedComputerMacAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerMacAddress, true), gettype($connectedComputerMacAddress)), __LINE__);
        }
        if (is_null($connectedComputerMacAddress) || (is_array($connectedComputerMacAddress) && empty($connectedComputerMacAddress))) {
            unset($this->ConnectedComputerMacAddress);
        } else {
            $this->ConnectedComputerMacAddress = $connectedComputerMacAddress;
        }
        return $this;
    }
    /**
     * Get ConnectedComputerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerName()
    {
        return isset($this->ConnectedComputerName) ? $this->ConnectedComputerName : null;
    }
    /**
     * Set ConnectedComputerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerName
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setConnectedComputerName($connectedComputerName = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerName) && !is_string($connectedComputerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerName, true), gettype($connectedComputerName)), __LINE__);
        }
        if (is_null($connectedComputerName) || (is_array($connectedComputerName) && empty($connectedComputerName))) {
            unset($this->ConnectedComputerName);
        } else {
            $this->ConnectedComputerName = $connectedComputerName;
        }
        return $this;
    }
    /**
     * Get DeploymentError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeploymentError()
    {
        return isset($this->DeploymentError) ? $this->DeploymentError : null;
    }
    /**
     * Set DeploymentError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deploymentError
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setDeploymentError($deploymentError = null)
    {
        // validation for constraint: string
        if (!is_null($deploymentError) && !is_string($deploymentError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deploymentError, true), gettype($deploymentError)), __LINE__);
        }
        if (is_null($deploymentError) || (is_array($deploymentError) && empty($deploymentError))) {
            unset($this->DeploymentError);
        } else {
            $this->DeploymentError = $deploymentError;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get LastActionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActionTime()
    {
        return isset($this->LastActionTime) ? $this->LastActionTime : null;
    }
    /**
     * Set LastActionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActionTime
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setLastActionTime($lastActionTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionTime) && !is_string($lastActionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActionTime, true), gettype($lastActionTime)), __LINE__);
        }
        if (is_null($lastActionTime) || (is_array($lastActionTime) && empty($lastActionTime))) {
            unset($this->LastActionTime);
        } else {
            $this->LastActionTime = $lastActionTime;
        }
        return $this;
    }
    /**
     * Get LastConnectTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastConnectTime()
    {
        return isset($this->LastConnectTime) ? $this->LastConnectTime : null;
    }
    /**
     * Set LastConnectTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastConnectTime
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setLastConnectTime($lastConnectTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastConnectTime) && !is_string($lastConnectTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastConnectTime, true), gettype($lastConnectTime)), __LINE__);
        }
        if (is_null($lastConnectTime) || (is_array($lastConnectTime) && empty($lastConnectTime))) {
            unset($this->LastConnectTime);
        } else {
            $this->LastConnectTime = $lastConnectTime;
        }
        return $this;
    }
    /**
     * Get LastDeploymentAttemptTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDeploymentAttemptTime()
    {
        return isset($this->LastDeploymentAttemptTime) ? $this->LastDeploymentAttemptTime : null;
    }
    /**
     * Set LastDeploymentAttemptTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDeploymentAttemptTime
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setLastDeploymentAttemptTime($lastDeploymentAttemptTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDeploymentAttemptTime) && !is_string($lastDeploymentAttemptTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDeploymentAttemptTime, true), gettype($lastDeploymentAttemptTime)), __LINE__);
        }
        if (is_null($lastDeploymentAttemptTime) || (is_array($lastDeploymentAttemptTime) && empty($lastDeploymentAttemptTime))) {
            unset($this->LastDeploymentAttemptTime);
        } else {
            $this->LastDeploymentAttemptTime = $lastDeploymentAttemptTime;
        }
        return $this;
    }
    /**
     * Get LastDisconnectTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDisconnectTime()
    {
        return isset($this->LastDisconnectTime) ? $this->LastDisconnectTime : null;
    }
    /**
     * Set LastDisconnectTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDisconnectTime
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setLastDisconnectTime($lastDisconnectTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDisconnectTime) && !is_string($lastDisconnectTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDisconnectTime, true), gettype($lastDisconnectTime)), __LINE__);
        }
        if (is_null($lastDisconnectTime) || (is_array($lastDisconnectTime) && empty($lastDisconnectTime))) {
            unset($this->LastDisconnectTime);
        } else {
            $this->LastDisconnectTime = $lastDisconnectTime;
        }
        return $this;
    }
    /**
     * Get LastStatusChangeTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastStatusChangeTime()
    {
        return isset($this->LastStatusChangeTime) ? $this->LastStatusChangeTime : null;
    }
    /**
     * Set LastStatusChangeTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastStatusChangeTime
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setLastStatusChangeTime($lastStatusChangeTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastStatusChangeTime) && !is_string($lastStatusChangeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastStatusChangeTime, true), gettype($lastStatusChangeTime)), __LINE__);
        }
        if (is_null($lastStatusChangeTime) || (is_array($lastStatusChangeTime) && empty($lastStatusChangeTime))) {
            unset($this->LastStatusChangeTime);
        } else {
            $this->LastStatusChangeTime = $lastStatusChangeTime;
        }
        return $this;
    }
    /**
     * Get MarkedForRestart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMarkedForRestart()
    {
        return isset($this->MarkedForRestart) ? $this->MarkedForRestart : null;
    }
    /**
     * Set MarkedForRestart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $markedForRestart
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setMarkedForRestart($markedForRestart = null)
    {
        // validation for constraint: boolean
        if (!is_null($markedForRestart) && !is_bool($markedForRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markedForRestart, true), gettype($markedForRestart)), __LINE__);
        }
        if (is_null($markedForRestart) || (is_array($markedForRestart) && empty($markedForRestart))) {
            unset($this->MarkedForRestart);
        } else {
            $this->MarkedForRestart = $markedForRestart;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrinterIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PrinterIds|null
     */
    public function getPrinterIds()
    {
        return isset($this->PrinterIds) ? $this->PrinterIds : null;
    }
    /**
     * Set PrinterIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PrinterIds $printerIds
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setPrinterIds(\patest\StructType\PrinterIds $printerIds = null)
    {
        if (is_null($printerIds) || (is_array($printerIds) && empty($printerIds))) {
            unset($this->PrinterIds);
        } else {
            $this->PrinterIds = $printerIds;
        }
        return $this;
    }
    /**
     * Get Printers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity|null
     */
    public function getPrinters()
    {
        return isset($this->Printers) ? $this->Printers : null;
    }
    /**
     * Set Printers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity $printers
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setPrinters(\patest\StructType\RecordSetOfPrinting_Printer_Internal_NoOrgUnitBasedDataAccessSecurity $printers = null)
    {
        if (is_null($printers) || (is_array($printers) && empty($printers))) {
            unset($this->Printers);
        } else {
            $this->Printers = $printers;
        }
        return $this;
    }
    /**
     * Get ServerRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerRunMode()
    {
        return isset($this->ServerRunMode) ? $this->ServerRunMode : null;
    }
    /**
     * Set ServerRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServerRunMode::valueIsValid()
     * @uses \patest\EnumType\ServerRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serverRunMode
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setServerRunMode($serverRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServerRunMode::valueIsValid($serverRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServerRunMode', is_array($serverRunMode) ? implode(', ', $serverRunMode) : var_export($serverRunMode, true), implode(', ', \patest\EnumType\ServerRunMode::getValidValues())), __LINE__);
        }
        if (is_null($serverRunMode) || (is_array($serverRunMode) && empty($serverRunMode))) {
            unset($this->ServerRunMode);
        } else {
            $this->ServerRunMode = $serverRunMode;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkingStatus::valueIsValid()
     * @uses \patest\EnumType\WorkingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkingStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkingStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\WorkingStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusChangeExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusChangeExplanation()
    {
        return isset($this->StatusChangeExplanation) ? $this->StatusChangeExplanation : null;
    }
    /**
     * Set StatusChangeExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusChangeExplanation
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setStatusChangeExplanation($statusChangeExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($statusChangeExplanation) && !is_string($statusChangeExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusChangeExplanation, true), gettype($statusChangeExplanation)), __LINE__);
        }
        if (is_null($statusChangeExplanation) || (is_array($statusChangeExplanation) && empty($statusChangeExplanation))) {
            unset($this->StatusChangeExplanation);
        } else {
            $this->StatusChangeExplanation = $statusChangeExplanation;
        }
        return $this;
    }
    /**
     * Get UpToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpToDate()
    {
        return isset($this->UpToDate) ? $this->UpToDate : null;
    }
    /**
     * Set UpToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $upToDate
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setUpToDate($upToDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($upToDate) && !is_bool($upToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upToDate, true), gettype($upToDate)), __LINE__);
        }
        if (is_null($upToDate) || (is_array($upToDate) && empty($upToDate))) {
            unset($this->UpToDate);
        } else {
            $this->UpToDate = $upToDate;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\Printing_PrinterServerExtended_Internal_NoOrgUnitBasedDataAccessSecurity
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
