<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.VisitPrice StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_VisitPrice extends AnyEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Discount;
    /**
     * The Participants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Participants;
    /**
     * The PricePerPerson
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerPerson;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_PriceType
     */
    public $PriceType;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for Printing.PrintableItem.VisitPrice
     * @uses Printing_PrintableItem_VisitPrice::setAmount()
     * @uses Printing_PrintableItem_VisitPrice::setDiscount()
     * @uses Printing_PrintableItem_VisitPrice::setParticipants()
     * @uses Printing_PrintableItem_VisitPrice::setPricePerPerson()
     * @uses Printing_PrintableItem_VisitPrice::setPriceType()
     * @uses Printing_PrintableItem_VisitPrice::setTotalAmount()
     * @param float $amount
     * @param string $discount
     * @param int $participants
     * @param float $pricePerPerson
     * @param \patest\StructType\Printing_PrintableItem_PriceType $priceType
     * @param float $totalAmount
     */
    public function __construct($amount = null, $discount = null, $participants = null, $pricePerPerson = null, \patest\StructType\Printing_PrintableItem_PriceType $priceType = null, $totalAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setDiscount($discount)
            ->setParticipants($participants)
            ->setPricePerPerson($pricePerPerson)
            ->setPriceType($priceType)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discount
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Get Participants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParticipants()
    {
        return isset($this->Participants) ? $this->Participants : null;
    }
    /**
     * Set Participants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $participants
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setParticipants($participants = null)
    {
        // validation for constraint: int
        if (!is_null($participants) && !(is_int($participants) || ctype_digit($participants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($participants, true), gettype($participants)), __LINE__);
        }
        if (is_null($participants) || (is_array($participants) && empty($participants))) {
            unset($this->Participants);
        } else {
            $this->Participants = $participants;
        }
        return $this;
    }
    /**
     * Get PricePerPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerPerson()
    {
        return isset($this->PricePerPerson) ? $this->PricePerPerson : null;
    }
    /**
     * Set PricePerPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerPerson
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setPricePerPerson($pricePerPerson = null)
    {
        // validation for constraint: float
        if (!is_null($pricePerPerson) && !(is_float($pricePerPerson) || is_numeric($pricePerPerson))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePerPerson, true), gettype($pricePerPerson)), __LINE__);
        }
        if (is_null($pricePerPerson) || (is_array($pricePerPerson) && empty($pricePerPerson))) {
            unset($this->PricePerPerson);
        } else {
            $this->PricePerPerson = $pricePerPerson;
        }
        return $this;
    }
    /**
     * Get PriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_PriceType|null
     */
    public function getPriceType()
    {
        return isset($this->PriceType) ? $this->PriceType : null;
    }
    /**
     * Set PriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_PriceType $priceType
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setPriceType(\patest\StructType\Printing_PrintableItem_PriceType $priceType = null)
    {
        if (is_null($priceType) || (is_array($priceType) && empty($priceType))) {
            unset($this->PriceType);
        } else {
            $this->PriceType = $priceType;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_VisitPrice
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
}
