<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.TicketInGroupTicket StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_TicketInGroupTicket extends Printing_PrintableItem_Base
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlParentDefinitionDataReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlParentDefinitionDataReferenceId;
    /**
     * The AccessControlProductExtensionReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlProductExtensionReferenceId;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Area
     */
    public $Area;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ExtraFieldsData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_Sales_ExtraFieldsData
     */
    public $ExtraFieldsData;
    /**
     * The Gates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Printing_Gate
     */
    public $Gates;
    /**
     * The GatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatesSummary;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance
     */
    public $Insurance;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmation;
    /**
     * The IsNewAccessCard
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNewAccessCard;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReservation;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Owner
     */
    public $Owner;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_PriceLevel
     */
    public $PriceLevel;
    /**
     * The PriceLevelDisplayStyle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelDisplayStyle;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier
     */
    public $PriceModifiers;
    /**
     * The PriceTypeComplex
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_PriceType
     */
    public $PriceTypeComplex;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceTypeName;
    /**
     * The PriceType_PrintDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_PrintDescription;
    /**
     * The PriceType_ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_ShortDescription;
    /**
     * The PrintedAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedAs;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Seat
     */
    public $Seat;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The Stand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Stand
     */
    public $Stand;
    /**
     * The SubsidizedByAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsidizedByAccountName;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_ItemTotals
     */
    public $Totals;
    /**
     * The Turnstiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Printing_Turnstile
     */
    public $Turnstiles;
    /**
     * The TurnstilesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesSummary;
    /**
     * Constructor method for Printing.PrintableItem.TicketInGroupTicket
     * @uses Printing_PrintableItem_TicketInGroupTicket::setAccessCardId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setAccessControlParentDefinitionDataReferenceId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setAccessControlProductExtensionReferenceId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setArea()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setAreaId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setClientId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setExtraFieldsData()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setGates()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setGatesSummary()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setInsurance()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setIsComplimentary()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setIsConfirmation()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setIsNewAccessCard()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setIsReservation()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setIsReturned()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setItemId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setItemType()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setLocalId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setOrganizationUnitId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setOwner()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPaymentMethodName()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceLevel()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceLevelDisplayStyle()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceLevelName()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceModifiers()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceTypeComplex()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceTypeId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceTypeName()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceType_PrintDescription()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPriceType_ShortDescription()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setPrintedAs()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setReservationExpiryDate()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setSeat()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setSeatIdInAreaMap()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setSeatingPlanId()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setStand()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setSubsidizedByAccountName()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setTicketNumber()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setTotals()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setTurnstiles()
     * @uses Printing_PrintableItem_TicketInGroupTicket::setTurnstilesSummary()
     * @param string $accessCardId
     * @param string $accessControlParentDefinitionDataReferenceId
     * @param string $accessControlProductExtensionReferenceId
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @param string $areaId
     * @param string $clientId
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates
     * @param string $gatesSummary
     * @param \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance
     * @param bool $isComplimentary
     * @param bool $isConfirmation
     * @param bool $isNewAccessCard
     * @param bool $isReservation
     * @param bool $isReturned
     * @param int $itemId
     * @param int $itemType
     * @param int $localId
     * @param string $organizationUnitId
     * @param \patest\StructType\Printing_AuxDataItem_Owner $owner
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @param string $priceLevelDisplayStyle
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $priceTypeName
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @param string $printedAs
     * @param string $reservationExpiryDate
     * @param \patest\StructType\Ticketing_Printing_Seat $seat
     * @param int $seatIdInAreaMap
     * @param string $seatingPlanId
     * @param \patest\StructType\Ticketing_Printing_Stand $stand
     * @param string $subsidizedByAccountName
     * @param int $ticketNumber
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles
     * @param string $turnstilesSummary
     */
    public function __construct($accessCardId = null, $accessControlParentDefinitionDataReferenceId = null, $accessControlProductExtensionReferenceId = null, \patest\StructType\Ticketing_Printing_Area $area = null, $areaId = null, $clientId = null, \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null, \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates = null, $gatesSummary = null, \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance = null, $isComplimentary = null, $isConfirmation = null, $isNewAccessCard = null, $isReservation = null, $isReturned = null, $itemId = null, $itemType = null, $localId = null, $organizationUnitId = null, \patest\StructType\Printing_AuxDataItem_Owner $owner = null, \patest\StructType\GlobalString $paymentMethodName = null, \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null, $priceLevelDisplayStyle = null, \patest\StructType\GlobalString $priceLevelName = null, \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers = null, \patest\StructType\Sales_PriceType $priceTypeComplex = null, $priceTypeId = null, \patest\StructType\GlobalString $priceTypeName = null, \patest\StructType\GlobalString $priceType_PrintDescription = null, \patest\StructType\GlobalString $priceType_ShortDescription = null, $printedAs = null, $reservationExpiryDate = null, \patest\StructType\Ticketing_Printing_Seat $seat = null, $seatIdInAreaMap = null, $seatingPlanId = null, \patest\StructType\Ticketing_Printing_Stand $stand = null, $subsidizedByAccountName = null, $ticketNumber = null, \patest\StructType\Sales_Printing_ItemTotals $totals = null, \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles = null, $turnstilesSummary = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId)
            ->setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId)
            ->setArea($area)
            ->setAreaId($areaId)
            ->setClientId($clientId)
            ->setExtraFieldsData($extraFieldsData)
            ->setGates($gates)
            ->setGatesSummary($gatesSummary)
            ->setInsurance($insurance)
            ->setIsComplimentary($isComplimentary)
            ->setIsConfirmation($isConfirmation)
            ->setIsNewAccessCard($isNewAccessCard)
            ->setIsReservation($isReservation)
            ->setIsReturned($isReturned)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setLocalId($localId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOwner($owner)
            ->setPaymentMethodName($paymentMethodName)
            ->setPriceLevel($priceLevel)
            ->setPriceLevelDisplayStyle($priceLevelDisplayStyle)
            ->setPriceLevelName($priceLevelName)
            ->setPriceModifiers($priceModifiers)
            ->setPriceTypeComplex($priceTypeComplex)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setPriceType_PrintDescription($priceType_PrintDescription)
            ->setPriceType_ShortDescription($priceType_ShortDescription)
            ->setPrintedAs($printedAs)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setSeat($seat)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatingPlanId($seatingPlanId)
            ->setStand($stand)
            ->setSubsidizedByAccountName($subsidizedByAccountName)
            ->setTicketNumber($ticketNumber)
            ->setTotals($totals)
            ->setTurnstiles($turnstiles)
            ->setTurnstilesSummary($turnstilesSummary);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlParentDefinitionDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlParentDefinitionDataReferenceId()
    {
        return isset($this->AccessControlParentDefinitionDataReferenceId) ? $this->AccessControlParentDefinitionDataReferenceId : null;
    }
    /**
     * Set AccessControlParentDefinitionDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlParentDefinitionDataReferenceId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !is_string($accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlParentDefinitionDataReferenceId, true), gettype($accessControlParentDefinitionDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlParentDefinitionDataReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlParentDefinitionDataReferenceId) || (is_array($accessControlParentDefinitionDataReferenceId) && empty($accessControlParentDefinitionDataReferenceId))) {
            unset($this->AccessControlParentDefinitionDataReferenceId);
        } else {
            $this->AccessControlParentDefinitionDataReferenceId = $accessControlParentDefinitionDataReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlProductExtensionReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProductExtensionReferenceId()
    {
        return isset($this->AccessControlProductExtensionReferenceId) ? $this->AccessControlProductExtensionReferenceId : null;
    }
    /**
     * Set AccessControlProductExtensionReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProductExtensionReferenceId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProductExtensionReferenceId) && !is_string($accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProductExtensionReferenceId, true), gettype($accessControlProductExtensionReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlProductExtensionReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlProductExtensionReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlProductExtensionReferenceId) || (is_array($accessControlProductExtensionReferenceId) && empty($accessControlProductExtensionReferenceId))) {
            unset($this->AccessControlProductExtensionReferenceId);
        } else {
            $this->AccessControlProductExtensionReferenceId = $accessControlProductExtensionReferenceId;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Area|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setArea(\patest\StructType\Ticketing_Printing_Area $area = null)
    {
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ExtraFieldsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_Sales_ExtraFieldsData|null
     */
    public function getExtraFieldsData()
    {
        return isset($this->ExtraFieldsData) ? $this->ExtraFieldsData : null;
    }
    /**
     * Set ExtraFieldsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setExtraFieldsData(\patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null)
    {
        if (is_null($extraFieldsData) || (is_array($extraFieldsData) && empty($extraFieldsData))) {
            unset($this->ExtraFieldsData);
        } else {
            $this->ExtraFieldsData = $extraFieldsData;
        }
        return $this;
    }
    /**
     * Get Gates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Printing_Gate|null
     */
    public function getGates()
    {
        return isset($this->Gates) ? $this->Gates : null;
    }
    /**
     * Set Gates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setGates(\patest\StructType\RecordSetOfTicketing_Printing_Gate $gates = null)
    {
        if (is_null($gates) || (is_array($gates) && empty($gates))) {
            unset($this->Gates);
        } else {
            $this->Gates = $gates;
        }
        return $this;
    }
    /**
     * Get GatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatesSummary()
    {
        return isset($this->GatesSummary) ? $this->GatesSummary : null;
    }
    /**
     * Set GatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatesSummary
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setGatesSummary($gatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($gatesSummary) && !is_string($gatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatesSummary, true), gettype($gatesSummary)), __LINE__);
        }
        if (is_null($gatesSummary) || (is_array($gatesSummary) && empty($gatesSummary))) {
            unset($this->GatesSummary);
        } else {
            $this->GatesSummary = $gatesSummary;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setInsurance(\patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsConfirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmation()
    {
        return isset($this->IsConfirmation) ? $this->IsConfirmation : null;
    }
    /**
     * Set IsConfirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmation
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setIsConfirmation($isConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmation) && !is_bool($isConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmation, true), gettype($isConfirmation)), __LINE__);
        }
        if (is_null($isConfirmation) || (is_array($isConfirmation) && empty($isConfirmation))) {
            unset($this->IsConfirmation);
        } else {
            $this->IsConfirmation = $isConfirmation;
        }
        return $this;
    }
    /**
     * Get IsNewAccessCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNewAccessCard()
    {
        return isset($this->IsNewAccessCard) ? $this->IsNewAccessCard : null;
    }
    /**
     * Set IsNewAccessCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNewAccessCard
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setIsNewAccessCard($isNewAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewAccessCard) && !is_bool($isNewAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewAccessCard, true), gettype($isNewAccessCard)), __LINE__);
        }
        if (is_null($isNewAccessCard) || (is_array($isNewAccessCard) && empty($isNewAccessCard))) {
            unset($this->IsNewAccessCard);
        } else {
            $this->IsNewAccessCard = $isNewAccessCard;
        }
        return $this;
    }
    /**
     * Get IsReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReservation()
    {
        return isset($this->IsReservation) ? $this->IsReservation : null;
    }
    /**
     * Set IsReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReservation
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        if (is_null($isReservation) || (is_array($isReservation) && empty($isReservation))) {
            unset($this->IsReservation);
        } else {
            $this->IsReservation = $isReservation;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Owner|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Owner $owner
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setOwner(\patest\StructType\Printing_AuxDataItem_Owner $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_PriceLevel|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceLevel(\patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null)
    {
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get PriceLevelDisplayStyle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelDisplayStyle()
    {
        return isset($this->PriceLevelDisplayStyle) ? $this->PriceLevelDisplayStyle : null;
    }
    /**
     * Set PriceLevelDisplayStyle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelDisplayStyle
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceLevelDisplayStyle($priceLevelDisplayStyle = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelDisplayStyle) && !is_string($priceLevelDisplayStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelDisplayStyle, true), gettype($priceLevelDisplayStyle)), __LINE__);
        }
        if (is_null($priceLevelDisplayStyle) || (is_array($priceLevelDisplayStyle) && empty($priceLevelDisplayStyle))) {
            unset($this->PriceLevelDisplayStyle);
        } else {
            $this->PriceLevelDisplayStyle = $priceLevelDisplayStyle;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get PriceTypeComplex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_PriceType|null
     */
    public function getPriceTypeComplex()
    {
        return isset($this->PriceTypeComplex) ? $this->PriceTypeComplex : null;
    }
    /**
     * Set PriceTypeComplex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceTypeComplex(\patest\StructType\Sales_PriceType $priceTypeComplex = null)
    {
        if (is_null($priceTypeComplex) || (is_array($priceTypeComplex) && empty($priceTypeComplex))) {
            unset($this->PriceTypeComplex);
        } else {
            $this->PriceTypeComplex = $priceTypeComplex;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceTypeName
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceTypeName(\patest\StructType\GlobalString $priceTypeName = null)
    {
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get PriceType_PrintDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_PrintDescription()
    {
        return isset($this->PriceType_PrintDescription) ? $this->PriceType_PrintDescription : null;
    }
    /**
     * Set PriceType_PrintDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceType_PrintDescription(\patest\StructType\GlobalString $priceType_PrintDescription = null)
    {
        if (is_null($priceType_PrintDescription) || (is_array($priceType_PrintDescription) && empty($priceType_PrintDescription))) {
            unset($this->PriceType_PrintDescription);
        } else {
            $this->PriceType_PrintDescription = $priceType_PrintDescription;
        }
        return $this;
    }
    /**
     * Get PriceType_ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_ShortDescription()
    {
        return isset($this->PriceType_ShortDescription) ? $this->PriceType_ShortDescription : null;
    }
    /**
     * Set PriceType_ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPriceType_ShortDescription(\patest\StructType\GlobalString $priceType_ShortDescription = null)
    {
        if (is_null($priceType_ShortDescription) || (is_array($priceType_ShortDescription) && empty($priceType_ShortDescription))) {
            unset($this->PriceType_ShortDescription);
        } else {
            $this->PriceType_ShortDescription = $priceType_ShortDescription;
        }
        return $this;
    }
    /**
     * Get PrintedAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedAs()
    {
        return isset($this->PrintedAs) ? $this->PrintedAs : null;
    }
    /**
     * Set PrintedAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedAs
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setPrintedAs($printedAs = null)
    {
        // validation for constraint: string
        if (!is_null($printedAs) && !is_string($printedAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedAs, true), gettype($printedAs)), __LINE__);
        }
        if (is_null($printedAs) || (is_array($printedAs) && empty($printedAs))) {
            unset($this->PrintedAs);
        } else {
            $this->PrintedAs = $printedAs;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Seat|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Seat $seat
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setSeat(\patest\StructType\Ticketing_Printing_Seat $seat = null)
    {
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get Stand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Stand|null
     */
    public function getStand()
    {
        return isset($this->Stand) ? $this->Stand : null;
    }
    /**
     * Set Stand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Stand $stand
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setStand(\patest\StructType\Ticketing_Printing_Stand $stand = null)
    {
        if (is_null($stand) || (is_array($stand) && empty($stand))) {
            unset($this->Stand);
        } else {
            $this->Stand = $stand;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountName()
    {
        return isset($this->SubsidizedByAccountName) ? $this->SubsidizedByAccountName : null;
    }
    /**
     * Set SubsidizedByAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountName
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setSubsidizedByAccountName($subsidizedByAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountName) && !is_string($subsidizedByAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountName, true), gettype($subsidizedByAccountName)), __LINE__);
        }
        if (is_null($subsidizedByAccountName) || (is_array($subsidizedByAccountName) && empty($subsidizedByAccountName))) {
            unset($this->SubsidizedByAccountName);
        } else {
            $this->SubsidizedByAccountName = $subsidizedByAccountName;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_ItemTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setTotals(\patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get Turnstiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Printing_Turnstile|null
     */
    public function getTurnstiles()
    {
        return isset($this->Turnstiles) ? $this->Turnstiles : null;
    }
    /**
     * Set Turnstiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setTurnstiles(\patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles = null)
    {
        if (is_null($turnstiles) || (is_array($turnstiles) && empty($turnstiles))) {
            unset($this->Turnstiles);
        } else {
            $this->Turnstiles = $turnstiles;
        }
        return $this;
    }
    /**
     * Get TurnstilesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesSummary()
    {
        return isset($this->TurnstilesSummary) ? $this->TurnstilesSummary : null;
    }
    /**
     * Set TurnstilesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstilesSummary
     * @return \patest\StructType\Printing_PrintableItem_TicketInGroupTicket
     */
    public function setTurnstilesSummary($turnstilesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($turnstilesSummary) && !is_string($turnstilesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstilesSummary, true), gettype($turnstilesSummary)), __LINE__);
        }
        if (is_null($turnstilesSummary) || (is_array($turnstilesSummary) && empty($turnstilesSummary))) {
            unset($this->TurnstilesSummary);
        } else {
            $this->TurnstilesSummary = $turnstilesSummary;
        }
        return $this;
    }
}
