<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.SummaryItem StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_SummaryItem extends AnyEntity
{
    /**
     * The BillFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillFor;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The IsValidForBilling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValidForBilling;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneAccount
     */
    public $Payer;
    /**
     * The PayerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerName;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for Printing.PrintableItem.SummaryItem
     * @uses Printing_PrintableItem_SummaryItem::setBillFor()
     * @uses Printing_PrintableItem_SummaryItem::setIsReturned()
     * @uses Printing_PrintableItem_SummaryItem::setIsValidForBilling()
     * @uses Printing_PrintableItem_SummaryItem::setPayer()
     * @uses Printing_PrintableItem_SummaryItem::setPayerName()
     * @uses Printing_PrintableItem_SummaryItem::setTotalAmount()
     * @param string $billFor
     * @param bool $isReturned
     * @param bool $isValidForBilling
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @param string $payerName
     * @param float $totalAmount
     */
    public function __construct($billFor = null, $isReturned = null, $isValidForBilling = null, \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null, $payerName = null, $totalAmount = null)
    {
        $this
            ->setBillFor($billFor)
            ->setIsReturned($isReturned)
            ->setIsValidForBilling($isValidForBilling)
            ->setPayer($payer)
            ->setPayerName($payerName)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get BillFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillFor()
    {
        return isset($this->BillFor) ? $this->BillFor : null;
    }
    /**
     * Set BillFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billFor
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setBillFor($billFor = null)
    {
        // validation for constraint: string
        if (!is_null($billFor) && !is_string($billFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billFor, true), gettype($billFor)), __LINE__);
        }
        if (is_null($billFor) || (is_array($billFor) && empty($billFor))) {
            unset($this->BillFor);
        } else {
            $this->BillFor = $billFor;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get IsValidForBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValidForBilling()
    {
        return isset($this->IsValidForBilling) ? $this->IsValidForBilling : null;
    }
    /**
     * Set IsValidForBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValidForBilling
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setIsValidForBilling($isValidForBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValidForBilling) && !is_bool($isValidForBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValidForBilling, true), gettype($isValidForBilling)), __LINE__);
        }
        if (is_null($isValidForBilling) || (is_array($isValidForBilling) && empty($isValidForBilling))) {
            unset($this->IsValidForBilling);
        } else {
            $this->IsValidForBilling = $isValidForBilling;
        }
        return $this;
    }
    /**
     * Get Payer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneAccount|null
     */
    public function getPayer()
    {
        return isset($this->Payer) ? $this->Payer : null;
    }
    /**
     * Set Payer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setPayer(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null)
    {
        if (is_null($payer) || (is_array($payer) && empty($payer))) {
            unset($this->Payer);
        } else {
            $this->Payer = $payer;
        }
        return $this;
    }
    /**
     * Get PayerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerName()
    {
        return isset($this->PayerName) ? $this->PayerName : null;
    }
    /**
     * Set PayerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerName
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        if (is_null($payerName) || (is_array($payerName) && empty($payerName))) {
            unset($this->PayerName);
        } else {
            $this->PayerName = $payerName;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_SummaryItem
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
}
