<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.SubscriptionCard StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_SubscriptionCard extends Printing_PrintableItem_BasketItemBase
{
    /**
     * The AccessControlParentDefinitionDataReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlParentDefinitionDataReferenceId;
    /**
     * The AccessControlProductExtensionReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlProductExtensionReferenceId;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Hall
     */
    public $Hall;
    /**
     * The PriceLevelDisplayStyle
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelDisplayStyle;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintedNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintedNumber;
    /**
     * The Season
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_SeriesSeason
     */
    public $Season;
    /**
     * The Series
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Series
     */
    public $Series;
    /**
     * The SeriesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_SeriesGroup
     */
    public $SeriesGroup;
    /**
     * The ShowTimeNfcPassURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTimeNfcPassURL;
    /**
     * The Subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Subscription
     */
    public $Subscription;
    /**
     * The SubscriptionInstance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_SubscriptionInstance
     */
    public $SubscriptionInstance;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket
     */
    public $SubscriptionTickets;
    /**
     * The SubsidizedByAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsidizedByAccountName;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Venue
     */
    public $Venue;
    /**
     * Constructor method for Printing.PrintableItem.SubscriptionCard
     * @uses Printing_PrintableItem_SubscriptionCard::setAccessControlParentDefinitionDataReferenceId()
     * @uses Printing_PrintableItem_SubscriptionCard::setAccessControlProductExtensionReferenceId()
     * @uses Printing_PrintableItem_SubscriptionCard::setAction()
     * @uses Printing_PrintableItem_SubscriptionCard::setBarcode()
     * @uses Printing_PrintableItem_SubscriptionCard::setCardNumber()
     * @uses Printing_PrintableItem_SubscriptionCard::setHall()
     * @uses Printing_PrintableItem_SubscriptionCard::setPriceLevelDisplayStyle()
     * @uses Printing_PrintableItem_SubscriptionCard::setPriceLevelId()
     * @uses Printing_PrintableItem_SubscriptionCard::setPriceLevelName()
     * @uses Printing_PrintableItem_SubscriptionCard::setPrintCount()
     * @uses Printing_PrintableItem_SubscriptionCard::setPrintedNumber()
     * @uses Printing_PrintableItem_SubscriptionCard::setSeason()
     * @uses Printing_PrintableItem_SubscriptionCard::setSeries()
     * @uses Printing_PrintableItem_SubscriptionCard::setSeriesGroup()
     * @uses Printing_PrintableItem_SubscriptionCard::setShowTimeNfcPassURL()
     * @uses Printing_PrintableItem_SubscriptionCard::setSubscription()
     * @uses Printing_PrintableItem_SubscriptionCard::setSubscriptionInstance()
     * @uses Printing_PrintableItem_SubscriptionCard::setSubscriptionInstanceId()
     * @uses Printing_PrintableItem_SubscriptionCard::setSubscriptionTickets()
     * @uses Printing_PrintableItem_SubscriptionCard::setSubsidizedByAccountName()
     * @uses Printing_PrintableItem_SubscriptionCard::setVenue()
     * @param string $accessControlParentDefinitionDataReferenceId
     * @param string $accessControlProductExtensionReferenceId
     * @param string $action
     * @param string $barcode
     * @param string $cardNumber
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @param string $priceLevelDisplayStyle
     * @param string $priceLevelId
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param int $printCount
     * @param int $printedNumber
     * @param \patest\StructType\Ticketing_Printing_SeriesSeason $season
     * @param \patest\StructType\Ticketing_Printing_Series $series
     * @param \patest\StructType\Ticketing_Printing_SeriesGroup $seriesGroup
     * @param string $showTimeNfcPassURL
     * @param \patest\StructType\Ticketing_Printing_Subscription $subscription
     * @param \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance
     * @param string $subscriptionInstanceId
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $subscriptionTickets
     * @param string $subsidizedByAccountName
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     */
    public function __construct($accessControlParentDefinitionDataReferenceId = null, $accessControlProductExtensionReferenceId = null, $action = null, $barcode = null, $cardNumber = null, \patest\StructType\Ticketing_Printing_Hall $hall = null, $priceLevelDisplayStyle = null, $priceLevelId = null, \patest\StructType\GlobalString $priceLevelName = null, $printCount = null, $printedNumber = null, \patest\StructType\Ticketing_Printing_SeriesSeason $season = null, \patest\StructType\Ticketing_Printing_Series $series = null, \patest\StructType\Ticketing_Printing_SeriesGroup $seriesGroup = null, $showTimeNfcPassURL = null, \patest\StructType\Ticketing_Printing_Subscription $subscription = null, \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance = null, $subscriptionInstanceId = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $subscriptionTickets = null, $subsidizedByAccountName = null, \patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        $this
            ->setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId)
            ->setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId)
            ->setAction($action)
            ->setBarcode($barcode)
            ->setCardNumber($cardNumber)
            ->setHall($hall)
            ->setPriceLevelDisplayStyle($priceLevelDisplayStyle)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setPrintCount($printCount)
            ->setPrintedNumber($printedNumber)
            ->setSeason($season)
            ->setSeries($series)
            ->setSeriesGroup($seriesGroup)
            ->setShowTimeNfcPassURL($showTimeNfcPassURL)
            ->setSubscription($subscription)
            ->setSubscriptionInstance($subscriptionInstance)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionTickets($subscriptionTickets)
            ->setSubsidizedByAccountName($subsidizedByAccountName)
            ->setVenue($venue);
    }
    /**
     * Get AccessControlParentDefinitionDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlParentDefinitionDataReferenceId()
    {
        return isset($this->AccessControlParentDefinitionDataReferenceId) ? $this->AccessControlParentDefinitionDataReferenceId : null;
    }
    /**
     * Set AccessControlParentDefinitionDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlParentDefinitionDataReferenceId
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !is_string($accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlParentDefinitionDataReferenceId, true), gettype($accessControlParentDefinitionDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlParentDefinitionDataReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlParentDefinitionDataReferenceId) || (is_array($accessControlParentDefinitionDataReferenceId) && empty($accessControlParentDefinitionDataReferenceId))) {
            unset($this->AccessControlParentDefinitionDataReferenceId);
        } else {
            $this->AccessControlParentDefinitionDataReferenceId = $accessControlParentDefinitionDataReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlProductExtensionReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProductExtensionReferenceId()
    {
        return isset($this->AccessControlProductExtensionReferenceId) ? $this->AccessControlProductExtensionReferenceId : null;
    }
    /**
     * Set AccessControlProductExtensionReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProductExtensionReferenceId
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProductExtensionReferenceId) && !is_string($accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProductExtensionReferenceId, true), gettype($accessControlProductExtensionReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlProductExtensionReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlProductExtensionReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlProductExtensionReferenceId) || (is_array($accessControlProductExtensionReferenceId) && empty($accessControlProductExtensionReferenceId))) {
            unset($this->AccessControlProductExtensionReferenceId);
        } else {
            $this->AccessControlProductExtensionReferenceId = $accessControlProductExtensionReferenceId;
        }
        return $this;
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Hall|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setHall(\patest\StructType\Ticketing_Printing_Hall $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get PriceLevelDisplayStyle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelDisplayStyle()
    {
        return isset($this->PriceLevelDisplayStyle) ? $this->PriceLevelDisplayStyle : null;
    }
    /**
     * Set PriceLevelDisplayStyle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelDisplayStyle
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setPriceLevelDisplayStyle($priceLevelDisplayStyle = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelDisplayStyle) && !is_string($priceLevelDisplayStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelDisplayStyle, true), gettype($priceLevelDisplayStyle)), __LINE__);
        }
        if (is_null($priceLevelDisplayStyle) || (is_array($priceLevelDisplayStyle) && empty($priceLevelDisplayStyle))) {
            unset($this->PriceLevelDisplayStyle);
        } else {
            $this->PriceLevelDisplayStyle = $priceLevelDisplayStyle;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintedNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintedNumber()
    {
        return isset($this->PrintedNumber) ? $this->PrintedNumber : null;
    }
    /**
     * Set PrintedNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printedNumber
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setPrintedNumber($printedNumber = null)
    {
        // validation for constraint: int
        if (!is_null($printedNumber) && !(is_int($printedNumber) || ctype_digit($printedNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printedNumber, true), gettype($printedNumber)), __LINE__);
        }
        if (is_null($printedNumber) || (is_array($printedNumber) && empty($printedNumber))) {
            unset($this->PrintedNumber);
        } else {
            $this->PrintedNumber = $printedNumber;
        }
        return $this;
    }
    /**
     * Get Season value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_SeriesSeason|null
     */
    public function getSeason()
    {
        return isset($this->Season) ? $this->Season : null;
    }
    /**
     * Set Season value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_SeriesSeason $season
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSeason(\patest\StructType\Ticketing_Printing_SeriesSeason $season = null)
    {
        if (is_null($season) || (is_array($season) && empty($season))) {
            unset($this->Season);
        } else {
            $this->Season = $season;
        }
        return $this;
    }
    /**
     * Get Series value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Series|null
     */
    public function getSeries()
    {
        return isset($this->Series) ? $this->Series : null;
    }
    /**
     * Set Series value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Series $series
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSeries(\patest\StructType\Ticketing_Printing_Series $series = null)
    {
        if (is_null($series) || (is_array($series) && empty($series))) {
            unset($this->Series);
        } else {
            $this->Series = $series;
        }
        return $this;
    }
    /**
     * Get SeriesGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_SeriesGroup|null
     */
    public function getSeriesGroup()
    {
        return isset($this->SeriesGroup) ? $this->SeriesGroup : null;
    }
    /**
     * Set SeriesGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_SeriesGroup $seriesGroup
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSeriesGroup(\patest\StructType\Ticketing_Printing_SeriesGroup $seriesGroup = null)
    {
        if (is_null($seriesGroup) || (is_array($seriesGroup) && empty($seriesGroup))) {
            unset($this->SeriesGroup);
        } else {
            $this->SeriesGroup = $seriesGroup;
        }
        return $this;
    }
    /**
     * Get ShowTimeNfcPassURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTimeNfcPassURL()
    {
        return isset($this->ShowTimeNfcPassURL) ? $this->ShowTimeNfcPassURL : null;
    }
    /**
     * Set ShowTimeNfcPassURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTimeNfcPassURL
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setShowTimeNfcPassURL($showTimeNfcPassURL = null)
    {
        // validation for constraint: string
        if (!is_null($showTimeNfcPassURL) && !is_string($showTimeNfcPassURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTimeNfcPassURL, true), gettype($showTimeNfcPassURL)), __LINE__);
        }
        if (is_null($showTimeNfcPassURL) || (is_array($showTimeNfcPassURL) && empty($showTimeNfcPassURL))) {
            unset($this->ShowTimeNfcPassURL);
        } else {
            $this->ShowTimeNfcPassURL = $showTimeNfcPassURL;
        }
        return $this;
    }
    /**
     * Get Subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Subscription|null
     */
    public function getSubscription()
    {
        return isset($this->Subscription) ? $this->Subscription : null;
    }
    /**
     * Set Subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Subscription $subscription
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSubscription(\patest\StructType\Ticketing_Printing_Subscription $subscription = null)
    {
        if (is_null($subscription) || (is_array($subscription) && empty($subscription))) {
            unset($this->Subscription);
        } else {
            $this->Subscription = $subscription;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_SubscriptionInstance|null
     */
    public function getSubscriptionInstance()
    {
        return isset($this->SubscriptionInstance) ? $this->SubscriptionInstance : null;
    }
    /**
     * Set SubscriptionInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSubscriptionInstance(\patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance = null)
    {
        if (is_null($subscriptionInstance) || (is_array($subscriptionInstance) && empty($subscriptionInstance))) {
            unset($this->SubscriptionInstance);
        } else {
            $this->SubscriptionInstance = $subscriptionInstance;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket|null
     */
    public function getSubscriptionTickets()
    {
        return isset($this->SubscriptionTickets) ? $this->SubscriptionTickets : null;
    }
    /**
     * Set SubscriptionTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $subscriptionTickets
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSubscriptionTickets(\patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $subscriptionTickets = null)
    {
        if (is_null($subscriptionTickets) || (is_array($subscriptionTickets) && empty($subscriptionTickets))) {
            unset($this->SubscriptionTickets);
        } else {
            $this->SubscriptionTickets = $subscriptionTickets;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountName()
    {
        return isset($this->SubsidizedByAccountName) ? $this->SubsidizedByAccountName : null;
    }
    /**
     * Set SubsidizedByAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountName
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setSubsidizedByAccountName($subsidizedByAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountName) && !is_string($subsidizedByAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountName, true), gettype($subsidizedByAccountName)), __LINE__);
        }
        if (is_null($subsidizedByAccountName) || (is_array($subsidizedByAccountName) && empty($subsidizedByAccountName))) {
            unset($this->SubsidizedByAccountName);
        } else {
            $this->SubsidizedByAccountName = $subsidizedByAccountName;
        }
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Venue|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionCard
     */
    public function setVenue(\patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
}
