<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.Pledge StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_Pledge extends Printing_PrintableItem_Base
{
    /**
     * The Appeal_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Appeal_Name;
    /**
     * The Campaign_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Campaign_Description;
    /**
     * The Campaign_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Campaign_Name;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CreditCardDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardDisplayName;
    /**
     * The DefaultAmountPerInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DefaultAmountPerInstallment;
    /**
     * The FirstInstallmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstInstallmentDate;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FundName;
    /**
     * The InstallmentPaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentPaymentMethodType;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The InstallmentsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsType;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MandateTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateTypeName;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PaymentMethod_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethod_Name;
    /**
     * The PayOnDayOfMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PayOnDayOfMonth;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The Solicitor_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Solicitor_Name;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * Constructor method for Printing.PrintableItem.Pledge
     * @uses Printing_PrintableItem_Pledge::setAppeal_Name()
     * @uses Printing_PrintableItem_Pledge::setCampaign_Description()
     * @uses Printing_PrintableItem_Pledge::setCampaign_Name()
     * @uses Printing_PrintableItem_Pledge::setClientName()
     * @uses Printing_PrintableItem_Pledge::setCreditCardDisplayName()
     * @uses Printing_PrintableItem_Pledge::setDefaultAmountPerInstallment()
     * @uses Printing_PrintableItem_Pledge::setFirstInstallmentDate()
     * @uses Printing_PrintableItem_Pledge::setFundName()
     * @uses Printing_PrintableItem_Pledge::setInstallmentPaymentMethodType()
     * @uses Printing_PrintableItem_Pledge::setInstallmentSchedule()
     * @uses Printing_PrintableItem_Pledge::setInstallmentsType()
     * @uses Printing_PrintableItem_Pledge::setMandateNumber()
     * @uses Printing_PrintableItem_Pledge::setMandateTypeName()
     * @uses Printing_PrintableItem_Pledge::setMessage()
     * @uses Printing_PrintableItem_Pledge::setNotification()
     * @uses Printing_PrintableItem_Pledge::setNumberOfInstallments()
     * @uses Printing_PrintableItem_Pledge::setPaymentMethod_Name()
     * @uses Printing_PrintableItem_Pledge::setPayOnDayOfMonth()
     * @uses Printing_PrintableItem_Pledge::setPersonToTribute()
     * @uses Printing_PrintableItem_Pledge::setSolicitor_Name()
     * @uses Printing_PrintableItem_Pledge::setTributeType()
     * @param \patest\StructType\GlobalString $appeal_Name
     * @param \patest\StructType\GlobalString $campaign_Description
     * @param \patest\StructType\GlobalString $campaign_Name
     * @param string $clientName
     * @param string $creditCardDisplayName
     * @param \patest\StructType\Money $defaultAmountPerInstallment
     * @param string $firstInstallmentDate
     * @param \patest\StructType\GlobalString $fundName
     * @param string $installmentPaymentMethodType
     * @param string $installmentSchedule
     * @param string $installmentsType
     * @param int $mandateNumber
     * @param string $mandateTypeName
     * @param string $message
     * @param string $notification
     * @param int $numberOfInstallments
     * @param \patest\StructType\GlobalString $paymentMethod_Name
     * @param int $payOnDayOfMonth
     * @param string $personToTribute
     * @param string $solicitor_Name
     * @param string $tributeType
     */
    public function __construct(\patest\StructType\GlobalString $appeal_Name = null, \patest\StructType\GlobalString $campaign_Description = null, \patest\StructType\GlobalString $campaign_Name = null, $clientName = null, $creditCardDisplayName = null, \patest\StructType\Money $defaultAmountPerInstallment = null, $firstInstallmentDate = null, \patest\StructType\GlobalString $fundName = null, $installmentPaymentMethodType = null, $installmentSchedule = null, $installmentsType = null, $mandateNumber = null, $mandateTypeName = null, $message = null, $notification = null, $numberOfInstallments = null, \patest\StructType\GlobalString $paymentMethod_Name = null, $payOnDayOfMonth = null, $personToTribute = null, $solicitor_Name = null, $tributeType = null)
    {
        $this
            ->setAppeal_Name($appeal_Name)
            ->setCampaign_Description($campaign_Description)
            ->setCampaign_Name($campaign_Name)
            ->setClientName($clientName)
            ->setCreditCardDisplayName($creditCardDisplayName)
            ->setDefaultAmountPerInstallment($defaultAmountPerInstallment)
            ->setFirstInstallmentDate($firstInstallmentDate)
            ->setFundName($fundName)
            ->setInstallmentPaymentMethodType($installmentPaymentMethodType)
            ->setInstallmentSchedule($installmentSchedule)
            ->setInstallmentsType($installmentsType)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeName($mandateTypeName)
            ->setMessage($message)
            ->setNotification($notification)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPaymentMethod_Name($paymentMethod_Name)
            ->setPayOnDayOfMonth($payOnDayOfMonth)
            ->setPersonToTribute($personToTribute)
            ->setSolicitor_Name($solicitor_Name)
            ->setTributeType($tributeType);
    }
    /**
     * Get Appeal_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAppeal_Name()
    {
        return isset($this->Appeal_Name) ? $this->Appeal_Name : null;
    }
    /**
     * Set Appeal_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $appeal_Name
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setAppeal_Name(\patest\StructType\GlobalString $appeal_Name = null)
    {
        if (is_null($appeal_Name) || (is_array($appeal_Name) && empty($appeal_Name))) {
            unset($this->Appeal_Name);
        } else {
            $this->Appeal_Name = $appeal_Name;
        }
        return $this;
    }
    /**
     * Get Campaign_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCampaign_Description()
    {
        return isset($this->Campaign_Description) ? $this->Campaign_Description : null;
    }
    /**
     * Set Campaign_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $campaign_Description
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setCampaign_Description(\patest\StructType\GlobalString $campaign_Description = null)
    {
        if (is_null($campaign_Description) || (is_array($campaign_Description) && empty($campaign_Description))) {
            unset($this->Campaign_Description);
        } else {
            $this->Campaign_Description = $campaign_Description;
        }
        return $this;
    }
    /**
     * Get Campaign_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCampaign_Name()
    {
        return isset($this->Campaign_Name) ? $this->Campaign_Name : null;
    }
    /**
     * Set Campaign_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $campaign_Name
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setCampaign_Name(\patest\StructType\GlobalString $campaign_Name = null)
    {
        if (is_null($campaign_Name) || (is_array($campaign_Name) && empty($campaign_Name))) {
            unset($this->Campaign_Name);
        } else {
            $this->Campaign_Name = $campaign_Name;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CreditCardDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardDisplayName()
    {
        return isset($this->CreditCardDisplayName) ? $this->CreditCardDisplayName : null;
    }
    /**
     * Set CreditCardDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardDisplayName
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setCreditCardDisplayName($creditCardDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardDisplayName) && !is_string($creditCardDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardDisplayName, true), gettype($creditCardDisplayName)), __LINE__);
        }
        if (is_null($creditCardDisplayName) || (is_array($creditCardDisplayName) && empty($creditCardDisplayName))) {
            unset($this->CreditCardDisplayName);
        } else {
            $this->CreditCardDisplayName = $creditCardDisplayName;
        }
        return $this;
    }
    /**
     * Get DefaultAmountPerInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDefaultAmountPerInstallment()
    {
        return isset($this->DefaultAmountPerInstallment) ? $this->DefaultAmountPerInstallment : null;
    }
    /**
     * Set DefaultAmountPerInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $defaultAmountPerInstallment
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setDefaultAmountPerInstallment(\patest\StructType\Money $defaultAmountPerInstallment = null)
    {
        if (is_null($defaultAmountPerInstallment) || (is_array($defaultAmountPerInstallment) && empty($defaultAmountPerInstallment))) {
            unset($this->DefaultAmountPerInstallment);
        } else {
            $this->DefaultAmountPerInstallment = $defaultAmountPerInstallment;
        }
        return $this;
    }
    /**
     * Get FirstInstallmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstInstallmentDate()
    {
        return isset($this->FirstInstallmentDate) ? $this->FirstInstallmentDate : null;
    }
    /**
     * Set FirstInstallmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstInstallmentDate
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setFirstInstallmentDate($firstInstallmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstInstallmentDate) && !is_string($firstInstallmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstInstallmentDate, true), gettype($firstInstallmentDate)), __LINE__);
        }
        if (is_null($firstInstallmentDate) || (is_array($firstInstallmentDate) && empty($firstInstallmentDate))) {
            unset($this->FirstInstallmentDate);
        } else {
            $this->FirstInstallmentDate = $firstInstallmentDate;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fundName
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setFundName(\patest\StructType\GlobalString $fundName = null)
    {
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodType()
    {
        return isset($this->InstallmentPaymentMethodType) ? $this->InstallmentPaymentMethodType : null;
    }
    /**
     * Set InstallmentPaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentPaymentMethodType
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setInstallmentPaymentMethodType($installmentPaymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($installmentPaymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($installmentPaymentMethodType) ? implode(', ', $installmentPaymentMethodType) : var_export($installmentPaymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($installmentPaymentMethodType) || (is_array($installmentPaymentMethodType) && empty($installmentPaymentMethodType))) {
            unset($this->InstallmentPaymentMethodType);
        } else {
            $this->InstallmentPaymentMethodType = $installmentPaymentMethodType;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return isset($this->InstallmentSchedule) ? $this->InstallmentSchedule : null;
    }
    /**
     * Set InstallmentSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentsSchedule::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentsSchedule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentSchedule
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentsSchedule::valueIsValid($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentsSchedule', is_array($installmentSchedule) ? implode(', ', $installmentSchedule) : var_export($installmentSchedule, true), implode(', ', \patest\EnumType\PledgeInstallmentsSchedule::getValidValues())), __LINE__);
        }
        if (is_null($installmentSchedule) || (is_array($installmentSchedule) && empty($installmentSchedule))) {
            unset($this->InstallmentSchedule);
        } else {
            $this->InstallmentSchedule = $installmentSchedule;
        }
        return $this;
    }
    /**
     * Get InstallmentsType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsType()
    {
        return isset($this->InstallmentsType) ? $this->InstallmentsType : null;
    }
    /**
     * Set InstallmentsType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentsType::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsType
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setInstallmentsType($installmentsType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentsType::valueIsValid($installmentsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentsType', is_array($installmentsType) ? implode(', ', $installmentsType) : var_export($installmentsType, true), implode(', ', \patest\EnumType\PledgeInstallmentsType::getValidValues())), __LINE__);
        }
        if (is_null($installmentsType) || (is_array($installmentsType) && empty($installmentsType))) {
            unset($this->InstallmentsType);
        } else {
            $this->InstallmentsType = $installmentsType;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeName()
    {
        return isset($this->MandateTypeName) ? $this->MandateTypeName : null;
    }
    /**
     * Set MandateTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeName
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setMandateTypeName($mandateTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeName) && !is_string($mandateTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeName, true), gettype($mandateTypeName)), __LINE__);
        }
        if (is_null($mandateTypeName) || (is_array($mandateTypeName) && empty($mandateTypeName))) {
            unset($this->MandateTypeName);
        } else {
            $this->MandateTypeName = $mandateTypeName;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentMethod_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethod_Name()
    {
        return isset($this->PaymentMethod_Name) ? $this->PaymentMethod_Name : null;
    }
    /**
     * Set PaymentMethod_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethod_Name
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setPaymentMethod_Name(\patest\StructType\GlobalString $paymentMethod_Name = null)
    {
        if (is_null($paymentMethod_Name) || (is_array($paymentMethod_Name) && empty($paymentMethod_Name))) {
            unset($this->PaymentMethod_Name);
        } else {
            $this->PaymentMethod_Name = $paymentMethod_Name;
        }
        return $this;
    }
    /**
     * Get PayOnDayOfMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPayOnDayOfMonth()
    {
        return isset($this->PayOnDayOfMonth) ? $this->PayOnDayOfMonth : null;
    }
    /**
     * Set PayOnDayOfMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $payOnDayOfMonth
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setPayOnDayOfMonth($payOnDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($payOnDayOfMonth) && !(is_int($payOnDayOfMonth) || ctype_digit($payOnDayOfMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payOnDayOfMonth, true), gettype($payOnDayOfMonth)), __LINE__);
        }
        if (is_null($payOnDayOfMonth) || (is_array($payOnDayOfMonth) && empty($payOnDayOfMonth))) {
            unset($this->PayOnDayOfMonth);
        } else {
            $this->PayOnDayOfMonth = $payOnDayOfMonth;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get Solicitor_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSolicitor_Name()
    {
        return isset($this->Solicitor_Name) ? $this->Solicitor_Name : null;
    }
    /**
     * Set Solicitor_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $solicitor_Name
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setSolicitor_Name($solicitor_Name = null)
    {
        // validation for constraint: string
        if (!is_null($solicitor_Name) && !is_string($solicitor_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solicitor_Name, true), gettype($solicitor_Name)), __LINE__);
        }
        if (is_null($solicitor_Name) || (is_array($solicitor_Name) && empty($solicitor_Name))) {
            unset($this->Solicitor_Name);
        } else {
            $this->Solicitor_Name = $solicitor_Name;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Printing_PrintableItem_Pledge
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
}
