<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MatchingGiftRequest StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MatchingGiftRequest extends Printing_PrintableItem_Base
{
    /**
     * The Donations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation
     */
    public $Donations;
    /**
     * The DonationsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DonationsCount;
    /**
     * The DonationTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DonationTotalAmount;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $From;
    /**
     * The MatchAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MatchAmount;
    /**
     * The Matcher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_MatchingGiftMatcher
     */
    public $Matcher;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $To;
    /**
     * Constructor method for Printing.PrintableItem.MatchingGiftRequest
     * @uses Printing_PrintableItem_MatchingGiftRequest::setDonations()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setDonationsCount()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setDonationTotalAmount()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setFrom()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setMatchAmount()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setMatcher()
     * @uses Printing_PrintableItem_MatchingGiftRequest::setTo()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation $donations
     * @param int $donationsCount
     * @param float $donationTotalAmount
     * @param string $from
     * @param float $matchAmount
     * @param \patest\StructType\Printing_PrintableItem_MatchingGiftMatcher $matcher
     * @param string $to
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation $donations = null, $donationsCount = null, $donationTotalAmount = null, $from = null, $matchAmount = null, \patest\StructType\Printing_PrintableItem_MatchingGiftMatcher $matcher = null, $to = null)
    {
        $this
            ->setDonations($donations)
            ->setDonationsCount($donationsCount)
            ->setDonationTotalAmount($donationTotalAmount)
            ->setFrom($from)
            ->setMatchAmount($matchAmount)
            ->setMatcher($matcher)
            ->setTo($to);
    }
    /**
     * Get Donations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation|null
     */
    public function getDonations()
    {
        return isset($this->Donations) ? $this->Donations : null;
    }
    /**
     * Set Donations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation $donations
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setDonations(\patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonation $donations = null)
    {
        if (is_null($donations) || (is_array($donations) && empty($donations))) {
            unset($this->Donations);
        } else {
            $this->Donations = $donations;
        }
        return $this;
    }
    /**
     * Get DonationsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDonationsCount()
    {
        return isset($this->DonationsCount) ? $this->DonationsCount : null;
    }
    /**
     * Set DonationsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $donationsCount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setDonationsCount($donationsCount = null)
    {
        // validation for constraint: int
        if (!is_null($donationsCount) && !(is_int($donationsCount) || ctype_digit($donationsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($donationsCount, true), gettype($donationsCount)), __LINE__);
        }
        if (is_null($donationsCount) || (is_array($donationsCount) && empty($donationsCount))) {
            unset($this->DonationsCount);
        } else {
            $this->DonationsCount = $donationsCount;
        }
        return $this;
    }
    /**
     * Get DonationTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDonationTotalAmount()
    {
        return isset($this->DonationTotalAmount) ? $this->DonationTotalAmount : null;
    }
    /**
     * Set DonationTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $donationTotalAmount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setDonationTotalAmount($donationTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($donationTotalAmount) && !(is_float($donationTotalAmount) || is_numeric($donationTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donationTotalAmount, true), gettype($donationTotalAmount)), __LINE__);
        }
        if (is_null($donationTotalAmount) || (is_array($donationTotalAmount) && empty($donationTotalAmount))) {
            unset($this->DonationTotalAmount);
        } else {
            $this->DonationTotalAmount = $donationTotalAmount;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get MatchAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMatchAmount()
    {
        return isset($this->MatchAmount) ? $this->MatchAmount : null;
    }
    /**
     * Set MatchAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $matchAmount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setMatchAmount($matchAmount = null)
    {
        // validation for constraint: float
        if (!is_null($matchAmount) && !(is_float($matchAmount) || is_numeric($matchAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchAmount, true), gettype($matchAmount)), __LINE__);
        }
        if (is_null($matchAmount) || (is_array($matchAmount) && empty($matchAmount))) {
            unset($this->MatchAmount);
        } else {
            $this->MatchAmount = $matchAmount;
        }
        return $this;
    }
    /**
     * Get Matcher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftMatcher|null
     */
    public function getMatcher()
    {
        return isset($this->Matcher) ? $this->Matcher : null;
    }
    /**
     * Set Matcher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_MatchingGiftMatcher $matcher
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setMatcher(\patest\StructType\Printing_PrintableItem_MatchingGiftMatcher $matcher = null)
    {
        if (is_null($matcher) || (is_array($matcher) && empty($matcher))) {
            unset($this->Matcher);
        } else {
            $this->Matcher = $matcher;
        }
        return $this;
    }
    /**
     * Get To value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTo()
    {
        return isset($this->To) ? $this->To : null;
    }
    /**
     * Set To value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $to
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftRequest
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->To);
        } else {
            $this->To = $to;
        }
        return $this;
    }
}
