<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MatchingGiftDonationTaxStatement
 * StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MatchingGiftDonationTaxStatement extends Printing_PrintableItem_Base
{
    /**
     * The Donations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo
     */
    public $Donations;
    /**
     * The StatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StatedAmount;
    /**
     * The TaxStatementNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementNumber;
    /**
     * The TaxStatementNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementNumbers;
    /**
     * Constructor method for Printing.PrintableItem.MatchingGiftDonationTaxStatement
     * @uses Printing_PrintableItem_MatchingGiftDonationTaxStatement::setDonations()
     * @uses Printing_PrintableItem_MatchingGiftDonationTaxStatement::setStatedAmount()
     * @uses Printing_PrintableItem_MatchingGiftDonationTaxStatement::setTaxStatementNumber()
     * @uses Printing_PrintableItem_MatchingGiftDonationTaxStatement::setTaxStatementNumbers()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo $donations
     * @param float $statedAmount
     * @param string $taxStatementNumber
     * @param string $taxStatementNumbers
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo $donations = null, $statedAmount = null, $taxStatementNumber = null, $taxStatementNumbers = null)
    {
        $this
            ->setDonations($donations)
            ->setStatedAmount($statedAmount)
            ->setTaxStatementNumber($taxStatementNumber)
            ->setTaxStatementNumbers($taxStatementNumbers);
    }
    /**
     * Get Donations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo|null
     */
    public function getDonations()
    {
        return isset($this->Donations) ? $this->Donations : null;
    }
    /**
     * Set Donations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo $donations
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonationTaxStatement
     */
    public function setDonations(\patest\StructType\RecordSetOfPrinting_PrintableItem_MatchingGiftDonationInfo $donations = null)
    {
        if (is_null($donations) || (is_array($donations) && empty($donations))) {
            unset($this->Donations);
        } else {
            $this->Donations = $donations;
        }
        return $this;
    }
    /**
     * Get StatedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatedAmount()
    {
        return isset($this->StatedAmount) ? $this->StatedAmount : null;
    }
    /**
     * Set StatedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $statedAmount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonationTaxStatement
     */
    public function setStatedAmount($statedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($statedAmount) && !(is_float($statedAmount) || is_numeric($statedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($statedAmount, true), gettype($statedAmount)), __LINE__);
        }
        if (is_null($statedAmount) || (is_array($statedAmount) && empty($statedAmount))) {
            unset($this->StatedAmount);
        } else {
            $this->StatedAmount = $statedAmount;
        }
        return $this;
    }
    /**
     * Get TaxStatementNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementNumber()
    {
        return isset($this->TaxStatementNumber) ? $this->TaxStatementNumber : null;
    }
    /**
     * Set TaxStatementNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementNumber
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonationTaxStatement
     */
    public function setTaxStatementNumber($taxStatementNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementNumber) && !is_string($taxStatementNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementNumber, true), gettype($taxStatementNumber)), __LINE__);
        }
        if (is_null($taxStatementNumber) || (is_array($taxStatementNumber) && empty($taxStatementNumber))) {
            unset($this->TaxStatementNumber);
        } else {
            $this->TaxStatementNumber = $taxStatementNumber;
        }
        return $this;
    }
    /**
     * Get TaxStatementNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementNumbers()
    {
        return isset($this->TaxStatementNumbers) ? $this->TaxStatementNumbers : null;
    }
    /**
     * Set TaxStatementNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementNumbers
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonationTaxStatement
     */
    public function setTaxStatementNumbers($taxStatementNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementNumbers) && !is_string($taxStatementNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementNumbers, true), gettype($taxStatementNumbers)), __LINE__);
        }
        if (is_null($taxStatementNumbers) || (is_array($taxStatementNumbers) && empty($taxStatementNumbers))) {
            unset($this->TaxStatementNumbers);
        } else {
            $this->TaxStatementNumbers = $taxStatementNumbers;
        }
        return $this;
    }
}
