<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.InventoryBarcodes StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_InventoryBarcodes extends Printing_PrintableItem_Base
{
    /**
     * The Barcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode
     */
    public $Barcodes;
    /**
     * The Merchandise_CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_CategoryId;
    /**
     * The Merchandise_Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_Id;
    /**
     * The Merchandise_ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_ItemTypeId;
    /**
     * The Merchandise_ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_ProductId;
    /**
     * Constructor method for Printing.PrintableItem.InventoryBarcodes
     * @uses Printing_PrintableItem_InventoryBarcodes::setBarcodes()
     * @uses Printing_PrintableItem_InventoryBarcodes::setMerchandise_CategoryId()
     * @uses Printing_PrintableItem_InventoryBarcodes::setMerchandise_Id()
     * @uses Printing_PrintableItem_InventoryBarcodes::setMerchandise_ItemTypeId()
     * @uses Printing_PrintableItem_InventoryBarcodes::setMerchandise_ProductId()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode $barcodes
     * @param string $merchandise_CategoryId
     * @param string $merchandise_Id
     * @param string $merchandise_ItemTypeId
     * @param string $merchandise_ProductId
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode $barcodes = null, $merchandise_CategoryId = null, $merchandise_Id = null, $merchandise_ItemTypeId = null, $merchandise_ProductId = null)
    {
        $this
            ->setBarcodes($barcodes)
            ->setMerchandise_CategoryId($merchandise_CategoryId)
            ->setMerchandise_Id($merchandise_Id)
            ->setMerchandise_ItemTypeId($merchandise_ItemTypeId)
            ->setMerchandise_ProductId($merchandise_ProductId);
    }
    /**
     * Get Barcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode|null
     */
    public function getBarcodes()
    {
        return isset($this->Barcodes) ? $this->Barcodes : null;
    }
    /**
     * Set Barcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode $barcodes
     * @return \patest\StructType\Printing_PrintableItem_InventoryBarcodes
     */
    public function setBarcodes(\patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryBarcodes_Barcode $barcodes = null)
    {
        if (is_null($barcodes) || (is_array($barcodes) && empty($barcodes))) {
            unset($this->Barcodes);
        } else {
            $this->Barcodes = $barcodes;
        }
        return $this;
    }
    /**
     * Get Merchandise_CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_CategoryId()
    {
        return isset($this->Merchandise_CategoryId) ? $this->Merchandise_CategoryId : null;
    }
    /**
     * Set Merchandise_CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_CategoryId
     * @return \patest\StructType\Printing_PrintableItem_InventoryBarcodes
     */
    public function setMerchandise_CategoryId($merchandise_CategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_CategoryId) && !is_string($merchandise_CategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_CategoryId, true), gettype($merchandise_CategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_CategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_CategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_CategoryId, true)), __LINE__);
        }
        if (is_null($merchandise_CategoryId) || (is_array($merchandise_CategoryId) && empty($merchandise_CategoryId))) {
            unset($this->Merchandise_CategoryId);
        } else {
            $this->Merchandise_CategoryId = $merchandise_CategoryId;
        }
        return $this;
    }
    /**
     * Get Merchandise_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_Id()
    {
        return isset($this->Merchandise_Id) ? $this->Merchandise_Id : null;
    }
    /**
     * Set Merchandise_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_Id
     * @return \patest\StructType\Printing_PrintableItem_InventoryBarcodes
     */
    public function setMerchandise_Id($merchandise_Id = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_Id) && !is_string($merchandise_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_Id, true), gettype($merchandise_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_Id, true)), __LINE__);
        }
        if (is_null($merchandise_Id) || (is_array($merchandise_Id) && empty($merchandise_Id))) {
            unset($this->Merchandise_Id);
        } else {
            $this->Merchandise_Id = $merchandise_Id;
        }
        return $this;
    }
    /**
     * Get Merchandise_ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_ItemTypeId()
    {
        return isset($this->Merchandise_ItemTypeId) ? $this->Merchandise_ItemTypeId : null;
    }
    /**
     * Set Merchandise_ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_ItemTypeId
     * @return \patest\StructType\Printing_PrintableItem_InventoryBarcodes
     */
    public function setMerchandise_ItemTypeId($merchandise_ItemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_ItemTypeId) && !is_string($merchandise_ItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_ItemTypeId, true), gettype($merchandise_ItemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_ItemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_ItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_ItemTypeId, true)), __LINE__);
        }
        if (is_null($merchandise_ItemTypeId) || (is_array($merchandise_ItemTypeId) && empty($merchandise_ItemTypeId))) {
            unset($this->Merchandise_ItemTypeId);
        } else {
            $this->Merchandise_ItemTypeId = $merchandise_ItemTypeId;
        }
        return $this;
    }
    /**
     * Get Merchandise_ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_ProductId()
    {
        return isset($this->Merchandise_ProductId) ? $this->Merchandise_ProductId : null;
    }
    /**
     * Set Merchandise_ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_ProductId
     * @return \patest\StructType\Printing_PrintableItem_InventoryBarcodes
     */
    public function setMerchandise_ProductId($merchandise_ProductId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_ProductId) && !is_string($merchandise_ProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_ProductId, true), gettype($merchandise_ProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_ProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_ProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_ProductId, true)), __LINE__);
        }
        if (is_null($merchandise_ProductId) || (is_array($merchandise_ProductId) && empty($merchandise_ProductId))) {
            unset($this->Merchandise_ProductId);
        } else {
            $this->Merchandise_ProductId = $merchandise_ProductId;
        }
        return $this;
    }
}
