<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.GiftVoucher StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_GiftVoucher extends Printing_PrintableItem_BasketItemBase
{
    /**
     * The CurrentRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrentRedemptionValue;
    /**
     * The CurrentValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidFrom;
    /**
     * The CurrentValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidUntil;
    /**
     * The GiftVoucherDefinition
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition
     */
    public $GiftVoucherDefinition;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The IsPrePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrePrinted;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * Constructor method for Printing.PrintableItem.GiftVoucher
     * @uses Printing_PrintableItem_GiftVoucher::setCurrentRedemptionValue()
     * @uses Printing_PrintableItem_GiftVoucher::setCurrentValidFrom()
     * @uses Printing_PrintableItem_GiftVoucher::setCurrentValidUntil()
     * @uses Printing_PrintableItem_GiftVoucher::setGiftVoucherDefinition()
     * @uses Printing_PrintableItem_GiftVoucher::setGiftVoucherDefinitionId()
     * @uses Printing_PrintableItem_GiftVoucher::setGiftVoucherNumber()
     * @uses Printing_PrintableItem_GiftVoucher::setGiftVoucherTypeId()
     * @uses Printing_PrintableItem_GiftVoucher::setIsPrePrinted()
     * @uses Printing_PrintableItem_GiftVoucher::setPrintCount()
     * @param float $currentRedemptionValue
     * @param string $currentValidFrom
     * @param string $currentValidUntil
     * @param \patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition $giftVoucherDefinition
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherNumber
     * @param string $giftVoucherTypeId
     * @param bool $isPrePrinted
     * @param int $printCount
     */
    public function __construct($currentRedemptionValue = null, $currentValidFrom = null, $currentValidUntil = null, \patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition $giftVoucherDefinition = null, $giftVoucherDefinitionId = null, $giftVoucherNumber = null, $giftVoucherTypeId = null, $isPrePrinted = null, $printCount = null)
    {
        $this
            ->setCurrentRedemptionValue($currentRedemptionValue)
            ->setCurrentValidFrom($currentValidFrom)
            ->setCurrentValidUntil($currentValidUntil)
            ->setGiftVoucherDefinition($giftVoucherDefinition)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setIsPrePrinted($isPrePrinted)
            ->setPrintCount($printCount);
    }
    /**
     * Get CurrentRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrentRedemptionValue()
    {
        return isset($this->CurrentRedemptionValue) ? $this->CurrentRedemptionValue : null;
    }
    /**
     * Set CurrentRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currentRedemptionValue
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setCurrentRedemptionValue($currentRedemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($currentRedemptionValue) && !(is_float($currentRedemptionValue) || is_numeric($currentRedemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentRedemptionValue, true), gettype($currentRedemptionValue)), __LINE__);
        }
        if (is_null($currentRedemptionValue) || (is_array($currentRedemptionValue) && empty($currentRedemptionValue))) {
            unset($this->CurrentRedemptionValue);
        } else {
            $this->CurrentRedemptionValue = $currentRedemptionValue;
        }
        return $this;
    }
    /**
     * Get CurrentValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidFrom()
    {
        return isset($this->CurrentValidFrom) ? $this->CurrentValidFrom : null;
    }
    /**
     * Set CurrentValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidFrom
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setCurrentValidFrom($currentValidFrom = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidFrom) && !is_string($currentValidFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidFrom, true), gettype($currentValidFrom)), __LINE__);
        }
        if (is_null($currentValidFrom) || (is_array($currentValidFrom) && empty($currentValidFrom))) {
            unset($this->CurrentValidFrom);
        } else {
            $this->CurrentValidFrom = $currentValidFrom;
        }
        return $this;
    }
    /**
     * Get CurrentValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidUntil()
    {
        return isset($this->CurrentValidUntil) ? $this->CurrentValidUntil : null;
    }
    /**
     * Set CurrentValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidUntil
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setCurrentValidUntil($currentValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidUntil) && !is_string($currentValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidUntil, true), gettype($currentValidUntil)), __LINE__);
        }
        if (is_null($currentValidUntil) || (is_array($currentValidUntil) && empty($currentValidUntil))) {
            unset($this->CurrentValidUntil);
        } else {
            $this->CurrentValidUntil = $currentValidUntil;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition|null
     */
    public function getGiftVoucherDefinition()
    {
        return isset($this->GiftVoucherDefinition) ? $this->GiftVoucherDefinition : null;
    }
    /**
     * Set GiftVoucherDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition $giftVoucherDefinition
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setGiftVoucherDefinition(\patest\StructType\GiftVoucher_Printing_GiftVoucherDefinition $giftVoucherDefinition = null)
    {
        if (is_null($giftVoucherDefinition) || (is_array($giftVoucherDefinition) && empty($giftVoucherDefinition))) {
            unset($this->GiftVoucherDefinition);
        } else {
            $this->GiftVoucherDefinition = $giftVoucherDefinition;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get IsPrePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrePrinted()
    {
        return isset($this->IsPrePrinted) ? $this->IsPrePrinted : null;
    }
    /**
     * Set IsPrePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrePrinted
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setIsPrePrinted($isPrePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrePrinted) && !is_bool($isPrePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrePrinted, true), gettype($isPrePrinted)), __LINE__);
        }
        if (is_null($isPrePrinted) || (is_array($isPrePrinted) && empty($isPrePrinted))) {
            unset($this->IsPrePrinted);
        } else {
            $this->IsPrePrinted = $isPrePrinted;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Printing_PrintableItem_GiftVoucher
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
}
