<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.BasketItemBase StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_BasketItemBase extends Printing_PrintableItem_Base
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ExtraFieldsData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_Sales_ExtraFieldsData
     */
    public $ExtraFieldsData;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmation;
    /**
     * The IsNewAccessCard
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNewAccessCard;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReservation;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Owner
     */
    public $Owner;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier
     */
    public $PriceModifiers;
    /**
     * The PriceTypeComplex
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_PriceType
     */
    public $PriceTypeComplex;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceTypeName;
    /**
     * The PriceType_PrintDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_PrintDescription;
    /**
     * The PriceType_ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_ShortDescription;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The SupplierAccount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount
     */
    public $SupplierAccount;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_ItemTotals
     */
    public $Totals;
    /**
     * Constructor method for Printing.PrintableItem.BasketItemBase
     * @uses Printing_PrintableItem_BasketItemBase::setAccessCardId()
     * @uses Printing_PrintableItem_BasketItemBase::setClientId()
     * @uses Printing_PrintableItem_BasketItemBase::setExtraFieldsData()
     * @uses Printing_PrintableItem_BasketItemBase::setIsComplimentary()
     * @uses Printing_PrintableItem_BasketItemBase::setIsConfirmation()
     * @uses Printing_PrintableItem_BasketItemBase::setIsNewAccessCard()
     * @uses Printing_PrintableItem_BasketItemBase::setIsReservation()
     * @uses Printing_PrintableItem_BasketItemBase::setIsReturned()
     * @uses Printing_PrintableItem_BasketItemBase::setItemId()
     * @uses Printing_PrintableItem_BasketItemBase::setItemType()
     * @uses Printing_PrintableItem_BasketItemBase::setOrganizationUnitId()
     * @uses Printing_PrintableItem_BasketItemBase::setOwner()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceModifiers()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceTypeComplex()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceTypeId()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceTypeName()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceType_PrintDescription()
     * @uses Printing_PrintableItem_BasketItemBase::setPriceType_ShortDescription()
     * @uses Printing_PrintableItem_BasketItemBase::setReservationExpiryDate()
     * @uses Printing_PrintableItem_BasketItemBase::setSupplierAccount()
     * @uses Printing_PrintableItem_BasketItemBase::setTotals()
     * @param string $accessCardId
     * @param string $clientId
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @param bool $isComplimentary
     * @param bool $isConfirmation
     * @param bool $isNewAccessCard
     * @param bool $isReservation
     * @param bool $isReturned
     * @param int $itemId
     * @param int $itemType
     * @param string $organizationUnitId
     * @param \patest\StructType\Printing_AuxDataItem_Owner $owner
     * @param \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $priceTypeName
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @param string $reservationExpiryDate
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     */
    public function __construct($accessCardId = null, $clientId = null, \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null, $isComplimentary = null, $isConfirmation = null, $isNewAccessCard = null, $isReservation = null, $isReturned = null, $itemId = null, $itemType = null, $organizationUnitId = null, \patest\StructType\Printing_AuxDataItem_Owner $owner = null, \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers = null, \patest\StructType\Sales_PriceType $priceTypeComplex = null, $priceTypeId = null, \patest\StructType\GlobalString $priceTypeName = null, \patest\StructType\GlobalString $priceType_PrintDescription = null, \patest\StructType\GlobalString $priceType_ShortDescription = null, $reservationExpiryDate = null, \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount = null, \patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setClientId($clientId)
            ->setExtraFieldsData($extraFieldsData)
            ->setIsComplimentary($isComplimentary)
            ->setIsConfirmation($isConfirmation)
            ->setIsNewAccessCard($isNewAccessCard)
            ->setIsReservation($isReservation)
            ->setIsReturned($isReturned)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOwner($owner)
            ->setPriceModifiers($priceModifiers)
            ->setPriceTypeComplex($priceTypeComplex)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setPriceType_PrintDescription($priceType_PrintDescription)
            ->setPriceType_ShortDescription($priceType_ShortDescription)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setSupplierAccount($supplierAccount)
            ->setTotals($totals);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ExtraFieldsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_Sales_ExtraFieldsData|null
     */
    public function getExtraFieldsData()
    {
        return isset($this->ExtraFieldsData) ? $this->ExtraFieldsData : null;
    }
    /**
     * Set ExtraFieldsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setExtraFieldsData(\patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null)
    {
        if (is_null($extraFieldsData) || (is_array($extraFieldsData) && empty($extraFieldsData))) {
            unset($this->ExtraFieldsData);
        } else {
            $this->ExtraFieldsData = $extraFieldsData;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsConfirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmation()
    {
        return isset($this->IsConfirmation) ? $this->IsConfirmation : null;
    }
    /**
     * Set IsConfirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmation
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setIsConfirmation($isConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmation) && !is_bool($isConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmation, true), gettype($isConfirmation)), __LINE__);
        }
        if (is_null($isConfirmation) || (is_array($isConfirmation) && empty($isConfirmation))) {
            unset($this->IsConfirmation);
        } else {
            $this->IsConfirmation = $isConfirmation;
        }
        return $this;
    }
    /**
     * Get IsNewAccessCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNewAccessCard()
    {
        return isset($this->IsNewAccessCard) ? $this->IsNewAccessCard : null;
    }
    /**
     * Set IsNewAccessCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNewAccessCard
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setIsNewAccessCard($isNewAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewAccessCard) && !is_bool($isNewAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewAccessCard, true), gettype($isNewAccessCard)), __LINE__);
        }
        if (is_null($isNewAccessCard) || (is_array($isNewAccessCard) && empty($isNewAccessCard))) {
            unset($this->IsNewAccessCard);
        } else {
            $this->IsNewAccessCard = $isNewAccessCard;
        }
        return $this;
    }
    /**
     * Get IsReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReservation()
    {
        return isset($this->IsReservation) ? $this->IsReservation : null;
    }
    /**
     * Set IsReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReservation
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        if (is_null($isReservation) || (is_array($isReservation) && empty($isReservation))) {
            unset($this->IsReservation);
        } else {
            $this->IsReservation = $isReservation;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Owner|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Owner $owner
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setOwner(\patest\StructType\Printing_AuxDataItem_Owner $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfPrinting_Sales_PriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get PriceTypeComplex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_PriceType|null
     */
    public function getPriceTypeComplex()
    {
        return isset($this->PriceTypeComplex) ? $this->PriceTypeComplex : null;
    }
    /**
     * Set PriceTypeComplex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceTypeComplex(\patest\StructType\Sales_PriceType $priceTypeComplex = null)
    {
        if (is_null($priceTypeComplex) || (is_array($priceTypeComplex) && empty($priceTypeComplex))) {
            unset($this->PriceTypeComplex);
        } else {
            $this->PriceTypeComplex = $priceTypeComplex;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceTypeName
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceTypeName(\patest\StructType\GlobalString $priceTypeName = null)
    {
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get PriceType_PrintDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_PrintDescription()
    {
        return isset($this->PriceType_PrintDescription) ? $this->PriceType_PrintDescription : null;
    }
    /**
     * Set PriceType_PrintDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceType_PrintDescription(\patest\StructType\GlobalString $priceType_PrintDescription = null)
    {
        if (is_null($priceType_PrintDescription) || (is_array($priceType_PrintDescription) && empty($priceType_PrintDescription))) {
            unset($this->PriceType_PrintDescription);
        } else {
            $this->PriceType_PrintDescription = $priceType_PrintDescription;
        }
        return $this;
    }
    /**
     * Get PriceType_ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_ShortDescription()
    {
        return isset($this->PriceType_ShortDescription) ? $this->PriceType_ShortDescription : null;
    }
    /**
     * Set PriceType_ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setPriceType_ShortDescription(\patest\StructType\GlobalString $priceType_ShortDescription = null)
    {
        if (is_null($priceType_ShortDescription) || (is_array($priceType_ShortDescription) && empty($priceType_ShortDescription))) {
            unset($this->PriceType_ShortDescription);
        } else {
            $this->PriceType_ShortDescription = $priceType_ShortDescription;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get SupplierAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount|null
     */
    public function getSupplierAccount()
    {
        return isset($this->SupplierAccount) ? $this->SupplierAccount : null;
    }
    /**
     * Set SupplierAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setSupplierAccount(\patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount = null)
    {
        if (is_null($supplierAccount) || (is_array($supplierAccount) && empty($supplierAccount))) {
            unset($this->SupplierAccount);
        } else {
            $this->SupplierAccount = $supplierAccount;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_ItemTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     * @return \patest\StructType\Printing_PrintableItem_BasketItemBase
     */
    public function setTotals(\patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
}
