<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.BallotApplicationDetail StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_BallotApplicationDetail extends Printing_PrintableItem_Base
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The NumberOfSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfSeats;
    /**
     * The OwnerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerCrmId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The SectionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectionName;
    /**
     * Constructor method for Printing.PrintableItem.BallotApplicationDetail
     * @uses Printing_PrintableItem_BallotApplicationDetail::setEventDate()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setEventName()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setNumberOfSeats()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setOwnerCrmId()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setOwnerName()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setPriceTypeName()
     * @uses Printing_PrintableItem_BallotApplicationDetail::setSectionName()
     * @param string $eventDate
     * @param string $eventName
     * @param int $numberOfSeats
     * @param string $ownerCrmId
     * @param string $ownerName
     * @param string $priceTypeName
     * @param string $sectionName
     */
    public function __construct($eventDate = null, $eventName = null, $numberOfSeats = null, $ownerCrmId = null, $ownerName = null, $priceTypeName = null, $sectionName = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setEventName($eventName)
            ->setNumberOfSeats($numberOfSeats)
            ->setOwnerCrmId($ownerCrmId)
            ->setOwnerName($ownerName)
            ->setPriceTypeName($priceTypeName)
            ->setSectionName($sectionName);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get NumberOfSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfSeats()
    {
        return isset($this->NumberOfSeats) ? $this->NumberOfSeats : null;
    }
    /**
     * Set NumberOfSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfSeats
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setNumberOfSeats($numberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSeats) && !(is_int($numberOfSeats) || ctype_digit($numberOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSeats, true), gettype($numberOfSeats)), __LINE__);
        }
        if (is_null($numberOfSeats) || (is_array($numberOfSeats) && empty($numberOfSeats))) {
            unset($this->NumberOfSeats);
        } else {
            $this->NumberOfSeats = $numberOfSeats;
        }
        return $this;
    }
    /**
     * Get OwnerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerCrmId()
    {
        return isset($this->OwnerCrmId) ? $this->OwnerCrmId : null;
    }
    /**
     * Set OwnerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerCrmId
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setOwnerCrmId($ownerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCrmId) && !is_string($ownerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCrmId, true), gettype($ownerCrmId)), __LINE__);
        }
        if (is_null($ownerCrmId) || (is_array($ownerCrmId) && empty($ownerCrmId))) {
            unset($this->OwnerCrmId);
        } else {
            $this->OwnerCrmId = $ownerCrmId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get SectionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionName()
    {
        return isset($this->SectionName) ? $this->SectionName : null;
    }
    /**
     * Set SectionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationDetail
     */
    public function setSectionName($sectionName = null)
    {
        // validation for constraint: string
        if (!is_null($sectionName) && !is_string($sectionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionName, true), gettype($sectionName)), __LINE__);
        }
        if (is_null($sectionName) || (is_array($sectionName) && empty($sectionName))) {
            unset($this->SectionName);
        } else {
            $this->SectionName = $sectionName;
        }
        return $this;
    }
}
