<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.Owner StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_Owner extends Printing_AuxDataItem_Client
{
    /**
     * The AccountData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Account
     */
    public $AccountData;
    /**
     * The CustomerData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Customer
     */
    public $CustomerData;
    /**
     * Constructor method for Printing.AuxDataItem.Owner
     * @uses Printing_AuxDataItem_Owner::setAccountData()
     * @uses Printing_AuxDataItem_Owner::setCustomerData()
     * @param \patest\StructType\Printing_AuxDataItem_Account $accountData
     * @param \patest\StructType\Printing_AuxDataItem_Customer $customerData
     */
    public function __construct(\patest\StructType\Printing_AuxDataItem_Account $accountData = null, \patest\StructType\Printing_AuxDataItem_Customer $customerData = null)
    {
        $this
            ->setAccountData($accountData)
            ->setCustomerData($customerData);
    }
    /**
     * Get AccountData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Account|null
     */
    public function getAccountData()
    {
        return isset($this->AccountData) ? $this->AccountData : null;
    }
    /**
     * Set AccountData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Account $accountData
     * @return \patest\StructType\Printing_AuxDataItem_Owner
     */
    public function setAccountData(\patest\StructType\Printing_AuxDataItem_Account $accountData = null)
    {
        if (is_null($accountData) || (is_array($accountData) && empty($accountData))) {
            unset($this->AccountData);
        } else {
            $this->AccountData = $accountData;
        }
        return $this;
    }
    /**
     * Get CustomerData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Customer|null
     */
    public function getCustomerData()
    {
        return isset($this->CustomerData) ? $this->CustomerData : null;
    }
    /**
     * Set CustomerData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Customer $customerData
     * @return \patest\StructType\Printing_AuxDataItem_Owner
     */
    public function setCustomerData(\patest\StructType\Printing_AuxDataItem_Customer $customerData = null)
    {
        if (is_null($customerData) || (is_array($customerData) && empty($customerData))) {
            unset($this->CustomerData);
        } else {
            $this->CustomerData = $customerData;
        }
        return $this;
    }
}
