<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersistableEntity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersistableEntity
 * @subpackage Structs
 */
class PersistableEntity extends TenantIndependentPersistableEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * Constructor method for PersistableEntity
     * @uses PersistableEntity::setAccessPermissions()
     * @uses PersistableEntity::setHolderTenantId()
     * @param string[] $accessPermissions
     * @param int $holderTenantId
     */
    public function __construct(array $accessPermissions = array(), $holderTenantId = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setHolderTenantId($holderTenantId);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $persistableEntityAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($persistableEntityAccessPermissionsItem)) {
                $invalidValues[] = is_object($persistableEntityAccessPermissionsItem) ? get_class($persistableEntityAccessPermissionsItem) : sprintf('%s(%s)', gettype($persistableEntityAccessPermissionsItem), var_export($persistableEntityAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\PersistableEntity
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\PersistableEntity
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
}
