<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.UIReimbursementItem StructType
 * @subpackage Structs
 */
class Payment_UIReimbursementItem extends AnyEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Amount;
    /**
     * The OriginalPaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalPaymentMethod;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentNumber;
    /**
     * Constructor method for Payment.UIReimbursementItem
     * @uses Payment_UIReimbursementItem::setAmount()
     * @uses Payment_UIReimbursementItem::setOriginalPaymentMethod()
     * @uses Payment_UIReimbursementItem::setPaymentDetails()
     * @uses Payment_UIReimbursementItem::setPaymentMethod()
     * @uses Payment_UIReimbursementItem::setPaymentNumber()
     * @param string $amount
     * @param string $originalPaymentMethod
     * @param string $paymentDetails
     * @param string $paymentMethod
     * @param int $paymentNumber
     */
    public function __construct($amount = null, $originalPaymentMethod = null, $paymentDetails = null, $paymentMethod = null, $paymentNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setOriginalPaymentMethod($originalPaymentMethod)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentNumber($paymentNumber);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amount
     * @return \patest\StructType\Payment_UIReimbursementItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentMethod()
    {
        return isset($this->OriginalPaymentMethod) ? $this->OriginalPaymentMethod : null;
    }
    /**
     * Set OriginalPaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentMethod
     * @return \patest\StructType\Payment_UIReimbursementItem
     */
    public function setOriginalPaymentMethod($originalPaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentMethod) && !is_string($originalPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentMethod, true), gettype($originalPaymentMethod)), __LINE__);
        }
        if (is_null($originalPaymentMethod) || (is_array($originalPaymentMethod) && empty($originalPaymentMethod))) {
            unset($this->OriginalPaymentMethod);
        } else {
            $this->OriginalPaymentMethod = $originalPaymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Payment_UIReimbursementItem
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \patest\StructType\Payment_UIReimbursementItem
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentNumber()
    {
        return isset($this->PaymentNumber) ? $this->PaymentNumber : null;
    }
    /**
     * Set PaymentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentNumber
     * @return \patest\StructType\Payment_UIReimbursementItem
     */
    public function setPaymentNumber($paymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentNumber) && !(is_int($paymentNumber) || ctype_digit($paymentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentNumber, true), gettype($paymentNumber)), __LINE__);
        }
        if (is_null($paymentNumber) || (is_array($paymentNumber) && empty($paymentNumber))) {
            unset($this->PaymentNumber);
        } else {
            $this->PaymentNumber = $paymentNumber;
        }
        return $this;
    }
}
