<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.RemoveUIInstallment StructType
 * @subpackage Structs
 */
class Payment_RemoveUIInstallment extends Payment_UIInstallment
{
    /**
     * The CommandDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandDescription;
    /**
     * The Question
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Question;
    /**
     * Constructor method for Payment.RemoveUIInstallment
     * @uses Payment_RemoveUIInstallment::setCommandDescription()
     * @uses Payment_RemoveUIInstallment::setQuestion()
     * @param string $commandDescription
     * @param string $question
     */
    public function __construct($commandDescription = null, $question = null)
    {
        $this
            ->setCommandDescription($commandDescription)
            ->setQuestion($question);
    }
    /**
     * Get CommandDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandDescription()
    {
        return isset($this->CommandDescription) ? $this->CommandDescription : null;
    }
    /**
     * Set CommandDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandDescription
     * @return \patest\StructType\Payment_RemoveUIInstallment
     */
    public function setCommandDescription($commandDescription = null)
    {
        // validation for constraint: string
        if (!is_null($commandDescription) && !is_string($commandDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDescription, true), gettype($commandDescription)), __LINE__);
        }
        if (is_null($commandDescription) || (is_array($commandDescription) && empty($commandDescription))) {
            unset($this->CommandDescription);
        } else {
            $this->CommandDescription = $commandDescription;
        }
        return $this;
    }
    /**
     * Get Question value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuestion()
    {
        return isset($this->Question) ? $this->Question : null;
    }
    /**
     * Set Question value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $question
     * @return \patest\StructType\Payment_RemoveUIInstallment
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question, true), gettype($question)), __LINE__);
        }
        if (is_null($question) || (is_array($question) && empty($question))) {
            unset($this->Question);
        } else {
            $this->Question = $question;
        }
        return $this;
    }
}
