<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentPlanPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_PaymentPlanPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The DirectDebitMandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DirectDebitMandateId;
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit
     */
    public $InstallmentItems;
    /**
     * The InstallmentsPaymentMethod
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentsPaymentMethod;
    /**
     * The InstallmentsPaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsPaymentMethodType;
    /**
     * The InstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentsScheduleId;
    /**
     * The InstallmentsScheduleKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsScheduleKind;
    /**
     * The NextDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextDueDate;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PaidInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaidInstallments;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Payment.PaymentPlanPaymentItemInformation
     * @uses Payment_PaymentPlanPaymentItemInformation::setClientAmount()
     * @uses Payment_PaymentPlanPaymentItemInformation::setDirectDebitMandateId()
     * @uses Payment_PaymentPlanPaymentItemInformation::setInstallmentItems()
     * @uses Payment_PaymentPlanPaymentItemInformation::setInstallmentsPaymentMethod()
     * @uses Payment_PaymentPlanPaymentItemInformation::setInstallmentsPaymentMethodType()
     * @uses Payment_PaymentPlanPaymentItemInformation::setInstallmentsScheduleId()
     * @uses Payment_PaymentPlanPaymentItemInformation::setInstallmentsScheduleKind()
     * @uses Payment_PaymentPlanPaymentItemInformation::setNextDueDate()
     * @uses Payment_PaymentPlanPaymentItemInformation::setNotes()
     * @uses Payment_PaymentPlanPaymentItemInformation::setNumberOfInstallments()
     * @uses Payment_PaymentPlanPaymentItemInformation::setPaidInstallments()
     * @uses Payment_PaymentPlanPaymentItemInformation::setPaymentMethodId()
     * @uses Payment_PaymentPlanPaymentItemInformation::setPaymentPlanId()
     * @uses Payment_PaymentPlanPaymentItemInformation::setPaymentTokenId()
     * @uses Payment_PaymentPlanPaymentItemInformation::setRemainingAmount()
     * @uses Payment_PaymentPlanPaymentItemInformation::setStatus()
     * @param \patest\StructType\Money $clientAmount
     * @param string $directDebitMandateId
     * @param \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems
     * @param string $installmentsPaymentMethod
     * @param string $installmentsPaymentMethodType
     * @param string $installmentsScheduleId
     * @param string $installmentsScheduleKind
     * @param string $nextDueDate
     * @param string $notes
     * @param int $numberOfInstallments
     * @param int $paidInstallments
     * @param string $paymentMethodId
     * @param string $paymentPlanId
     * @param string $paymentTokenId
     * @param \patest\StructType\Money $remainingAmount
     * @param string $status
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $directDebitMandateId = null, \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems = null, $installmentsPaymentMethod = null, $installmentsPaymentMethodType = null, $installmentsScheduleId = null, $installmentsScheduleKind = null, $nextDueDate = null, $notes = null, $numberOfInstallments = null, $paidInstallments = null, $paymentMethodId = null, $paymentPlanId = null, $paymentTokenId = null, \patest\StructType\Money $remainingAmount = null, $status = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setDirectDebitMandateId($directDebitMandateId)
            ->setInstallmentItems($installmentItems)
            ->setInstallmentsPaymentMethod($installmentsPaymentMethod)
            ->setInstallmentsPaymentMethodType($installmentsPaymentMethodType)
            ->setInstallmentsScheduleId($installmentsScheduleId)
            ->setInstallmentsScheduleKind($installmentsScheduleKind)
            ->setNextDueDate($nextDueDate)
            ->setNotes($notes)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPaidInstallments($paidInstallments)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentPlanId($paymentPlanId)
            ->setPaymentTokenId($paymentTokenId)
            ->setRemainingAmount($remainingAmount)
            ->setStatus($status);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitMandateId()
    {
        return isset($this->DirectDebitMandateId) ? $this->DirectDebitMandateId : null;
    }
    /**
     * Set DirectDebitMandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitMandateId
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setDirectDebitMandateId($directDebitMandateId = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitMandateId) && !is_string($directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitMandateId, true), gettype($directDebitMandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($directDebitMandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($directDebitMandateId, true)), __LINE__);
        }
        if (is_null($directDebitMandateId) || (is_array($directDebitMandateId) && empty($directDebitMandateId))) {
            unset($this->DirectDebitMandateId);
        } else {
            $this->DirectDebitMandateId = $directDebitMandateId;
        }
        return $this;
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setInstallmentItems(\patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get InstallmentsPaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPaymentMethod()
    {
        return isset($this->InstallmentsPaymentMethod) ? $this->InstallmentsPaymentMethod : null;
    }
    /**
     * Set InstallmentsPaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentsPaymentMethod
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setInstallmentsPaymentMethod($installmentsPaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($installmentsPaymentMethod) && !is_string($installmentsPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentsPaymentMethod, true), gettype($installmentsPaymentMethod)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentsPaymentMethod) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentsPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentsPaymentMethod, true)), __LINE__);
        }
        if (is_null($installmentsPaymentMethod) || (is_array($installmentsPaymentMethod) && empty($installmentsPaymentMethod))) {
            unset($this->InstallmentsPaymentMethod);
        } else {
            $this->InstallmentsPaymentMethod = $installmentsPaymentMethod;
        }
        return $this;
    }
    /**
     * Get InstallmentsPaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPaymentMethodType()
    {
        return isset($this->InstallmentsPaymentMethodType) ? $this->InstallmentsPaymentMethodType : null;
    }
    /**
     * Set InstallmentsPaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsPaymentMethodType
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setInstallmentsPaymentMethodType($installmentsPaymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($installmentsPaymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($installmentsPaymentMethodType) ? implode(', ', $installmentsPaymentMethodType) : var_export($installmentsPaymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($installmentsPaymentMethodType) || (is_array($installmentsPaymentMethodType) && empty($installmentsPaymentMethodType))) {
            unset($this->InstallmentsPaymentMethodType);
        } else {
            $this->InstallmentsPaymentMethodType = $installmentsPaymentMethodType;
        }
        return $this;
    }
    /**
     * Get InstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsScheduleId()
    {
        return isset($this->InstallmentsScheduleId) ? $this->InstallmentsScheduleId : null;
    }
    /**
     * Set InstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentsScheduleId
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setInstallmentsScheduleId($installmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentsScheduleId) && !is_string($installmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentsScheduleId, true), gettype($installmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentsScheduleId, true)), __LINE__);
        }
        if (is_null($installmentsScheduleId) || (is_array($installmentsScheduleId) && empty($installmentsScheduleId))) {
            unset($this->InstallmentsScheduleId);
        } else {
            $this->InstallmentsScheduleId = $installmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get InstallmentsScheduleKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsScheduleKind()
    {
        return isset($this->InstallmentsScheduleKind) ? $this->InstallmentsScheduleKind : null;
    }
    /**
     * Set InstallmentsScheduleKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsScheduleKind
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setInstallmentsScheduleKind($installmentsScheduleKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentsScheduleKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentsScheduleKind) ? implode(', ', $installmentsScheduleKind) : var_export($installmentsScheduleKind, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        if (is_null($installmentsScheduleKind) || (is_array($installmentsScheduleKind) && empty($installmentsScheduleKind))) {
            unset($this->InstallmentsScheduleKind);
        } else {
            $this->InstallmentsScheduleKind = $installmentsScheduleKind;
        }
        return $this;
    }
    /**
     * Get NextDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextDueDate()
    {
        return isset($this->NextDueDate) ? $this->NextDueDate : null;
    }
    /**
     * Set NextDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextDueDate
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setNextDueDate($nextDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextDueDate) && !is_string($nextDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextDueDate, true), gettype($nextDueDate)), __LINE__);
        }
        if (is_null($nextDueDate) || (is_array($nextDueDate) && empty($nextDueDate))) {
            unset($this->NextDueDate);
        } else {
            $this->NextDueDate = $nextDueDate;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get PaidInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaidInstallments()
    {
        return isset($this->PaidInstallments) ? $this->PaidInstallments : null;
    }
    /**
     * Set PaidInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paidInstallments
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setPaidInstallments($paidInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($paidInstallments) && !(is_int($paidInstallments) || ctype_digit($paidInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paidInstallments, true), gettype($paidInstallments)), __LINE__);
        }
        if (is_null($paidInstallments) || (is_array($paidInstallments) && empty($paidInstallments))) {
            unset($this->PaidInstallments);
        } else {
            $this->PaidInstallments = $paidInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsScheduleStatus::valueIsValid()
     * @uses \patest\EnumType\InstallmentsScheduleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Payment_PaymentPlanPaymentItemInformation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsScheduleStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsScheduleStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\InstallmentsScheduleStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
