<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentMethod StructType
 * @subpackage Structs
 */
class Payment_PaymentMethod extends DistributableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AllowedDepositCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllowedDepositCategories
     */
    public $AllowedDepositCategories;
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Available;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EnablePayByLink
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnablePayByLink;
    /**
     * The FormName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormName;
    /**
     * The FormNameUnify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormNameUnify;
    /**
     * The InfoForClients
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfoForClients;
    /**
     * The InputFormLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InputFormLocalId;
    /**
     * The IsAlwaysPopupForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAlwaysPopupForm;
    /**
     * The IsCashDrawerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCashDrawerCount;
    /**
     * The IsForAutoRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForAutoRefund;
    /**
     * The IsForInternalUse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForInternalUse;
    /**
     * The IsSupportUnattendedPayments
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSupportUnattendedPayments;
    /**
     * The IsSupportUnboundRefund
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSupportUnboundRefund;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_PaymentMethodMedia
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PaymentMethodSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodSubType;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The ProviderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderCode;
    /**
     * The RefundPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundPolicy;
    /**
     * The SpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificData;
    /**
     * The SpecificEntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificEntityName;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The UnavailabilityReason
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnavailabilityReason;
    /**
     * The UsableToStoreToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsableToStoreToken;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usage;
    /**
     * The UseDifferentClientDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseDifferentClientDeposit;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Payment.PaymentMethod
     * @uses Payment_PaymentMethod::setAclSchemeId()
     * @uses Payment_PaymentMethod::setAllowedDepositCategories()
     * @uses Payment_PaymentMethod::setAvailable()
     * @uses Payment_PaymentMethod::setDescription()
     * @uses Payment_PaymentMethod::setEnablePayByLink()
     * @uses Payment_PaymentMethod::setFormName()
     * @uses Payment_PaymentMethod::setFormNameUnify()
     * @uses Payment_PaymentMethod::setInfoForClients()
     * @uses Payment_PaymentMethod::setInputFormLocalId()
     * @uses Payment_PaymentMethod::setIsAlwaysPopupForm()
     * @uses Payment_PaymentMethod::setIsCashDrawerCount()
     * @uses Payment_PaymentMethod::setIsForAutoRefund()
     * @uses Payment_PaymentMethod::setIsForInternalUse()
     * @uses Payment_PaymentMethod::setIsSupportUnattendedPayments()
     * @uses Payment_PaymentMethod::setIsSupportUnboundRefund()
     * @uses Payment_PaymentMethod::setIsSystem()
     * @uses Payment_PaymentMethod::setLedgerId()
     * @uses Payment_PaymentMethod::setMedia()
     * @uses Payment_PaymentMethod::setName()
     * @uses Payment_PaymentMethod::setOrdinal()
     * @uses Payment_PaymentMethod::setOrganizationUnitId()
     * @uses Payment_PaymentMethod::setPaymentMethodSubType()
     * @uses Payment_PaymentMethod::setPaymentMethodType()
     * @uses Payment_PaymentMethod::setProjectIdentifierId()
     * @uses Payment_PaymentMethod::setProviderCode()
     * @uses Payment_PaymentMethod::setRefundPolicy()
     * @uses Payment_PaymentMethod::setSpecificData()
     * @uses Payment_PaymentMethod::setSpecificEntityName()
     * @uses Payment_PaymentMethod::setSystemName()
     * @uses Payment_PaymentMethod::setUnavailabilityReason()
     * @uses Payment_PaymentMethod::setUsableToStoreToken()
     * @uses Payment_PaymentMethod::setUsage()
     * @uses Payment_PaymentMethod::setUseDifferentClientDeposit()
     * @uses Payment_PaymentMethod::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\AllowedDepositCategories $allowedDepositCategories
     * @param bool $available
     * @param \patest\StructType\GlobalString $description
     * @param bool $enablePayByLink
     * @param string $formName
     * @param string $formNameUnify
     * @param string $infoForClients
     * @param int $inputFormLocalId
     * @param bool $isAlwaysPopupForm
     * @param bool $isCashDrawerCount
     * @param bool $isForAutoRefund
     * @param bool $isForInternalUse
     * @param bool $isSupportUnattendedPayments
     * @param bool $isSupportUnboundRefund
     * @param bool $isSystem
     * @param string $ledgerId
     * @param \patest\StructType\Payment_PaymentMethodMedia $media
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param string $paymentMethodSubType
     * @param string $paymentMethodType
     * @param string $projectIdentifierId
     * @param string $providerCode
     * @param string $refundPolicy
     * @param string $specificData
     * @param string $specificEntityName
     * @param string $systemName
     * @param string $unavailabilityReason
     * @param bool $usableToStoreToken
     * @param string $usage
     * @param bool $useDifferentClientDeposit
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\AllowedDepositCategories $allowedDepositCategories = null, $available = null, \patest\StructType\GlobalString $description = null, $enablePayByLink = null, $formName = null, $formNameUnify = null, $infoForClients = null, $inputFormLocalId = null, $isAlwaysPopupForm = null, $isCashDrawerCount = null, $isForAutoRefund = null, $isForInternalUse = null, $isSupportUnattendedPayments = null, $isSupportUnboundRefund = null, $isSystem = null, $ledgerId = null, \patest\StructType\Payment_PaymentMethodMedia $media = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $organizationUnitId = null, $paymentMethodSubType = null, $paymentMethodType = null, $projectIdentifierId = null, $providerCode = null, $refundPolicy = null, $specificData = null, $specificEntityName = null, $systemName = null, $unavailabilityReason = null, $usableToStoreToken = null, $usage = null, $useDifferentClientDeposit = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAllowedDepositCategories($allowedDepositCategories)
            ->setAvailable($available)
            ->setDescription($description)
            ->setEnablePayByLink($enablePayByLink)
            ->setFormName($formName)
            ->setFormNameUnify($formNameUnify)
            ->setInfoForClients($infoForClients)
            ->setInputFormLocalId($inputFormLocalId)
            ->setIsAlwaysPopupForm($isAlwaysPopupForm)
            ->setIsCashDrawerCount($isCashDrawerCount)
            ->setIsForAutoRefund($isForAutoRefund)
            ->setIsForInternalUse($isForInternalUse)
            ->setIsSupportUnattendedPayments($isSupportUnattendedPayments)
            ->setIsSupportUnboundRefund($isSupportUnboundRefund)
            ->setIsSystem($isSystem)
            ->setLedgerId($ledgerId)
            ->setMedia($media)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPaymentMethodSubType($paymentMethodSubType)
            ->setPaymentMethodType($paymentMethodType)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setProviderCode($providerCode)
            ->setRefundPolicy($refundPolicy)
            ->setSpecificData($specificData)
            ->setSpecificEntityName($specificEntityName)
            ->setSystemName($systemName)
            ->setUnavailabilityReason($unavailabilityReason)
            ->setUsableToStoreToken($usableToStoreToken)
            ->setUsage($usage)
            ->setUseDifferentClientDeposit($useDifferentClientDeposit)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AllowedDepositCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllowedDepositCategories|null
     */
    public function getAllowedDepositCategories()
    {
        return isset($this->AllowedDepositCategories) ? $this->AllowedDepositCategories : null;
    }
    /**
     * Set AllowedDepositCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllowedDepositCategories $allowedDepositCategories
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setAllowedDepositCategories(\patest\StructType\AllowedDepositCategories $allowedDepositCategories = null)
    {
        if (is_null($allowedDepositCategories) || (is_array($allowedDepositCategories) && empty($allowedDepositCategories))) {
            unset($this->AllowedDepositCategories);
        } else {
            $this->AllowedDepositCategories = $allowedDepositCategories;
        }
        return $this;
    }
    /**
     * Get Available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAvailable()
    {
        return isset($this->Available) ? $this->Available : null;
    }
    /**
     * Set Available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $available
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: boolean
        if (!is_null($available) && !is_bool($available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        if (is_null($available) || (is_array($available) && empty($available))) {
            unset($this->Available);
        } else {
            $this->Available = $available;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnablePayByLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnablePayByLink()
    {
        return isset($this->EnablePayByLink) ? $this->EnablePayByLink : null;
    }
    /**
     * Set EnablePayByLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enablePayByLink
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setEnablePayByLink($enablePayByLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($enablePayByLink) && !is_bool($enablePayByLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enablePayByLink, true), gettype($enablePayByLink)), __LINE__);
        }
        if (is_null($enablePayByLink) || (is_array($enablePayByLink) && empty($enablePayByLink))) {
            unset($this->EnablePayByLink);
        } else {
            $this->EnablePayByLink = $enablePayByLink;
        }
        return $this;
    }
    /**
     * Get FormName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormName()
    {
        return isset($this->FormName) ? $this->FormName : null;
    }
    /**
     * Set FormName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formName
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setFormName($formName = null)
    {
        // validation for constraint: string
        if (!is_null($formName) && !is_string($formName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formName, true), gettype($formName)), __LINE__);
        }
        if (is_null($formName) || (is_array($formName) && empty($formName))) {
            unset($this->FormName);
        } else {
            $this->FormName = $formName;
        }
        return $this;
    }
    /**
     * Get FormNameUnify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormNameUnify()
    {
        return isset($this->FormNameUnify) ? $this->FormNameUnify : null;
    }
    /**
     * Set FormNameUnify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formNameUnify
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setFormNameUnify($formNameUnify = null)
    {
        // validation for constraint: string
        if (!is_null($formNameUnify) && !is_string($formNameUnify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNameUnify, true), gettype($formNameUnify)), __LINE__);
        }
        if (is_null($formNameUnify) || (is_array($formNameUnify) && empty($formNameUnify))) {
            unset($this->FormNameUnify);
        } else {
            $this->FormNameUnify = $formNameUnify;
        }
        return $this;
    }
    /**
     * Get InfoForClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfoForClients()
    {
        return isset($this->InfoForClients) ? $this->InfoForClients : null;
    }
    /**
     * Set InfoForClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infoForClients
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setInfoForClients($infoForClients = null)
    {
        // validation for constraint: string
        if (!is_null($infoForClients) && !is_string($infoForClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoForClients, true), gettype($infoForClients)), __LINE__);
        }
        if (is_null($infoForClients) || (is_array($infoForClients) && empty($infoForClients))) {
            unset($this->InfoForClients);
        } else {
            $this->InfoForClients = $infoForClients;
        }
        return $this;
    }
    /**
     * Get InputFormLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInputFormLocalId()
    {
        return isset($this->InputFormLocalId) ? $this->InputFormLocalId : null;
    }
    /**
     * Set InputFormLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inputFormLocalId
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setInputFormLocalId($inputFormLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($inputFormLocalId) && !(is_int($inputFormLocalId) || ctype_digit($inputFormLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inputFormLocalId, true), gettype($inputFormLocalId)), __LINE__);
        }
        if (is_null($inputFormLocalId) || (is_array($inputFormLocalId) && empty($inputFormLocalId))) {
            unset($this->InputFormLocalId);
        } else {
            $this->InputFormLocalId = $inputFormLocalId;
        }
        return $this;
    }
    /**
     * Get IsAlwaysPopupForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAlwaysPopupForm()
    {
        return isset($this->IsAlwaysPopupForm) ? $this->IsAlwaysPopupForm : null;
    }
    /**
     * Set IsAlwaysPopupForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAlwaysPopupForm
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsAlwaysPopupForm($isAlwaysPopupForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlwaysPopupForm) && !is_bool($isAlwaysPopupForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlwaysPopupForm, true), gettype($isAlwaysPopupForm)), __LINE__);
        }
        if (is_null($isAlwaysPopupForm) || (is_array($isAlwaysPopupForm) && empty($isAlwaysPopupForm))) {
            unset($this->IsAlwaysPopupForm);
        } else {
            $this->IsAlwaysPopupForm = $isAlwaysPopupForm;
        }
        return $this;
    }
    /**
     * Get IsCashDrawerCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCashDrawerCount()
    {
        return isset($this->IsCashDrawerCount) ? $this->IsCashDrawerCount : null;
    }
    /**
     * Set IsCashDrawerCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCashDrawerCount
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsCashDrawerCount($isCashDrawerCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCashDrawerCount) && !is_bool($isCashDrawerCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCashDrawerCount, true), gettype($isCashDrawerCount)), __LINE__);
        }
        if (is_null($isCashDrawerCount) || (is_array($isCashDrawerCount) && empty($isCashDrawerCount))) {
            unset($this->IsCashDrawerCount);
        } else {
            $this->IsCashDrawerCount = $isCashDrawerCount;
        }
        return $this;
    }
    /**
     * Get IsForAutoRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForAutoRefund()
    {
        return isset($this->IsForAutoRefund) ? $this->IsForAutoRefund : null;
    }
    /**
     * Set IsForAutoRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForAutoRefund
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsForAutoRefund($isForAutoRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForAutoRefund) && !is_bool($isForAutoRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForAutoRefund, true), gettype($isForAutoRefund)), __LINE__);
        }
        if (is_null($isForAutoRefund) || (is_array($isForAutoRefund) && empty($isForAutoRefund))) {
            unset($this->IsForAutoRefund);
        } else {
            $this->IsForAutoRefund = $isForAutoRefund;
        }
        return $this;
    }
    /**
     * Get IsForInternalUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForInternalUse()
    {
        return isset($this->IsForInternalUse) ? $this->IsForInternalUse : null;
    }
    /**
     * Set IsForInternalUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForInternalUse
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsForInternalUse($isForInternalUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForInternalUse) && !is_bool($isForInternalUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForInternalUse, true), gettype($isForInternalUse)), __LINE__);
        }
        if (is_null($isForInternalUse) || (is_array($isForInternalUse) && empty($isForInternalUse))) {
            unset($this->IsForInternalUse);
        } else {
            $this->IsForInternalUse = $isForInternalUse;
        }
        return $this;
    }
    /**
     * Get IsSupportUnattendedPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSupportUnattendedPayments()
    {
        return isset($this->IsSupportUnattendedPayments) ? $this->IsSupportUnattendedPayments : null;
    }
    /**
     * Set IsSupportUnattendedPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSupportUnattendedPayments
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsSupportUnattendedPayments($isSupportUnattendedPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportUnattendedPayments) && !is_bool($isSupportUnattendedPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportUnattendedPayments, true), gettype($isSupportUnattendedPayments)), __LINE__);
        }
        if (is_null($isSupportUnattendedPayments) || (is_array($isSupportUnattendedPayments) && empty($isSupportUnattendedPayments))) {
            unset($this->IsSupportUnattendedPayments);
        } else {
            $this->IsSupportUnattendedPayments = $isSupportUnattendedPayments;
        }
        return $this;
    }
    /**
     * Get IsSupportUnboundRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSupportUnboundRefund()
    {
        return isset($this->IsSupportUnboundRefund) ? $this->IsSupportUnboundRefund : null;
    }
    /**
     * Set IsSupportUnboundRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSupportUnboundRefund
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsSupportUnboundRefund($isSupportUnboundRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportUnboundRefund) && !is_bool($isSupportUnboundRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportUnboundRefund, true), gettype($isSupportUnboundRefund)), __LINE__);
        }
        if (is_null($isSupportUnboundRefund) || (is_array($isSupportUnboundRefund) && empty($isSupportUnboundRefund))) {
            unset($this->IsSupportUnboundRefund);
        } else {
            $this->IsSupportUnboundRefund = $isSupportUnboundRefund;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_PaymentMethodMedia|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_PaymentMethodMedia $media
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setMedia(\patest\StructType\Payment_PaymentMethodMedia $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodSubType()
    {
        return isset($this->PaymentMethodSubType) ? $this->PaymentMethodSubType : null;
    }
    /**
     * Set PaymentMethodSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodSubType
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setPaymentMethodSubType($paymentMethodSubType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodSubType) && !is_string($paymentMethodSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodSubType, true), gettype($paymentMethodSubType)), __LINE__);
        }
        if (is_null($paymentMethodSubType) || (is_array($paymentMethodSubType) && empty($paymentMethodSubType))) {
            unset($this->PaymentMethodSubType);
        } else {
            $this->PaymentMethodSubType = $paymentMethodSubType;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get ProviderCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderCode()
    {
        return isset($this->ProviderCode) ? $this->ProviderCode : null;
    }
    /**
     * Set ProviderCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerCode
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setProviderCode($providerCode = null)
    {
        // validation for constraint: string
        if (!is_null($providerCode) && !is_string($providerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerCode, true), gettype($providerCode)), __LINE__);
        }
        if (is_null($providerCode) || (is_array($providerCode) && empty($providerCode))) {
            unset($this->ProviderCode);
        } else {
            $this->ProviderCode = $providerCode;
        }
        return $this;
    }
    /**
     * Get RefundPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundPolicy()
    {
        return isset($this->RefundPolicy) ? $this->RefundPolicy : null;
    }
    /**
     * Set RefundPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodRefundPolicy::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodRefundPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refundPolicy
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setRefundPolicy($refundPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodRefundPolicy::valueIsValid($refundPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodRefundPolicy', is_array($refundPolicy) ? implode(', ', $refundPolicy) : var_export($refundPolicy, true), implode(', ', \patest\EnumType\PaymentMethodRefundPolicy::getValidValues())), __LINE__);
        }
        if (is_null($refundPolicy) || (is_array($refundPolicy) && empty($refundPolicy))) {
            unset($this->RefundPolicy);
        } else {
            $this->RefundPolicy = $refundPolicy;
        }
        return $this;
    }
    /**
     * Get SpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificData()
    {
        return isset($this->SpecificData) ? $this->SpecificData : null;
    }
    /**
     * Set SpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificData
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setSpecificData($specificData = null)
    {
        // validation for constraint: string
        if (!is_null($specificData) && !is_string($specificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificData, true), gettype($specificData)), __LINE__);
        }
        if (is_null($specificData) || (is_array($specificData) && empty($specificData))) {
            unset($this->SpecificData);
        } else {
            $this->SpecificData = $specificData;
        }
        return $this;
    }
    /**
     * Get SpecificEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificEntityName()
    {
        return isset($this->SpecificEntityName) ? $this->SpecificEntityName : null;
    }
    /**
     * Set SpecificEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificEntityName
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setSpecificEntityName($specificEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($specificEntityName) && !is_string($specificEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificEntityName, true), gettype($specificEntityName)), __LINE__);
        }
        if (is_null($specificEntityName) || (is_array($specificEntityName) && empty($specificEntityName))) {
            unset($this->SpecificEntityName);
        } else {
            $this->SpecificEntityName = $specificEntityName;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get UnavailabilityReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnavailabilityReason()
    {
        return isset($this->UnavailabilityReason) ? $this->UnavailabilityReason : null;
    }
    /**
     * Set UnavailabilityReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unavailabilityReason
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setUnavailabilityReason($unavailabilityReason = null)
    {
        // validation for constraint: string
        if (!is_null($unavailabilityReason) && !is_string($unavailabilityReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unavailabilityReason, true), gettype($unavailabilityReason)), __LINE__);
        }
        if (is_null($unavailabilityReason) || (is_array($unavailabilityReason) && empty($unavailabilityReason))) {
            unset($this->UnavailabilityReason);
        } else {
            $this->UnavailabilityReason = $unavailabilityReason;
        }
        return $this;
    }
    /**
     * Get UsableToStoreToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsableToStoreToken()
    {
        return isset($this->UsableToStoreToken) ? $this->UsableToStoreToken : null;
    }
    /**
     * Set UsableToStoreToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usableToStoreToken
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setUsableToStoreToken($usableToStoreToken = null)
    {
        // validation for constraint: boolean
        if (!is_null($usableToStoreToken) && !is_bool($usableToStoreToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usableToStoreToken, true), gettype($usableToStoreToken)), __LINE__);
        }
        if (is_null($usableToStoreToken) || (is_array($usableToStoreToken) && empty($usableToStoreToken))) {
            unset($this->UsableToStoreToken);
        } else {
            $this->UsableToStoreToken = $usableToStoreToken;
        }
        return $this;
    }
    /**
     * Get Usage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsage()
    {
        return isset($this->Usage) ? $this->Usage : null;
    }
    /**
     * Set Usage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodUsage::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \patest\EnumType\PaymentMethodUsage::getValidValues())), __LINE__);
        }
        if (is_null($usage) || (is_array($usage) && empty($usage))) {
            unset($this->Usage);
        } else {
            $this->Usage = $usage;
        }
        return $this;
    }
    /**
     * Get UseDifferentClientDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseDifferentClientDeposit()
    {
        return isset($this->UseDifferentClientDeposit) ? $this->UseDifferentClientDeposit : null;
    }
    /**
     * Set UseDifferentClientDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useDifferentClientDeposit
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setUseDifferentClientDeposit($useDifferentClientDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDifferentClientDeposit) && !is_bool($useDifferentClientDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useDifferentClientDeposit, true), gettype($useDifferentClientDeposit)), __LINE__);
        }
        if (is_null($useDifferentClientDeposit) || (is_array($useDifferentClientDeposit) && empty($useDifferentClientDeposit))) {
            unset($this->UseDifferentClientDeposit);
        } else {
            $this->UseDifferentClientDeposit = $useDifferentClientDeposit;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Payment_PaymentMethod
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
