<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentDeductionItem StructType
 * @subpackage Structs
 */
class Payment_PaymentDeductionItem extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemType;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalAmount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The WithInvoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WithInvoice;
    /**
     * Constructor method for Payment.PaymentDeductionItem
     * @uses Payment_PaymentDeductionItem::setClientId()
     * @uses Payment_PaymentDeductionItem::setHolderCompanyId()
     * @uses Payment_PaymentDeductionItem::setId()
     * @uses Payment_PaymentDeductionItem::setInvoiceId()
     * @uses Payment_PaymentDeductionItem::setItemType()
     * @uses Payment_PaymentDeductionItem::setOriginalAmount()
     * @uses Payment_PaymentDeductionItem::setTransactionGuid()
     * @uses Payment_PaymentDeductionItem::setWithInvoice()
     * @param string $clientId
     * @param int $holderCompanyId
     * @param string $id
     * @param string $invoiceId
     * @param string $itemType
     * @param \patest\StructType\Money $originalAmount
     * @param string $transactionGuid
     * @param bool $withInvoice
     */
    public function __construct($clientId = null, $holderCompanyId = null, $id = null, $invoiceId = null, $itemType = null, \patest\StructType\Money $originalAmount = null, $transactionGuid = null, $withInvoice = null)
    {
        $this
            ->setClientId($clientId)
            ->setHolderCompanyId($holderCompanyId)
            ->setId($id)
            ->setInvoiceId($invoiceId)
            ->setItemType($itemType)
            ->setOriginalAmount($originalAmount)
            ->setTransactionGuid($transactionGuid)
            ->setWithInvoice($withInvoice);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DeductionItemKind::valueIsValid()
     * @uses \patest\EnumType\DeductionItemKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DeductionItemKind::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DeductionItemKind', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \patest\EnumType\DeductionItemKind::getValidValues())), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalAmount()
    {
        return isset($this->OriginalAmount) ? $this->OriginalAmount : null;
    }
    /**
     * Set OriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalAmount
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setOriginalAmount(\patest\StructType\Money $originalAmount = null)
    {
        if (is_null($originalAmount) || (is_array($originalAmount) && empty($originalAmount))) {
            unset($this->OriginalAmount);
        } else {
            $this->OriginalAmount = $originalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get WithInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWithInvoice()
    {
        return isset($this->WithInvoice) ? $this->WithInvoice : null;
    }
    /**
     * Set WithInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $withInvoice
     * @return \patest\StructType\Payment_PaymentDeductionItem
     */
    public function setWithInvoice($withInvoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($withInvoice) && !is_bool($withInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withInvoice, true), gettype($withInvoice)), __LINE__);
        }
        if (is_null($withInvoice) || (is_array($withInvoice) && empty($withInvoice))) {
            unset($this->WithInvoice);
        } else {
            $this->WithInvoice = $withInvoice;
        }
        return $this;
    }
}
