<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_DirectDebitPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Authorized;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The CollectDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectDate;
    /**
     * The CollectPaymentOnDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CollectPaymentOnDay;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The MandateExpirationInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateExpirationInDays;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MandateOnlyForThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MandateOnlyForThisTransaction;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Payment.DirectDebitPaymentItemInformation
     * @uses Payment_DirectDebitPaymentItemInformation::setAccountName()
     * @uses Payment_DirectDebitPaymentItemInformation::setAccountNumber()
     * @uses Payment_DirectDebitPaymentItemInformation::setAuthorized()
     * @uses Payment_DirectDebitPaymentItemInformation::setBankAddress()
     * @uses Payment_DirectDebitPaymentItemInformation::setBankCode()
     * @uses Payment_DirectDebitPaymentItemInformation::setBankName()
     * @uses Payment_DirectDebitPaymentItemInformation::setCollectDate()
     * @uses Payment_DirectDebitPaymentItemInformation::setCollectPaymentOnDay()
     * @uses Payment_DirectDebitPaymentItemInformation::setInstallments()
     * @uses Payment_DirectDebitPaymentItemInformation::setMandateExpirationInDays()
     * @uses Payment_DirectDebitPaymentItemInformation::setMandateNumber()
     * @uses Payment_DirectDebitPaymentItemInformation::setMandateOnlyForThisTransaction()
     * @uses Payment_DirectDebitPaymentItemInformation::setMandateTypeId()
     * @uses Payment_DirectDebitPaymentItemInformation::setStatus()
     * @param string $accountName
     * @param string $accountNumber
     * @param bool $authorized
     * @param string $bankAddress
     * @param string $bankCode
     * @param string $bankName
     * @param string $collectDate
     * @param int $collectPaymentOnDay
     * @param int $installments
     * @param int $mandateExpirationInDays
     * @param int $mandateNumber
     * @param bool $mandateOnlyForThisTransaction
     * @param string $mandateTypeId
     * @param string $status
     */
    public function __construct($accountName = null, $accountNumber = null, $authorized = null, $bankAddress = null, $bankCode = null, $bankName = null, $collectDate = null, $collectPaymentOnDay = null, $installments = null, $mandateExpirationInDays = null, $mandateNumber = null, $mandateOnlyForThisTransaction = null, $mandateTypeId = null, $status = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setAuthorized($authorized)
            ->setBankAddress($bankAddress)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setCollectDate($collectDate)
            ->setCollectPaymentOnDay($collectPaymentOnDay)
            ->setInstallments($installments)
            ->setMandateExpirationInDays($mandateExpirationInDays)
            ->setMandateNumber($mandateNumber)
            ->setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction)
            ->setMandateTypeId($mandateTypeId)
            ->setStatus($status);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAuthorized()
    {
        return isset($this->Authorized) ? $this->Authorized : null;
    }
    /**
     * Set Authorized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $authorized
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        if (is_null($authorized) || (is_array($authorized) && empty($authorized))) {
            unset($this->Authorized);
        } else {
            $this->Authorized = $authorized;
        }
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get CollectDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectDate()
    {
        return isset($this->CollectDate) ? $this->CollectDate : null;
    }
    /**
     * Set CollectDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectDate
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setCollectDate($collectDate = null)
    {
        // validation for constraint: string
        if (!is_null($collectDate) && !is_string($collectDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectDate, true), gettype($collectDate)), __LINE__);
        }
        if (is_null($collectDate) || (is_array($collectDate) && empty($collectDate))) {
            unset($this->CollectDate);
        } else {
            $this->CollectDate = $collectDate;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCollectPaymentOnDay()
    {
        return isset($this->CollectPaymentOnDay) ? $this->CollectPaymentOnDay : null;
    }
    /**
     * Set CollectPaymentOnDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $collectPaymentOnDay
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setCollectPaymentOnDay($collectPaymentOnDay = null)
    {
        // validation for constraint: int
        if (!is_null($collectPaymentOnDay) && !(is_int($collectPaymentOnDay) || ctype_digit($collectPaymentOnDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectPaymentOnDay, true), gettype($collectPaymentOnDay)), __LINE__);
        }
        if (is_null($collectPaymentOnDay) || (is_array($collectPaymentOnDay) && empty($collectPaymentOnDay))) {
            unset($this->CollectPaymentOnDay);
        } else {
            $this->CollectPaymentOnDay = $collectPaymentOnDay;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get MandateExpirationInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateExpirationInDays()
    {
        return isset($this->MandateExpirationInDays) ? $this->MandateExpirationInDays : null;
    }
    /**
     * Set MandateExpirationInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateExpirationInDays
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setMandateExpirationInDays($mandateExpirationInDays = null)
    {
        // validation for constraint: int
        if (!is_null($mandateExpirationInDays) && !(is_int($mandateExpirationInDays) || ctype_digit($mandateExpirationInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateExpirationInDays, true), gettype($mandateExpirationInDays)), __LINE__);
        }
        if (is_null($mandateExpirationInDays) || (is_array($mandateExpirationInDays) && empty($mandateExpirationInDays))) {
            unset($this->MandateExpirationInDays);
        } else {
            $this->MandateExpirationInDays = $mandateExpirationInDays;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateOnlyForThisTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMandateOnlyForThisTransaction()
    {
        return isset($this->MandateOnlyForThisTransaction) ? $this->MandateOnlyForThisTransaction : null;
    }
    /**
     * Set MandateOnlyForThisTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mandateOnlyForThisTransaction
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateOnlyForThisTransaction) && !is_bool($mandateOnlyForThisTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateOnlyForThisTransaction, true), gettype($mandateOnlyForThisTransaction)), __LINE__);
        }
        if (is_null($mandateOnlyForThisTransaction) || (is_array($mandateOnlyForThisTransaction) && empty($mandateOnlyForThisTransaction))) {
            unset($this->MandateOnlyForThisTransaction);
        } else {
            $this->MandateOnlyForThisTransaction = $mandateOnlyForThisTransaction;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Payment_DirectDebitPaymentItemInformation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
