<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitInstallmentPaymentItem StructType
 * @subpackage Structs
 */
class Payment_DirectDebitInstallmentPaymentItem extends Payment_PaymentItem
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The InstallmentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended
     */
    public $InstallmentDetails;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.DirectDebitInstallmentPaymentItem
     * @uses Payment_DirectDebitInstallmentPaymentItem::setDetails()
     * @uses Payment_DirectDebitInstallmentPaymentItem::setInstallmentDetails()
     * @uses Payment_DirectDebitInstallmentPaymentItem::setTransactionNumber()
     * @param string $details
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended $installmentDetails
     * @param string $transactionNumber
     */
    public function __construct($details = null, \patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended $installmentDetails = null, $transactionNumber = null)
    {
        $this
            ->setDetails($details)
            ->setInstallmentDetails($installmentDetails)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Payment_DirectDebitInstallmentPaymentItem
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get InstallmentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended|null
     */
    public function getInstallmentDetails()
    {
        return isset($this->InstallmentDetails) ? $this->InstallmentDetails : null;
    }
    /**
     * Set InstallmentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended $installmentDetails
     * @return \patest\StructType\Payment_DirectDebitInstallmentPaymentItem
     */
    public function setInstallmentDetails(\patest\StructType\RecordSetOfPayment_DirectDebitPaymentExtended $installmentDetails = null)
    {
        if (is_null($installmentDetails) || (is_array($installmentDetails) && empty($installmentDetails))) {
            unset($this->InstallmentDetails);
        } else {
            $this->InstallmentDetails = $installmentDetails;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNumber
     * @return \patest\StructType\Payment_DirectDebitInstallmentPaymentItem
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
