<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CouponPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_CouponPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The CouponId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CouponId;
    /**
     * The CouponName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponName;
    /**
     * Constructor method for Payment.CouponPaymentItemInformation
     * @uses Payment_CouponPaymentItemInformation::setCouponId()
     * @uses Payment_CouponPaymentItemInformation::setCouponName()
     * @param string $couponId
     * @param string $couponName
     */
    public function __construct($couponId = null, $couponName = null)
    {
        $this
            ->setCouponId($couponId)
            ->setCouponName($couponName);
    }
    /**
     * Get CouponId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponId()
    {
        return isset($this->CouponId) ? $this->CouponId : null;
    }
    /**
     * Set CouponId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponId
     * @return \patest\StructType\Payment_CouponPaymentItemInformation
     */
    public function setCouponId($couponId = null)
    {
        // validation for constraint: string
        if (!is_null($couponId) && !is_string($couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponId, true), gettype($couponId)), __LINE__);
        }
        if (is_null($couponId) || (is_array($couponId) && empty($couponId))) {
            unset($this->CouponId);
        } else {
            $this->CouponId = $couponId;
        }
        return $this;
    }
    /**
     * Get CouponName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponName()
    {
        return isset($this->CouponName) ? $this->CouponName : null;
    }
    /**
     * Set CouponName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponName
     * @return \patest\StructType\Payment_CouponPaymentItemInformation
     */
    public function setCouponName($couponName = null)
    {
        // validation for constraint: string
        if (!is_null($couponName) && !is_string($couponName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponName, true), gettype($couponName)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponName) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponName, true)), __LINE__);
        }
        if (is_null($couponName) || (is_array($couponName) && empty($couponName))) {
            unset($this->CouponName);
        } else {
            $this->CouponName = $couponName;
        }
        return $this;
    }
}
