<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CashDrawerBalanceCount StructType
 * @subpackage Structs
 */
class Payment_CashDrawerBalanceCount extends PersistableEntity
{
    /**
     * The CashEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_CashEntry
     */
    public $CashEntries;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CreationUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreationUserId;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LastUpdateUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastUpdateUserId;
    /**
     * The NonCashEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_NonCashEntry
     */
    public $NonCashEntries;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The ShiftNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShiftNum;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * Constructor method for Payment.CashDrawerBalanceCount
     * @uses Payment_CashDrawerBalanceCount::setCashEntries()
     * @uses Payment_CashDrawerBalanceCount::setCreationDateTime()
     * @uses Payment_CashDrawerBalanceCount::setCreationUserId()
     * @uses Payment_CashDrawerBalanceCount::setLastUpdateDateTime()
     * @uses Payment_CashDrawerBalanceCount::setLastUpdateUserId()
     * @uses Payment_CashDrawerBalanceCount::setNonCashEntries()
     * @uses Payment_CashDrawerBalanceCount::setRemark()
     * @uses Payment_CashDrawerBalanceCount::setShiftNum()
     * @uses Payment_CashDrawerBalanceCount::setTillId()
     * @param \patest\StructType\RecordSetOfPayment_CashEntry $cashEntries
     * @param string $creationDateTime
     * @param string $creationUserId
     * @param string $lastUpdateDateTime
     * @param string $lastUpdateUserId
     * @param \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries
     * @param string $remark
     * @param int $shiftNum
     * @param string $tillId
     */
    public function __construct(\patest\StructType\RecordSetOfPayment_CashEntry $cashEntries = null, $creationDateTime = null, $creationUserId = null, $lastUpdateDateTime = null, $lastUpdateUserId = null, \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries = null, $remark = null, $shiftNum = null, $tillId = null)
    {
        $this
            ->setCashEntries($cashEntries)
            ->setCreationDateTime($creationDateTime)
            ->setCreationUserId($creationUserId)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLastUpdateUserId($lastUpdateUserId)
            ->setNonCashEntries($nonCashEntries)
            ->setRemark($remark)
            ->setShiftNum($shiftNum)
            ->setTillId($tillId);
    }
    /**
     * Get CashEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_CashEntry|null
     */
    public function getCashEntries()
    {
        return isset($this->CashEntries) ? $this->CashEntries : null;
    }
    /**
     * Set CashEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_CashEntry $cashEntries
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setCashEntries(\patest\StructType\RecordSetOfPayment_CashEntry $cashEntries = null)
    {
        if (is_null($cashEntries) || (is_array($cashEntries) && empty($cashEntries))) {
            unset($this->CashEntries);
        } else {
            $this->CashEntries = $cashEntries;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CreationUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationUserId()
    {
        return isset($this->CreationUserId) ? $this->CreationUserId : null;
    }
    /**
     * Set CreationUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationUserId
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setCreationUserId($creationUserId = null)
    {
        // validation for constraint: string
        if (!is_null($creationUserId) && !is_string($creationUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationUserId, true), gettype($creationUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creationUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creationUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creationUserId, true)), __LINE__);
        }
        if (is_null($creationUserId) || (is_array($creationUserId) && empty($creationUserId))) {
            unset($this->CreationUserId);
        } else {
            $this->CreationUserId = $creationUserId;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LastUpdateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateUserId()
    {
        return isset($this->LastUpdateUserId) ? $this->LastUpdateUserId : null;
    }
    /**
     * Set LastUpdateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateUserId
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setLastUpdateUserId($lastUpdateUserId = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserId) && !is_string($lastUpdateUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateUserId, true), gettype($lastUpdateUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastUpdateUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastUpdateUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastUpdateUserId, true)), __LINE__);
        }
        if (is_null($lastUpdateUserId) || (is_array($lastUpdateUserId) && empty($lastUpdateUserId))) {
            unset($this->LastUpdateUserId);
        } else {
            $this->LastUpdateUserId = $lastUpdateUserId;
        }
        return $this;
    }
    /**
     * Get NonCashEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_NonCashEntry|null
     */
    public function getNonCashEntries()
    {
        return isset($this->NonCashEntries) ? $this->NonCashEntries : null;
    }
    /**
     * Set NonCashEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setNonCashEntries(\patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries = null)
    {
        if (is_null($nonCashEntries) || (is_array($nonCashEntries) && empty($nonCashEntries))) {
            unset($this->NonCashEntries);
        } else {
            $this->NonCashEntries = $nonCashEntries;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get ShiftNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShiftNum()
    {
        return isset($this->ShiftNum) ? $this->ShiftNum : null;
    }
    /**
     * Set ShiftNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $shiftNum
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setShiftNum($shiftNum = null)
    {
        // validation for constraint: int
        if (!is_null($shiftNum) && !(is_int($shiftNum) || ctype_digit($shiftNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shiftNum, true), gettype($shiftNum)), __LINE__);
        }
        if (is_null($shiftNum) || (is_array($shiftNum) && empty($shiftNum))) {
            unset($this->ShiftNum);
        } else {
            $this->ShiftNum = $shiftNum;
        }
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\Payment_CashDrawerBalanceCount
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
}
