<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CancellationPaymentMethod StructType
 * @subpackage Structs
 */
class Payment_CancellationPaymentMethod extends DistributableEntity
{
    /**
     * The OriginalPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPaymentMethodId;
    /**
     * The ReimbursementPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReimbursementPaymentMethodId;
    /**
     * Constructor method for Payment.CancellationPaymentMethod
     * @uses Payment_CancellationPaymentMethod::setOriginalPaymentMethodId()
     * @uses Payment_CancellationPaymentMethod::setReimbursementPaymentMethodId()
     * @param string $originalPaymentMethodId
     * @param string $reimbursementPaymentMethodId
     */
    public function __construct($originalPaymentMethodId = null, $reimbursementPaymentMethodId = null)
    {
        $this
            ->setOriginalPaymentMethodId($originalPaymentMethodId)
            ->setReimbursementPaymentMethodId($reimbursementPaymentMethodId);
    }
    /**
     * Get OriginalPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentMethodId()
    {
        return isset($this->OriginalPaymentMethodId) ? $this->OriginalPaymentMethodId : null;
    }
    /**
     * Set OriginalPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentMethodId
     * @return \patest\StructType\Payment_CancellationPaymentMethod
     */
    public function setOriginalPaymentMethodId($originalPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentMethodId) && !is_string($originalPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentMethodId, true), gettype($originalPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPaymentMethodId, true)), __LINE__);
        }
        if (is_null($originalPaymentMethodId) || (is_array($originalPaymentMethodId) && empty($originalPaymentMethodId))) {
            unset($this->OriginalPaymentMethodId);
        } else {
            $this->OriginalPaymentMethodId = $originalPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get ReimbursementPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReimbursementPaymentMethodId()
    {
        return isset($this->ReimbursementPaymentMethodId) ? $this->ReimbursementPaymentMethodId : null;
    }
    /**
     * Set ReimbursementPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reimbursementPaymentMethodId
     * @return \patest\StructType\Payment_CancellationPaymentMethod
     */
    public function setReimbursementPaymentMethodId($reimbursementPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($reimbursementPaymentMethodId) && !is_string($reimbursementPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reimbursementPaymentMethodId, true), gettype($reimbursementPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reimbursementPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reimbursementPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reimbursementPaymentMethodId, true)), __LINE__);
        }
        if (is_null($reimbursementPaymentMethodId) || (is_array($reimbursementPaymentMethodId) && empty($reimbursementPaymentMethodId))) {
            unset($this->ReimbursementPaymentMethodId);
        } else {
            $this->ReimbursementPaymentMethodId = $reimbursementPaymentMethodId;
        }
        return $this;
    }
}
