<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.BankTransferPaymentExtended StructType
 * @subpackage Structs
 */
class Payment_BankTransferPaymentExtended extends Payment_BankTransferPayment
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The ClientCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCurrencyCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Payment.BankTransferPaymentExtended
     * @uses Payment_BankTransferPaymentExtended::setClientAmount()
     * @uses Payment_BankTransferPaymentExtended::setClientCurrencyCode()
     * @uses Payment_BankTransferPaymentExtended::setStatus()
     * @uses Payment_BankTransferPaymentExtended::setTransactionGuid()
     * @param \patest\StructType\Money $clientAmount
     * @param string $clientCurrencyCode
     * @param string $status
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $clientCurrencyCode = null, $status = null, $transactionGuid = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setClientCurrencyCode($clientCurrencyCode)
            ->setStatus($status)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_BankTransferPaymentExtended
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get ClientCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCurrencyCode()
    {
        return isset($this->ClientCurrencyCode) ? $this->ClientCurrencyCode : null;
    }
    /**
     * Set ClientCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCurrencyCode
     * @return \patest\StructType\Payment_BankTransferPaymentExtended
     */
    public function setClientCurrencyCode($clientCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCurrencyCode) && !is_string($clientCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCurrencyCode, true), gettype($clientCurrencyCode)), __LINE__);
        }
        if (is_null($clientCurrencyCode) || (is_array($clientCurrencyCode) && empty($clientCurrencyCode))) {
            unset($this->ClientCurrencyCode);
        } else {
            $this->ClientCurrencyCode = $clientCurrencyCode;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Payment_BankTransferPaymentExtended
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_BankTransferPaymentExtended
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
